/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource.remote;

import com.oceanbase.tools.loaddump.resource.remote.FileUploader;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileUploader
implements FileUploader {
    private static final Logger log = LoggerFactory.getLogger(AbstractFileUploader.class);
    protected static final int MAX_POOL_SIZE = 3;
    protected boolean useCustomPath;
    protected String filePath;
    protected ConcurrentHashMap<File, AtomicLong> bytesWrittenMap = new ConcurrentHashMap();

    public AbstractFileUploader(String filePath, boolean useCustomPath) {
        this.filePath = filePath;
        this.useCustomPath = useCustomPath;
    }

    protected String assembleObjectKey(File file, String prefix) {
        String key = this.useCustomPath ? FileUtils.toPath(prefix, file.getAbsolutePath()) : (JvmArgs.isBackupRestoreMode ? FileUtils.toPath(prefix, file.getName()) : FileUtils.toPath(prefix, StringUtils.substringAfterLast((String)file.getAbsolutePath(), (String)this.filePath)));
        return StringUtils.isEmpty((CharSequence)prefix) ? key.substring(1) : key;
    }

    public void setUseCustomPath(boolean useCustomPath) {
        this.useCustomPath = useCustomPath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public ConcurrentHashMap<File, AtomicLong> getBytesWrittenMap() {
        return this.bytesWrittenMap;
    }
}

