/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource.remote.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.model.UploadFileRequest;
import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.OssStorageConfig;
import com.oceanbase.tools.loaddump.factory.OssClientPoolFactory;
import com.oceanbase.tools.loaddump.resource.remote.AbstractFileUploader;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssFileUploader
extends AbstractFileUploader {
    private static final Logger log = LoggerFactory.getLogger(OssFileUploader.class);
    private final OssStorageConfig config;
    private final GenericKeyedObjectPool<OssStorageConfig, OSS> clientPool;

    public OssFileUploader(OssStorageConfig config, String filePath) {
        this(config, filePath, false);
    }

    public OssFileUploader(OssStorageConfig config, String filePath, boolean useCustomPath) {
        super(filePath, useCustomPath);
        this.config = config;
        GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
        poolConfig.setMinIdlePerKey(1);
        poolConfig.setMaxTotalPerKey(3);
        poolConfig.setFairness(true);
        this.clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new OssClientPoolFactory(), poolConfig);
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.ALIYUN_OSS;
    }

    @Override
    public String getDestUri() {
        return this.config.getUri();
    }

    @Override
    public void upload(File file) throws Exception {
        this.upload(file, null);
    }

    @Override
    public void upload(File file, Object progressListener) throws Exception {
        OSS client = (OSS)this.clientPool.borrowObject((Object)this.config);
        String objectKey = this.assembleObjectKey(file, this.config.getPath());
        UploadFileRequest uploadFileRequest = new UploadFileRequest(this.config.getBucket(), objectKey);
        uploadFileRequest.setUploadFile(file.getAbsolutePath());
        uploadFileRequest.setPartSize(0x100000L);
        uploadFileRequest.setEnableCheckpoint(true);
        uploadFileRequest.setCheckpointFile(file.getName() + ".ckpt");
        if (progressListener instanceof ProgressListener) {
            uploadFileRequest.setProgressListener((ProgressListener)progressListener);
        }
        try {
            client.uploadFile(uploadFileRequest);
            log.info("Upload \"{}\" succeed.", (Object)file.getAbsolutePath());
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                log.warn("Failed to delete local file \"{}\". Error: {}", (Object)file, (Object)e.getMessage());
            }
        }
        catch (Throwable e) {
            log.error("Upload \"{}\" failed, local file will not be deleted. Error: {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
            throw new Exception(e);
        }
        finally {
            this.clientPool.returnObject((Object)this.config, (Object)client);
            this.bytesWrittenMap.remove(file);
        }
    }

    @Override
    public void close() {
        this.clientPool.close();
    }
}

