/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema;

import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractPartition;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.base.IGrammar;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractIndexPartition
extends AbstractPartition
implements IGrammar {
    private final Set<IndexPartitionItem> indexPartitions = new LinkedHashSet<IndexPartitionItem>();
    private final Map<String, List<IndexPartitionItem>> indexSubPartitionMapping = new LinkedHashMap<String, List<IndexPartitionItem>>();
    private final Set<IndexPartitionColumn> indexPartitionColumns = new LinkedHashSet<IndexPartitionColumn>();
    private final Set<IndexPartitionColumn> indexSubPartitionColumns = new LinkedHashSet<IndexPartitionColumn>();
    private String partitioningType;
    private String subPartitioningType;
    private Integer partitionCount;
    private Integer defSubPartitionCount;
    private Integer partitioningKeyCount;
    private Integer subPartitioningKeyCount;
    private String locality;
    private String alignment;
    private String defTablespaceName;
    private String defPctFree;
    private String defIniTrans;
    private String defMaxTrans;
    private String defInitialExtent;
    private String defNextExtent;
    private String defMinExtents;
    private String defMaxExtents;
    private String defMaxSize;
    private String defPctIncrease;
    private String defFreelists;
    private String defFreelistGroups;
    private String defLogging;
    private String defBufferPool;
    private String defFlashCache;
    private String defCellFlashCache;
    private String defParameters;
    private String interval;

    public AbstractIndexPartition(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        if ("LOCAL".equals(this.getLocality())) {
            return new StringBuilder(" LOCAL");
        }
        String partitionType = this.getPartTypeMapping().get(this.getPartitioningType());
        if (StringUtils.isBlank(partitionType)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The index partition type: " + this.getPartitioningType() + " is unsupported");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("GLOBAL PARTITION BY ").append(partitionType);
        sb.append((CharSequence)this.joinColumns(this.getIndexPartitionColumns()));
        if ("HASH".equals(partitionType)) {
            return sb.append(" PARTITIONS ").append(this.getPartitionCount());
        }
        String partitionFormat = this.getTablePartTemplateMapping().get(partitionType);
        Iterator<IndexPartitionItem> iter = this.getIndexPartitions().iterator();
        sb.append("\n").append("(");
        while (iter.hasNext()) {
            sb.append("\n\t");
            IndexPartitionItem indexItem = iter.next();
            String partName = this.wrap(indexItem.getPartitionName());
            sb.append(String.format(partitionFormat, partName, indexItem.getHighValue()));
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    protected StringBuilder joinColumns(Collection<IndexPartitionColumn> cols) {
        if (CollectionUtils.isEmpty(cols)) {
            throw new IllegalArgumentException("Index partition columns is null. Object: " + this.getOriginSchemaObjectName());
        }
        return this.enclose(cols.stream().map(e -> this.wrap(e.getColumnName())).collect(Collectors.joining(", ")));
    }

    @Override
    public String toString() {
        return "AbstractIndexPartition(indexPartitions=" + this.getIndexPartitions() + ", indexSubPartitionMapping=" + this.getIndexSubPartitionMapping() + ", indexPartitionColumns=" + this.getIndexPartitionColumns() + ", indexSubPartitionColumns=" + this.getIndexSubPartitionColumns() + ", partitioningType=" + this.getPartitioningType() + ", subPartitioningType=" + this.getSubPartitioningType() + ", partitionCount=" + this.getPartitionCount() + ", defSubPartitionCount=" + this.getDefSubPartitionCount() + ", partitioningKeyCount=" + this.getPartitioningKeyCount() + ", subPartitioningKeyCount=" + this.getSubPartitioningKeyCount() + ", locality=" + this.getLocality() + ", alignment=" + this.getAlignment() + ", defTablespaceName=" + this.getDefTablespaceName() + ", defPctFree=" + this.getDefPctFree() + ", defIniTrans=" + this.getDefIniTrans() + ", defMaxTrans=" + this.getDefMaxTrans() + ", defInitialExtent=" + this.getDefInitialExtent() + ", defNextExtent=" + this.getDefNextExtent() + ", defMinExtents=" + this.getDefMinExtents() + ", defMaxExtents=" + this.getDefMaxExtents() + ", defMaxSize=" + this.getDefMaxSize() + ", defPctIncrease=" + this.getDefPctIncrease() + ", defFreelists=" + this.getDefFreelists() + ", defFreelistGroups=" + this.getDefFreelistGroups() + ", defLogging=" + this.getDefLogging() + ", defBufferPool=" + this.getDefBufferPool() + ", defFlashCache=" + this.getDefFlashCache() + ", defCellFlashCache=" + this.getDefCellFlashCache() + ", defParameters=" + this.getDefParameters() + ", interval=" + this.getInterval() + ")";
    }

    public AbstractIndexPartition() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractIndexPartition)) {
            return false;
        }
        AbstractIndexPartition other = (AbstractIndexPartition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$partitionCount = this.getPartitionCount();
        Integer other$partitionCount = other.getPartitionCount();
        if (this$partitionCount == null ? other$partitionCount != null : !((Object)this$partitionCount).equals(other$partitionCount)) {
            return false;
        }
        Integer this$defSubPartitionCount = this.getDefSubPartitionCount();
        Integer other$defSubPartitionCount = other.getDefSubPartitionCount();
        if (this$defSubPartitionCount == null ? other$defSubPartitionCount != null : !((Object)this$defSubPartitionCount).equals(other$defSubPartitionCount)) {
            return false;
        }
        Integer this$partitioningKeyCount = this.getPartitioningKeyCount();
        Integer other$partitioningKeyCount = other.getPartitioningKeyCount();
        if (this$partitioningKeyCount == null ? other$partitioningKeyCount != null : !((Object)this$partitioningKeyCount).equals(other$partitioningKeyCount)) {
            return false;
        }
        Integer this$subPartitioningKeyCount = this.getSubPartitioningKeyCount();
        Integer other$subPartitioningKeyCount = other.getSubPartitioningKeyCount();
        if (this$subPartitioningKeyCount == null ? other$subPartitioningKeyCount != null : !((Object)this$subPartitioningKeyCount).equals(other$subPartitioningKeyCount)) {
            return false;
        }
        Set<IndexPartitionItem> this$indexPartitions = this.getIndexPartitions();
        Set<IndexPartitionItem> other$indexPartitions = other.getIndexPartitions();
        if (this$indexPartitions == null ? other$indexPartitions != null : !((Object)this$indexPartitions).equals(other$indexPartitions)) {
            return false;
        }
        Map<String, List<IndexPartitionItem>> this$indexSubPartitionMapping = this.getIndexSubPartitionMapping();
        Map<String, List<IndexPartitionItem>> other$indexSubPartitionMapping = other.getIndexSubPartitionMapping();
        if (this$indexSubPartitionMapping == null ? other$indexSubPartitionMapping != null : !((Object)this$indexSubPartitionMapping).equals(other$indexSubPartitionMapping)) {
            return false;
        }
        Set<IndexPartitionColumn> this$indexPartitionColumns = this.getIndexPartitionColumns();
        Set<IndexPartitionColumn> other$indexPartitionColumns = other.getIndexPartitionColumns();
        if (this$indexPartitionColumns == null ? other$indexPartitionColumns != null : !((Object)this$indexPartitionColumns).equals(other$indexPartitionColumns)) {
            return false;
        }
        Set<IndexPartitionColumn> this$indexSubPartitionColumns = this.getIndexSubPartitionColumns();
        Set<IndexPartitionColumn> other$indexSubPartitionColumns = other.getIndexSubPartitionColumns();
        if (this$indexSubPartitionColumns == null ? other$indexSubPartitionColumns != null : !((Object)this$indexSubPartitionColumns).equals(other$indexSubPartitionColumns)) {
            return false;
        }
        String this$partitioningType = this.getPartitioningType();
        String other$partitioningType = other.getPartitioningType();
        if (this$partitioningType == null ? other$partitioningType != null : !this$partitioningType.equals(other$partitioningType)) {
            return false;
        }
        String this$subPartitioningType = this.getSubPartitioningType();
        String other$subPartitioningType = other.getSubPartitioningType();
        if (this$subPartitioningType == null ? other$subPartitioningType != null : !this$subPartitioningType.equals(other$subPartitioningType)) {
            return false;
        }
        String this$locality = this.getLocality();
        String other$locality = other.getLocality();
        if (this$locality == null ? other$locality != null : !this$locality.equals(other$locality)) {
            return false;
        }
        String this$alignment = this.getAlignment();
        String other$alignment = other.getAlignment();
        if (this$alignment == null ? other$alignment != null : !this$alignment.equals(other$alignment)) {
            return false;
        }
        String this$defTablespaceName = this.getDefTablespaceName();
        String other$defTablespaceName = other.getDefTablespaceName();
        if (this$defTablespaceName == null ? other$defTablespaceName != null : !this$defTablespaceName.equals(other$defTablespaceName)) {
            return false;
        }
        String this$defPctFree = this.getDefPctFree();
        String other$defPctFree = other.getDefPctFree();
        if (this$defPctFree == null ? other$defPctFree != null : !this$defPctFree.equals(other$defPctFree)) {
            return false;
        }
        String this$defIniTrans = this.getDefIniTrans();
        String other$defIniTrans = other.getDefIniTrans();
        if (this$defIniTrans == null ? other$defIniTrans != null : !this$defIniTrans.equals(other$defIniTrans)) {
            return false;
        }
        String this$defMaxTrans = this.getDefMaxTrans();
        String other$defMaxTrans = other.getDefMaxTrans();
        if (this$defMaxTrans == null ? other$defMaxTrans != null : !this$defMaxTrans.equals(other$defMaxTrans)) {
            return false;
        }
        String this$defInitialExtent = this.getDefInitialExtent();
        String other$defInitialExtent = other.getDefInitialExtent();
        if (this$defInitialExtent == null ? other$defInitialExtent != null : !this$defInitialExtent.equals(other$defInitialExtent)) {
            return false;
        }
        String this$defNextExtent = this.getDefNextExtent();
        String other$defNextExtent = other.getDefNextExtent();
        if (this$defNextExtent == null ? other$defNextExtent != null : !this$defNextExtent.equals(other$defNextExtent)) {
            return false;
        }
        String this$defMinExtents = this.getDefMinExtents();
        String other$defMinExtents = other.getDefMinExtents();
        if (this$defMinExtents == null ? other$defMinExtents != null : !this$defMinExtents.equals(other$defMinExtents)) {
            return false;
        }
        String this$defMaxExtents = this.getDefMaxExtents();
        String other$defMaxExtents = other.getDefMaxExtents();
        if (this$defMaxExtents == null ? other$defMaxExtents != null : !this$defMaxExtents.equals(other$defMaxExtents)) {
            return false;
        }
        String this$defMaxSize = this.getDefMaxSize();
        String other$defMaxSize = other.getDefMaxSize();
        if (this$defMaxSize == null ? other$defMaxSize != null : !this$defMaxSize.equals(other$defMaxSize)) {
            return false;
        }
        String this$defPctIncrease = this.getDefPctIncrease();
        String other$defPctIncrease = other.getDefPctIncrease();
        if (this$defPctIncrease == null ? other$defPctIncrease != null : !this$defPctIncrease.equals(other$defPctIncrease)) {
            return false;
        }
        String this$defFreelists = this.getDefFreelists();
        String other$defFreelists = other.getDefFreelists();
        if (this$defFreelists == null ? other$defFreelists != null : !this$defFreelists.equals(other$defFreelists)) {
            return false;
        }
        String this$defFreelistGroups = this.getDefFreelistGroups();
        String other$defFreelistGroups = other.getDefFreelistGroups();
        if (this$defFreelistGroups == null ? other$defFreelistGroups != null : !this$defFreelistGroups.equals(other$defFreelistGroups)) {
            return false;
        }
        String this$defLogging = this.getDefLogging();
        String other$defLogging = other.getDefLogging();
        if (this$defLogging == null ? other$defLogging != null : !this$defLogging.equals(other$defLogging)) {
            return false;
        }
        String this$defBufferPool = this.getDefBufferPool();
        String other$defBufferPool = other.getDefBufferPool();
        if (this$defBufferPool == null ? other$defBufferPool != null : !this$defBufferPool.equals(other$defBufferPool)) {
            return false;
        }
        String this$defFlashCache = this.getDefFlashCache();
        String other$defFlashCache = other.getDefFlashCache();
        if (this$defFlashCache == null ? other$defFlashCache != null : !this$defFlashCache.equals(other$defFlashCache)) {
            return false;
        }
        String this$defCellFlashCache = this.getDefCellFlashCache();
        String other$defCellFlashCache = other.getDefCellFlashCache();
        if (this$defCellFlashCache == null ? other$defCellFlashCache != null : !this$defCellFlashCache.equals(other$defCellFlashCache)) {
            return false;
        }
        String this$defParameters = this.getDefParameters();
        String other$defParameters = other.getDefParameters();
        if (this$defParameters == null ? other$defParameters != null : !this$defParameters.equals(other$defParameters)) {
            return false;
        }
        String this$interval = this.getInterval();
        String other$interval = other.getInterval();
        return !(this$interval == null ? other$interval != null : !this$interval.equals(other$interval));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractIndexPartition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $partitionCount = this.getPartitionCount();
        result = result * 59 + ($partitionCount == null ? 43 : ((Object)$partitionCount).hashCode());
        Integer $defSubPartitionCount = this.getDefSubPartitionCount();
        result = result * 59 + ($defSubPartitionCount == null ? 43 : ((Object)$defSubPartitionCount).hashCode());
        Integer $partitioningKeyCount = this.getPartitioningKeyCount();
        result = result * 59 + ($partitioningKeyCount == null ? 43 : ((Object)$partitioningKeyCount).hashCode());
        Integer $subPartitioningKeyCount = this.getSubPartitioningKeyCount();
        result = result * 59 + ($subPartitioningKeyCount == null ? 43 : ((Object)$subPartitioningKeyCount).hashCode());
        Set<IndexPartitionItem> $indexPartitions = this.getIndexPartitions();
        result = result * 59 + ($indexPartitions == null ? 43 : ((Object)$indexPartitions).hashCode());
        Map<String, List<IndexPartitionItem>> $indexSubPartitionMapping = this.getIndexSubPartitionMapping();
        result = result * 59 + ($indexSubPartitionMapping == null ? 43 : ((Object)$indexSubPartitionMapping).hashCode());
        Set<IndexPartitionColumn> $indexPartitionColumns = this.getIndexPartitionColumns();
        result = result * 59 + ($indexPartitionColumns == null ? 43 : ((Object)$indexPartitionColumns).hashCode());
        Set<IndexPartitionColumn> $indexSubPartitionColumns = this.getIndexSubPartitionColumns();
        result = result * 59 + ($indexSubPartitionColumns == null ? 43 : ((Object)$indexSubPartitionColumns).hashCode());
        String $partitioningType = this.getPartitioningType();
        result = result * 59 + ($partitioningType == null ? 43 : $partitioningType.hashCode());
        String $subPartitioningType = this.getSubPartitioningType();
        result = result * 59 + ($subPartitioningType == null ? 43 : $subPartitioningType.hashCode());
        String $locality = this.getLocality();
        result = result * 59 + ($locality == null ? 43 : $locality.hashCode());
        String $alignment = this.getAlignment();
        result = result * 59 + ($alignment == null ? 43 : $alignment.hashCode());
        String $defTablespaceName = this.getDefTablespaceName();
        result = result * 59 + ($defTablespaceName == null ? 43 : $defTablespaceName.hashCode());
        String $defPctFree = this.getDefPctFree();
        result = result * 59 + ($defPctFree == null ? 43 : $defPctFree.hashCode());
        String $defIniTrans = this.getDefIniTrans();
        result = result * 59 + ($defIniTrans == null ? 43 : $defIniTrans.hashCode());
        String $defMaxTrans = this.getDefMaxTrans();
        result = result * 59 + ($defMaxTrans == null ? 43 : $defMaxTrans.hashCode());
        String $defInitialExtent = this.getDefInitialExtent();
        result = result * 59 + ($defInitialExtent == null ? 43 : $defInitialExtent.hashCode());
        String $defNextExtent = this.getDefNextExtent();
        result = result * 59 + ($defNextExtent == null ? 43 : $defNextExtent.hashCode());
        String $defMinExtents = this.getDefMinExtents();
        result = result * 59 + ($defMinExtents == null ? 43 : $defMinExtents.hashCode());
        String $defMaxExtents = this.getDefMaxExtents();
        result = result * 59 + ($defMaxExtents == null ? 43 : $defMaxExtents.hashCode());
        String $defMaxSize = this.getDefMaxSize();
        result = result * 59 + ($defMaxSize == null ? 43 : $defMaxSize.hashCode());
        String $defPctIncrease = this.getDefPctIncrease();
        result = result * 59 + ($defPctIncrease == null ? 43 : $defPctIncrease.hashCode());
        String $defFreelists = this.getDefFreelists();
        result = result * 59 + ($defFreelists == null ? 43 : $defFreelists.hashCode());
        String $defFreelistGroups = this.getDefFreelistGroups();
        result = result * 59 + ($defFreelistGroups == null ? 43 : $defFreelistGroups.hashCode());
        String $defLogging = this.getDefLogging();
        result = result * 59 + ($defLogging == null ? 43 : $defLogging.hashCode());
        String $defBufferPool = this.getDefBufferPool();
        result = result * 59 + ($defBufferPool == null ? 43 : $defBufferPool.hashCode());
        String $defFlashCache = this.getDefFlashCache();
        result = result * 59 + ($defFlashCache == null ? 43 : $defFlashCache.hashCode());
        String $defCellFlashCache = this.getDefCellFlashCache();
        result = result * 59 + ($defCellFlashCache == null ? 43 : $defCellFlashCache.hashCode());
        String $defParameters = this.getDefParameters();
        result = result * 59 + ($defParameters == null ? 43 : $defParameters.hashCode());
        String $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        return result;
    }

    public Set<IndexPartitionItem> getIndexPartitions() {
        return this.indexPartitions;
    }

    public Map<String, List<IndexPartitionItem>> getIndexSubPartitionMapping() {
        return this.indexSubPartitionMapping;
    }

    public Set<IndexPartitionColumn> getIndexPartitionColumns() {
        return this.indexPartitionColumns;
    }

    public Set<IndexPartitionColumn> getIndexSubPartitionColumns() {
        return this.indexSubPartitionColumns;
    }

    public String getPartitioningType() {
        return this.partitioningType;
    }

    public void setPartitioningType(String partitioningType) {
        this.partitioningType = partitioningType;
    }

    public String getSubPartitioningType() {
        return this.subPartitioningType;
    }

    public void setSubPartitioningType(String subPartitioningType) {
        this.subPartitioningType = subPartitioningType;
    }

    public Integer getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
    }

    public Integer getDefSubPartitionCount() {
        return this.defSubPartitionCount;
    }

    public void setDefSubPartitionCount(Integer defSubPartitionCount) {
        this.defSubPartitionCount = defSubPartitionCount;
    }

    public Integer getPartitioningKeyCount() {
        return this.partitioningKeyCount;
    }

    public void setPartitioningKeyCount(Integer partitioningKeyCount) {
        this.partitioningKeyCount = partitioningKeyCount;
    }

    public Integer getSubPartitioningKeyCount() {
        return this.subPartitioningKeyCount;
    }

    public void setSubPartitioningKeyCount(Integer subPartitioningKeyCount) {
        this.subPartitioningKeyCount = subPartitioningKeyCount;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    public String getDefTablespaceName() {
        return this.defTablespaceName;
    }

    public void setDefTablespaceName(String defTablespaceName) {
        this.defTablespaceName = defTablespaceName;
    }

    public String getDefPctFree() {
        return this.defPctFree;
    }

    public void setDefPctFree(String defPctFree) {
        this.defPctFree = defPctFree;
    }

    public String getDefIniTrans() {
        return this.defIniTrans;
    }

    public void setDefIniTrans(String defIniTrans) {
        this.defIniTrans = defIniTrans;
    }

    public String getDefMaxTrans() {
        return this.defMaxTrans;
    }

    public void setDefMaxTrans(String defMaxTrans) {
        this.defMaxTrans = defMaxTrans;
    }

    public String getDefInitialExtent() {
        return this.defInitialExtent;
    }

    public void setDefInitialExtent(String defInitialExtent) {
        this.defInitialExtent = defInitialExtent;
    }

    public String getDefNextExtent() {
        return this.defNextExtent;
    }

    public void setDefNextExtent(String defNextExtent) {
        this.defNextExtent = defNextExtent;
    }

    public String getDefMinExtents() {
        return this.defMinExtents;
    }

    public void setDefMinExtents(String defMinExtents) {
        this.defMinExtents = defMinExtents;
    }

    public String getDefMaxExtents() {
        return this.defMaxExtents;
    }

    public void setDefMaxExtents(String defMaxExtents) {
        this.defMaxExtents = defMaxExtents;
    }

    public String getDefMaxSize() {
        return this.defMaxSize;
    }

    public void setDefMaxSize(String defMaxSize) {
        this.defMaxSize = defMaxSize;
    }

    public String getDefPctIncrease() {
        return this.defPctIncrease;
    }

    public void setDefPctIncrease(String defPctIncrease) {
        this.defPctIncrease = defPctIncrease;
    }

    public String getDefFreelists() {
        return this.defFreelists;
    }

    public void setDefFreelists(String defFreelists) {
        this.defFreelists = defFreelists;
    }

    public String getDefFreelistGroups() {
        return this.defFreelistGroups;
    }

    public void setDefFreelistGroups(String defFreelistGroups) {
        this.defFreelistGroups = defFreelistGroups;
    }

    public String getDefLogging() {
        return this.defLogging;
    }

    public void setDefLogging(String defLogging) {
        this.defLogging = defLogging;
    }

    public String getDefBufferPool() {
        return this.defBufferPool;
    }

    public void setDefBufferPool(String defBufferPool) {
        this.defBufferPool = defBufferPool;
    }

    public String getDefFlashCache() {
        return this.defFlashCache;
    }

    public void setDefFlashCache(String defFlashCache) {
        this.defFlashCache = defFlashCache;
    }

    public String getDefCellFlashCache() {
        return this.defCellFlashCache;
    }

    public void setDefCellFlashCache(String defCellFlashCache) {
        this.defCellFlashCache = defCellFlashCache;
    }

    public String getDefParameters() {
        return this.defParameters;
    }

    public void setDefParameters(String defParameters) {
        this.defParameters = defParameters;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public static class IndexPartitionColumn {
        private String name;
        private String objectType;
        private String columnName;
        private Integer columnPosition;

        public int hashCode() {
            if (this.columnPosition == null || this.columnPosition < 0) {
                return Objects.hash(this.columnName, this.columnPosition);
            }
            return Objects.hash(this.columnPosition);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexPartitionColumn other = (IndexPartitionColumn)obj;
            if (this.columnPosition == null || this.columnPosition < 0) {
                return Objects.deepEquals(other.columnName, this.columnName) && Objects.deepEquals(other.columnPosition, this.columnPosition);
            }
            return Objects.deepEquals(other.columnPosition, this.columnPosition);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public Integer getColumnPosition() {
            return this.columnPosition;
        }

        public void setColumnPosition(Integer columnPosition) {
            this.columnPosition = columnPosition;
        }
    }

    public static class IndexPartitionItem {
        private String composite;
        private String partitionName;
        private Integer subPartitionCount;
        private String subPartitionName;
        private String highValue;
        private Integer highValueLength;
        private Integer partitionPosition;
        private Integer subPartitionPosition;
        private String status;
        private String tablespaceName;
        private String pctFree;
        private String iniTrans;
        private String maxTrans;
        private String initialExtent;
        private String nextExtent;
        private String minExtent;
        private String maxExtent;
        private String maxSize;
        private String pctIncrease;
        private String freeLists;
        private String freeListGroups;
        private String logging;
        private String compression;
        private String blevel;
        private String leafBlocks;
        private String distinctKeys;
        private String avgLeafBlocksPerKey;
        private String avgDataBlocksPerKey;
        private String clusteringFactor;
        private String numRows;
        private String sampleSize;
        private String lastAnalyzed;
        private String bufferPool;
        private String flashCache;
        private String cellFlashCache;
        private String userStats;
        private String pctDirectAccess;
        private String globalStats;
        private String domidxOpstatus;
        private String parameters;
        private String interval;
        private String segmentCreated;

        public int hashCode() {
            if (this.partitionPosition == null || this.partitionPosition > -1) {
                return Objects.hash(this.partitionName, this.partitionPosition);
            }
            return Objects.hash(this.partitionPosition);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexPartitionItem other = (IndexPartitionItem)obj;
            if (this.partitionPosition == null || this.partitionPosition > -1) {
                return Objects.deepEquals(other.partitionName, this.partitionName) && Objects.deepEquals(other.partitionPosition, this.partitionPosition);
            }
            return Objects.deepEquals(other.partitionPosition, this.partitionPosition);
        }

        public String getComposite() {
            return this.composite;
        }

        public void setComposite(String composite) {
            this.composite = composite;
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public void setPartitionName(String partitionName) {
            this.partitionName = partitionName;
        }

        public Integer getSubPartitionCount() {
            return this.subPartitionCount;
        }

        public void setSubPartitionCount(Integer subPartitionCount) {
            this.subPartitionCount = subPartitionCount;
        }

        public String getSubPartitionName() {
            return this.subPartitionName;
        }

        public void setSubPartitionName(String subPartitionName) {
            this.subPartitionName = subPartitionName;
        }

        public String getHighValue() {
            return this.highValue;
        }

        public void setHighValue(String highValue) {
            this.highValue = highValue;
        }

        public Integer getHighValueLength() {
            return this.highValueLength;
        }

        public void setHighValueLength(Integer highValueLength) {
            this.highValueLength = highValueLength;
        }

        public Integer getPartitionPosition() {
            return this.partitionPosition;
        }

        public void setPartitionPosition(Integer partitionPosition) {
            this.partitionPosition = partitionPosition;
        }

        public Integer getSubPartitionPosition() {
            return this.subPartitionPosition;
        }

        public void setSubPartitionPosition(Integer subPartitionPosition) {
            this.subPartitionPosition = subPartitionPosition;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getTablespaceName() {
            return this.tablespaceName;
        }

        public void setTablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
        }

        public String getPctFree() {
            return this.pctFree;
        }

        public void setPctFree(String pctFree) {
            this.pctFree = pctFree;
        }

        public String getIniTrans() {
            return this.iniTrans;
        }

        public void setIniTrans(String iniTrans) {
            this.iniTrans = iniTrans;
        }

        public String getMaxTrans() {
            return this.maxTrans;
        }

        public void setMaxTrans(String maxTrans) {
            this.maxTrans = maxTrans;
        }

        public String getInitialExtent() {
            return this.initialExtent;
        }

        public void setInitialExtent(String initialExtent) {
            this.initialExtent = initialExtent;
        }

        public String getNextExtent() {
            return this.nextExtent;
        }

        public void setNextExtent(String nextExtent) {
            this.nextExtent = nextExtent;
        }

        public String getMinExtent() {
            return this.minExtent;
        }

        public void setMinExtent(String minExtent) {
            this.minExtent = minExtent;
        }

        public String getMaxExtent() {
            return this.maxExtent;
        }

        public void setMaxExtent(String maxExtent) {
            this.maxExtent = maxExtent;
        }

        public String getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(String maxSize) {
            this.maxSize = maxSize;
        }

        public String getPctIncrease() {
            return this.pctIncrease;
        }

        public void setPctIncrease(String pctIncrease) {
            this.pctIncrease = pctIncrease;
        }

        public String getFreeLists() {
            return this.freeLists;
        }

        public void setFreeLists(String freeLists) {
            this.freeLists = freeLists;
        }

        public String getFreeListGroups() {
            return this.freeListGroups;
        }

        public void setFreeListGroups(String freeListGroups) {
            this.freeListGroups = freeListGroups;
        }

        public String getLogging() {
            return this.logging;
        }

        public void setLogging(String logging) {
            this.logging = logging;
        }

        public String getCompression() {
            return this.compression;
        }

        public void setCompression(String compression) {
            this.compression = compression;
        }

        public String getBlevel() {
            return this.blevel;
        }

        public void setBlevel(String blevel) {
            this.blevel = blevel;
        }

        public String getLeafBlocks() {
            return this.leafBlocks;
        }

        public void setLeafBlocks(String leafBlocks) {
            this.leafBlocks = leafBlocks;
        }

        public String getDistinctKeys() {
            return this.distinctKeys;
        }

        public void setDistinctKeys(String distinctKeys) {
            this.distinctKeys = distinctKeys;
        }

        public String getAvgLeafBlocksPerKey() {
            return this.avgLeafBlocksPerKey;
        }

        public void setAvgLeafBlocksPerKey(String avgLeafBlocksPerKey) {
            this.avgLeafBlocksPerKey = avgLeafBlocksPerKey;
        }

        public String getAvgDataBlocksPerKey() {
            return this.avgDataBlocksPerKey;
        }

        public void setAvgDataBlocksPerKey(String avgDataBlocksPerKey) {
            this.avgDataBlocksPerKey = avgDataBlocksPerKey;
        }

        public String getClusteringFactor() {
            return this.clusteringFactor;
        }

        public void setClusteringFactor(String clusteringFactor) {
            this.clusteringFactor = clusteringFactor;
        }

        public String getNumRows() {
            return this.numRows;
        }

        public void setNumRows(String numRows) {
            this.numRows = numRows;
        }

        public String getSampleSize() {
            return this.sampleSize;
        }

        public void setSampleSize(String sampleSize) {
            this.sampleSize = sampleSize;
        }

        public String getLastAnalyzed() {
            return this.lastAnalyzed;
        }

        public void setLastAnalyzed(String lastAnalyzed) {
            this.lastAnalyzed = lastAnalyzed;
        }

        public String getBufferPool() {
            return this.bufferPool;
        }

        public void setBufferPool(String bufferPool) {
            this.bufferPool = bufferPool;
        }

        public String getFlashCache() {
            return this.flashCache;
        }

        public void setFlashCache(String flashCache) {
            this.flashCache = flashCache;
        }

        public String getCellFlashCache() {
            return this.cellFlashCache;
        }

        public void setCellFlashCache(String cellFlashCache) {
            this.cellFlashCache = cellFlashCache;
        }

        public String getUserStats() {
            return this.userStats;
        }

        public void setUserStats(String userStats) {
            this.userStats = userStats;
        }

        public String getPctDirectAccess() {
            return this.pctDirectAccess;
        }

        public void setPctDirectAccess(String pctDirectAccess) {
            this.pctDirectAccess = pctDirectAccess;
        }

        public String getGlobalStats() {
            return this.globalStats;
        }

        public void setGlobalStats(String globalStats) {
            this.globalStats = globalStats;
        }

        public String getDomidxOpstatus() {
            return this.domidxOpstatus;
        }

        public void setDomidxOpstatus(String domidxOpstatus) {
            this.domidxOpstatus = domidxOpstatus;
        }

        public String getParameters() {
            return this.parameters;
        }

        public void setParameters(String parameters) {
            this.parameters = parameters;
        }

        public String getInterval() {
            return this.interval;
        }

        public void setInterval(String interval) {
            this.interval = interval;
        }

        public String getSegmentCreated() {
            return this.segmentCreated;
        }

        public void setSegmentCreated(String segmentCreated) {
            this.segmentCreated = segmentCreated;
        }
    }
}

