/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.obmysql;

import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.base.KeyColumn;
import com.oceanbase.tools.loaddump.schema.obmysql.AbstractObMySqlConstraint;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSchema;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.Collection;
import java.util.Iterator;

public class ObMySqlPrimaryKey
extends AbstractObMySqlConstraint {
    public ObMySqlPrimaryKey(ObMySqlSchema schema) {
        super(schema);
    }

    @Override
    public ObMySqlSchema getSchema() {
        return super.getSchema();
    }

    @Override
    public void setSchema(ObMySqlSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        this.checkConstraintOnGeneratedColumns();
        StringBuilder sb = new StringBuilder();
        String constraintName = this.getConstraintName();
        if (StringUtils.isNotBlank(constraintName) && !"PRIMARY".equalsIgnoreCase(constraintName)) {
            sb.append("constraint ").append(this.wrap(constraintName)).append(" ");
        }
        return sb.append("primary key").append((CharSequence)this.joinConstraintColumns());
    }

    @Override
    public StringBuilder joinConstraintColumns() {
        StringBuilder target = new StringBuilder();
        Collection<KeyColumn> cols = this.getConstraintColumns();
        if (CollectionUtils.isEmpty(cols)) {
            return target;
        }
        StringBuilder origin = new StringBuilder();
        Iterator<KeyColumn> iter = cols.iterator();
        while (iter.hasNext()) {
            KeyColumn col = iter.next();
            String wrapped = this.wrap(col.getColumnName());
            origin.append(wrapped);
            target.append(wrapped);
            String subPart = col.getSubPart();
            if (StringUtils.isNotBlank(subPart)) {
                origin.append("(").append(subPart).append(")");
            }
            if (!iter.hasNext()) continue;
            origin.append(", ");
            target.append(", ");
        }
        return this.enclose(target);
    }

    @Override
    public String toString() {
        return "ObMySqlPrimaryKey()";
    }

    public ObMySqlPrimaryKey() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObMySqlPrimaryKey)) {
            return false;
        }
        ObMySqlPrimaryKey other = (ObMySqlPrimaryKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObMySqlPrimaryKey;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

