/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.obmysql;

import com.oceanbase.tools.loaddump.schema.AbstractSequence;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSchema;
import java.math.BigDecimal;

public class ObMySqlSequence
extends AbstractSequence {
    private static final BigDecimal MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);

    public ObMySqlSequence(ObMySqlSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildSequenceGrammar() {
        BigDecimal min;
        BigDecimal increment;
        StringBuilder sb = new StringBuilder(32);
        BigDecimal start = this.getStart();
        if (start != null) {
            sb.append(" START WITH ").append(start);
        }
        if ((increment = this.getIncrement()) != null) {
            sb.append(" INCREMENT BY ").append(increment);
        }
        if ((min = this.getMinValue()) != null) {
            sb.append(" MINVALUE ").append(min);
        } else {
            sb.append(" NOMINVALUE");
        }
        BigDecimal max = this.getMaxValue();
        if (max != null) {
            sb.append(" MAXVALUE ").append(max);
            String cycle = this.getCycle();
            if ("Y".equals(cycle) || "YES".equals(cycle)) {
                sb.append(" CYCLE");
            } else {
                sb.append(" NOCYCLE");
            }
        } else {
            sb.append(" NOMAXVALUE");
        }
        BigDecimal cache = this.getCache();
        if (cache != null) {
            sb.append(" CACHE ").append(cache);
        } else {
            sb.append(" NOCACHE");
        }
        String order = this.getOrder();
        if ("Y".equals(order) || "YES".equals(order)) {
            sb.append(" ORDER");
        } else {
            sb.append(" NOORDER");
        }
        return sb;
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    public ObMySqlSequence() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObMySqlSequence)) {
            return false;
        }
        ObMySqlSequence other = (ObMySqlSequence)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObMySqlSequence;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

