/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.obmysql;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractView;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSchema;
import java.util.List;

public class ObMySqlView
extends AbstractView {
    private String checkOption;
    private String definer;
    private String securityType;
    private String characterSetClient;
    private String collationConnection;

    public ObMySqlView(ObMySqlSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE OR REPLACE");
        sb.append(" VIEW ").append(this.getSchemaObjectName());
        sb.append(" AS ");
        sb.append(this.getText());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.VIEW, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    public ObMySqlView() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObMySqlView)) {
            return false;
        }
        ObMySqlView other = (ObMySqlView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$checkOption = this.getCheckOption();
        String other$checkOption = other.getCheckOption();
        if (this$checkOption == null ? other$checkOption != null : !this$checkOption.equals(other$checkOption)) {
            return false;
        }
        String this$definer = this.getDefiner();
        String other$definer = other.getDefiner();
        if (this$definer == null ? other$definer != null : !this$definer.equals(other$definer)) {
            return false;
        }
        String this$securityType = this.getSecurityType();
        String other$securityType = other.getSecurityType();
        if (this$securityType == null ? other$securityType != null : !this$securityType.equals(other$securityType)) {
            return false;
        }
        String this$characterSetClient = this.getCharacterSetClient();
        String other$characterSetClient = other.getCharacterSetClient();
        if (this$characterSetClient == null ? other$characterSetClient != null : !this$characterSetClient.equals(other$characterSetClient)) {
            return false;
        }
        String this$collationConnection = this.getCollationConnection();
        String other$collationConnection = other.getCollationConnection();
        return !(this$collationConnection == null ? other$collationConnection != null : !this$collationConnection.equals(other$collationConnection));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObMySqlView;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $checkOption = this.getCheckOption();
        result = result * 59 + ($checkOption == null ? 43 : $checkOption.hashCode());
        String $definer = this.getDefiner();
        result = result * 59 + ($definer == null ? 43 : $definer.hashCode());
        String $securityType = this.getSecurityType();
        result = result * 59 + ($securityType == null ? 43 : $securityType.hashCode());
        String $characterSetClient = this.getCharacterSetClient();
        result = result * 59 + ($characterSetClient == null ? 43 : $characterSetClient.hashCode());
        String $collationConnection = this.getCollationConnection();
        result = result * 59 + ($collationConnection == null ? 43 : $collationConnection.hashCode());
        return result;
    }

    public String getCheckOption() {
        return this.checkOption;
    }

    public void setCheckOption(String checkOption) {
        this.checkOption = checkOption;
    }

    public String getDefiner() {
        return this.definer;
    }

    public void setDefiner(String definer) {
        this.definer = definer;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public String getCharacterSetClient() {
        return this.characterSetClient;
    }

    public void setCharacterSetClient(String characterSetClient) {
        this.characterSetClient = characterSetClient;
    }

    public String getCollationConnection() {
        return this.collationConnection;
    }

    public void setCollationConnection(String collationConnection) {
        this.collationConnection = collationConnection;
    }
}

