/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.oboracle;

import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.configure.Global;
import com.oceanbase.tools.loaddump.schema.AbstractColumn;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSequence;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public class ObOracleColumn
extends AbstractColumn {
    private static final int MAX_CHAR_BYTE_LEN = 2000;
    private static final int MAX_VARCHAR_BYTE_LEN = Short.MAX_VALUE;
    private String dataTypeMod;
    private String dataTypeOwner;
    private Long dataLength;
    private Integer dataPrecision;
    private Integer dataScale;
    private Integer defaultLength;
    private Integer numDistinct;
    private String lowValue;
    private String highValue;
    private String density;
    private String numNulls;
    private String numBuckets;
    private String lastAnalyzed;
    private String sampleSize;
    private String characterSetName;
    private Integer charColDeclLength;
    private String globalStats;
    private String userStats;
    private String avgColLen;
    private Long charLength;
    private String charUsed;
    private String v80FmtImage;
    private String dataUpgraded;
    private String hiddenColumn;
    private String virtualColumn;
    private int segmentColumnId;
    private int internalColumnId;
    private String histogram;
    private String qualifiedColName;
    private String userGenerated;
    private String defaultOnNull;
    private String identityColumn;
    private String generationType;
    private String inlineCheckGrammar;
    private ObOracleSequence identityExpr;

    public ObOracleColumn(ObOracleSchema schema) {
        super(schema);
    }

    @Override
    public ObOracleSchema getSchema() {
        return (ObOracleSchema)super.getSchema();
    }

    public void setSchema(ObOracleSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String columnDefault;
        String dataType = this.getDataType();
        if (dataType == null) {
            throw new IllegalArgumentException("The data type is null");
        }
        if (dataType.startsWith("INTERVAL DAY()")) {
            dataType = dataType.replace("INTERVAL DAY()", "INTERVAL DAY(0)");
        } else if (dataType.startsWith("INTERVAL YEAR()")) {
            dataType = dataType.replace("INTERVAL YEAR()", "INTERVAL YEAR(0)");
        }
        StringBuilder sb = new StringBuilder();
        String columnName = this.getWrappedName();
        sb.append(columnName);
        DbType originDbType = super.getOriginDbType();
        if (!"YES".equals(this.getVirtualColumn()) || originDbType == null || !DbType.OBORACLE_22.getType().equals(originDbType.getType())) {
            this.appendDataType(columnName, dataType, sb);
        }
        if ("YES".equals(this.getHiddenColumn())) {
            sb.append(" INVISIBLE");
        }
        if (StringUtils.isNotBlank(this.getInlineCheckGrammar())) {
            sb.append(" ").append(this.getInlineCheckGrammar());
        }
        if ((columnDefault = this.getColumnDefault()) != null) {
            if ("YES".equals(this.getVirtualColumn())) {
                sb.append(" GENERATED ALWAYS AS");
                sb.append((CharSequence)this.enclose(columnDefault)).append(" VIRTUAL");
            } else {
                sb.append(" DEFAULT ").append(this.escapeColumnDefault(columnDefault).trim());
                if (columnDefault.contains("--")) {
                    sb.append("\n");
                }
            }
        }
        if ("N".equals(this.getNullable())) {
            sb.append(" NOT NULL");
        }
        return sb;
    }

    private StringBuilder appendDataType(String columnName, String dataType, StringBuilder sb) throws UnsupportedGrammarException {
        sb.append(" ").append(dataType);
        switch (dataType) {
            case "XML": 
            case "BFILE": 
            case "BINARY": 
            case "XMLType": {
                throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The column: " + columnName + " " + dataType + " is unsupported");
            }
            case "ROWID": 
            case "UROWID": {
                if (this.getDbType().isPrior(DbType.OBORACLE_2270)) {
                    throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The column: " + columnName + " " + dataType + " is unsupported");
                }
            }
            case "NCLOB": {
                if (this.getDbType().isPrior(DbType.OBORACLE_2250)) {
                    throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The column: " + columnName + " " + dataType + " is unsupported");
                }
            }
            case "DATE": 
            case "CLOB": 
            case "BLOB": 
            case "BINARY_FLOAT": 
            case "BINARY_DOUBLE": {
                break;
            }
            case "FLOAT": {
                Integer dataPrecision = this.getDataPrecision();
                if (dataPrecision == null || dataPrecision <= 0) break;
                sb.append("(").append(dataPrecision).append(")");
                break;
            }
            case "NUMBER": {
                Integer dataPrecision = this.getDataPrecision();
                Integer dataScale = this.getDataScale();
                if (dataPrecision != null && dataPrecision > 0) {
                    sb.append("(").append(dataPrecision);
                    if (dataScale != null && dataScale > -1) {
                        sb.append(",").append(dataScale);
                    }
                    sb.append(")");
                    break;
                }
                if (dataScale == null || dataScale <= -1) break;
                sb.append("(*,").append(dataScale).append(")");
                break;
            }
            case "NCHAR": 
            case "NVARCHAR2": {
                sb.append("(").append(this.getCharLength()).append(")");
                break;
            }
            default: {
                if (dataType.startsWith("TIMESTAMP") || dataType.startsWith("INTERVAL")) break;
                String charUsed = this.getCharUsed();
                Long originLength = this.getCharLength();
                if ("B".equals(charUsed)) {
                    if (Global.ByteUsedType.EXPAND_LEN_IF_BYTE_USED == super.getGlobal().getByteUsedType()) {
                        long charLength = Double.valueOf((double)originLength.longValue() * 1.5).longValue();
                        if (this.isCharType()) {
                            long l = charLength = charLength >= 2000L ? 2000L : charLength;
                        }
                        if (this.isVarcharType()) {
                            charLength = charLength >= 32767L ? 32767L : charLength;
                        }
                        sb.append("(").append(charLength).append(" BYTE)");
                        break;
                    }
                    if (Global.ByteUsedType.FORCE_CHAR_IF_BYTE_USED == super.getGlobal().getByteUsedType()) {
                        sb.append("(").append(originLength).append(" CHAR)");
                        break;
                    }
                    if (Global.ByteUsedType.IGNORE_BYTE_IF_BYTE_USED == super.getGlobal().getByteUsedType()) {
                        sb.append("(").append(originLength).append(")");
                        break;
                    }
                    sb.append("(").append(originLength).append(" BYTE)");
                    break;
                }
                if ("C".equals(charUsed)) {
                    sb.append("(").append(originLength).append(" CHAR)");
                    break;
                }
                Long dataLength = this.getDataLength();
                if (dataLength == null || dataLength <= 0L) break;
                sb.append("(").append(this.getDataLength()).append(")");
            }
        }
        return sb;
    }

    private boolean isCharType() {
        return "CHAR".equalsIgnoreCase(this.getDataType()) || "NCHAR".equalsIgnoreCase(this.getDataType()) || "CHARACTER".equalsIgnoreCase(this.getDataType());
    }

    private boolean isVarcharType() {
        return "VARCHAR".equalsIgnoreCase(this.getDataType()) || "NVARCHAR2".equalsIgnoreCase(this.getDataType());
    }

    public String toString() {
        return "ObOracleColumn(dataTypeMod=" + this.getDataTypeMod() + ", dataTypeOwner=" + this.getDataTypeOwner() + ", dataLength=" + this.getDataLength() + ", dataPrecision=" + this.getDataPrecision() + ", dataScale=" + this.getDataScale() + ", defaultLength=" + this.getDefaultLength() + ", numDistinct=" + this.getNumDistinct() + ", lowValue=" + this.getLowValue() + ", highValue=" + this.getHighValue() + ", density=" + this.getDensity() + ", numNulls=" + this.getNumNulls() + ", numBuckets=" + this.getNumBuckets() + ", lastAnalyzed=" + this.getLastAnalyzed() + ", sampleSize=" + this.getSampleSize() + ", characterSetName=" + this.getCharacterSetName() + ", charColDeclLength=" + this.getCharColDeclLength() + ", globalStats=" + this.getGlobalStats() + ", userStats=" + this.getUserStats() + ", avgColLen=" + this.getAvgColLen() + ", charLength=" + this.getCharLength() + ", charUsed=" + this.getCharUsed() + ", v80FmtImage=" + this.getV80FmtImage() + ", dataUpgraded=" + this.getDataUpgraded() + ", hiddenColumn=" + this.getHiddenColumn() + ", virtualColumn=" + this.getVirtualColumn() + ", segmentColumnId=" + this.getSegmentColumnId() + ", internalColumnId=" + this.getInternalColumnId() + ", histogram=" + this.getHistogram() + ", qualifiedColName=" + this.getQualifiedColName() + ", userGenerated=" + this.getUserGenerated() + ", defaultOnNull=" + this.getDefaultOnNull() + ", identityColumn=" + this.getIdentityColumn() + ", generationType=" + this.getGenerationType() + ", inlineCheckGrammar=" + this.getInlineCheckGrammar() + ", identityExpr=" + this.getIdentityExpr() + ")";
    }

    public ObOracleColumn() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObOracleColumn)) {
            return false;
        }
        ObOracleColumn other = (ObOracleColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSegmentColumnId() != other.getSegmentColumnId()) {
            return false;
        }
        if (this.getInternalColumnId() != other.getInternalColumnId()) {
            return false;
        }
        Long this$dataLength = this.getDataLength();
        Long other$dataLength = other.getDataLength();
        if (this$dataLength == null ? other$dataLength != null : !((Object)this$dataLength).equals(other$dataLength)) {
            return false;
        }
        Integer this$dataPrecision = this.getDataPrecision();
        Integer other$dataPrecision = other.getDataPrecision();
        if (this$dataPrecision == null ? other$dataPrecision != null : !((Object)this$dataPrecision).equals(other$dataPrecision)) {
            return false;
        }
        Integer this$dataScale = this.getDataScale();
        Integer other$dataScale = other.getDataScale();
        if (this$dataScale == null ? other$dataScale != null : !((Object)this$dataScale).equals(other$dataScale)) {
            return false;
        }
        Integer this$defaultLength = this.getDefaultLength();
        Integer other$defaultLength = other.getDefaultLength();
        if (this$defaultLength == null ? other$defaultLength != null : !((Object)this$defaultLength).equals(other$defaultLength)) {
            return false;
        }
        Integer this$numDistinct = this.getNumDistinct();
        Integer other$numDistinct = other.getNumDistinct();
        if (this$numDistinct == null ? other$numDistinct != null : !((Object)this$numDistinct).equals(other$numDistinct)) {
            return false;
        }
        Integer this$charColDeclLength = this.getCharColDeclLength();
        Integer other$charColDeclLength = other.getCharColDeclLength();
        if (this$charColDeclLength == null ? other$charColDeclLength != null : !((Object)this$charColDeclLength).equals(other$charColDeclLength)) {
            return false;
        }
        Long this$charLength = this.getCharLength();
        Long other$charLength = other.getCharLength();
        if (this$charLength == null ? other$charLength != null : !((Object)this$charLength).equals(other$charLength)) {
            return false;
        }
        String this$dataTypeMod = this.getDataTypeMod();
        String other$dataTypeMod = other.getDataTypeMod();
        if (this$dataTypeMod == null ? other$dataTypeMod != null : !this$dataTypeMod.equals(other$dataTypeMod)) {
            return false;
        }
        String this$dataTypeOwner = this.getDataTypeOwner();
        String other$dataTypeOwner = other.getDataTypeOwner();
        if (this$dataTypeOwner == null ? other$dataTypeOwner != null : !this$dataTypeOwner.equals(other$dataTypeOwner)) {
            return false;
        }
        String this$lowValue = this.getLowValue();
        String other$lowValue = other.getLowValue();
        if (this$lowValue == null ? other$lowValue != null : !this$lowValue.equals(other$lowValue)) {
            return false;
        }
        String this$highValue = this.getHighValue();
        String other$highValue = other.getHighValue();
        if (this$highValue == null ? other$highValue != null : !this$highValue.equals(other$highValue)) {
            return false;
        }
        String this$density = this.getDensity();
        String other$density = other.getDensity();
        if (this$density == null ? other$density != null : !this$density.equals(other$density)) {
            return false;
        }
        String this$numNulls = this.getNumNulls();
        String other$numNulls = other.getNumNulls();
        if (this$numNulls == null ? other$numNulls != null : !this$numNulls.equals(other$numNulls)) {
            return false;
        }
        String this$numBuckets = this.getNumBuckets();
        String other$numBuckets = other.getNumBuckets();
        if (this$numBuckets == null ? other$numBuckets != null : !this$numBuckets.equals(other$numBuckets)) {
            return false;
        }
        String this$lastAnalyzed = this.getLastAnalyzed();
        String other$lastAnalyzed = other.getLastAnalyzed();
        if (this$lastAnalyzed == null ? other$lastAnalyzed != null : !this$lastAnalyzed.equals(other$lastAnalyzed)) {
            return false;
        }
        String this$sampleSize = this.getSampleSize();
        String other$sampleSize = other.getSampleSize();
        if (this$sampleSize == null ? other$sampleSize != null : !this$sampleSize.equals(other$sampleSize)) {
            return false;
        }
        String this$characterSetName = this.getCharacterSetName();
        String other$characterSetName = other.getCharacterSetName();
        if (this$characterSetName == null ? other$characterSetName != null : !this$characterSetName.equals(other$characterSetName)) {
            return false;
        }
        String this$globalStats = this.getGlobalStats();
        String other$globalStats = other.getGlobalStats();
        if (this$globalStats == null ? other$globalStats != null : !this$globalStats.equals(other$globalStats)) {
            return false;
        }
        String this$userStats = this.getUserStats();
        String other$userStats = other.getUserStats();
        if (this$userStats == null ? other$userStats != null : !this$userStats.equals(other$userStats)) {
            return false;
        }
        String this$avgColLen = this.getAvgColLen();
        String other$avgColLen = other.getAvgColLen();
        if (this$avgColLen == null ? other$avgColLen != null : !this$avgColLen.equals(other$avgColLen)) {
            return false;
        }
        String this$charUsed = this.getCharUsed();
        String other$charUsed = other.getCharUsed();
        if (this$charUsed == null ? other$charUsed != null : !this$charUsed.equals(other$charUsed)) {
            return false;
        }
        String this$v80FmtImage = this.getV80FmtImage();
        String other$v80FmtImage = other.getV80FmtImage();
        if (this$v80FmtImage == null ? other$v80FmtImage != null : !this$v80FmtImage.equals(other$v80FmtImage)) {
            return false;
        }
        String this$dataUpgraded = this.getDataUpgraded();
        String other$dataUpgraded = other.getDataUpgraded();
        if (this$dataUpgraded == null ? other$dataUpgraded != null : !this$dataUpgraded.equals(other$dataUpgraded)) {
            return false;
        }
        String this$hiddenColumn = this.getHiddenColumn();
        String other$hiddenColumn = other.getHiddenColumn();
        if (this$hiddenColumn == null ? other$hiddenColumn != null : !this$hiddenColumn.equals(other$hiddenColumn)) {
            return false;
        }
        String this$virtualColumn = this.getVirtualColumn();
        String other$virtualColumn = other.getVirtualColumn();
        if (this$virtualColumn == null ? other$virtualColumn != null : !this$virtualColumn.equals(other$virtualColumn)) {
            return false;
        }
        String this$histogram = this.getHistogram();
        String other$histogram = other.getHistogram();
        if (this$histogram == null ? other$histogram != null : !this$histogram.equals(other$histogram)) {
            return false;
        }
        String this$qualifiedColName = this.getQualifiedColName();
        String other$qualifiedColName = other.getQualifiedColName();
        if (this$qualifiedColName == null ? other$qualifiedColName != null : !this$qualifiedColName.equals(other$qualifiedColName)) {
            return false;
        }
        String this$userGenerated = this.getUserGenerated();
        String other$userGenerated = other.getUserGenerated();
        if (this$userGenerated == null ? other$userGenerated != null : !this$userGenerated.equals(other$userGenerated)) {
            return false;
        }
        String this$defaultOnNull = this.getDefaultOnNull();
        String other$defaultOnNull = other.getDefaultOnNull();
        if (this$defaultOnNull == null ? other$defaultOnNull != null : !this$defaultOnNull.equals(other$defaultOnNull)) {
            return false;
        }
        String this$identityColumn = this.getIdentityColumn();
        String other$identityColumn = other.getIdentityColumn();
        if (this$identityColumn == null ? other$identityColumn != null : !this$identityColumn.equals(other$identityColumn)) {
            return false;
        }
        String this$generationType = this.getGenerationType();
        String other$generationType = other.getGenerationType();
        if (this$generationType == null ? other$generationType != null : !this$generationType.equals(other$generationType)) {
            return false;
        }
        String this$inlineCheckGrammar = this.getInlineCheckGrammar();
        String other$inlineCheckGrammar = other.getInlineCheckGrammar();
        if (this$inlineCheckGrammar == null ? other$inlineCheckGrammar != null : !this$inlineCheckGrammar.equals(other$inlineCheckGrammar)) {
            return false;
        }
        ObOracleSequence this$identityExpr = this.getIdentityExpr();
        ObOracleSequence other$identityExpr = other.getIdentityExpr();
        return !(this$identityExpr == null ? other$identityExpr != null : !((Object)this$identityExpr).equals(other$identityExpr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObOracleColumn;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getSegmentColumnId();
        result = result * 59 + this.getInternalColumnId();
        Long $dataLength = this.getDataLength();
        result = result * 59 + ($dataLength == null ? 43 : ((Object)$dataLength).hashCode());
        Integer $dataPrecision = this.getDataPrecision();
        result = result * 59 + ($dataPrecision == null ? 43 : ((Object)$dataPrecision).hashCode());
        Integer $dataScale = this.getDataScale();
        result = result * 59 + ($dataScale == null ? 43 : ((Object)$dataScale).hashCode());
        Integer $defaultLength = this.getDefaultLength();
        result = result * 59 + ($defaultLength == null ? 43 : ((Object)$defaultLength).hashCode());
        Integer $numDistinct = this.getNumDistinct();
        result = result * 59 + ($numDistinct == null ? 43 : ((Object)$numDistinct).hashCode());
        Integer $charColDeclLength = this.getCharColDeclLength();
        result = result * 59 + ($charColDeclLength == null ? 43 : ((Object)$charColDeclLength).hashCode());
        Long $charLength = this.getCharLength();
        result = result * 59 + ($charLength == null ? 43 : ((Object)$charLength).hashCode());
        String $dataTypeMod = this.getDataTypeMod();
        result = result * 59 + ($dataTypeMod == null ? 43 : $dataTypeMod.hashCode());
        String $dataTypeOwner = this.getDataTypeOwner();
        result = result * 59 + ($dataTypeOwner == null ? 43 : $dataTypeOwner.hashCode());
        String $lowValue = this.getLowValue();
        result = result * 59 + ($lowValue == null ? 43 : $lowValue.hashCode());
        String $highValue = this.getHighValue();
        result = result * 59 + ($highValue == null ? 43 : $highValue.hashCode());
        String $density = this.getDensity();
        result = result * 59 + ($density == null ? 43 : $density.hashCode());
        String $numNulls = this.getNumNulls();
        result = result * 59 + ($numNulls == null ? 43 : $numNulls.hashCode());
        String $numBuckets = this.getNumBuckets();
        result = result * 59 + ($numBuckets == null ? 43 : $numBuckets.hashCode());
        String $lastAnalyzed = this.getLastAnalyzed();
        result = result * 59 + ($lastAnalyzed == null ? 43 : $lastAnalyzed.hashCode());
        String $sampleSize = this.getSampleSize();
        result = result * 59 + ($sampleSize == null ? 43 : $sampleSize.hashCode());
        String $characterSetName = this.getCharacterSetName();
        result = result * 59 + ($characterSetName == null ? 43 : $characterSetName.hashCode());
        String $globalStats = this.getGlobalStats();
        result = result * 59 + ($globalStats == null ? 43 : $globalStats.hashCode());
        String $userStats = this.getUserStats();
        result = result * 59 + ($userStats == null ? 43 : $userStats.hashCode());
        String $avgColLen = this.getAvgColLen();
        result = result * 59 + ($avgColLen == null ? 43 : $avgColLen.hashCode());
        String $charUsed = this.getCharUsed();
        result = result * 59 + ($charUsed == null ? 43 : $charUsed.hashCode());
        String $v80FmtImage = this.getV80FmtImage();
        result = result * 59 + ($v80FmtImage == null ? 43 : $v80FmtImage.hashCode());
        String $dataUpgraded = this.getDataUpgraded();
        result = result * 59 + ($dataUpgraded == null ? 43 : $dataUpgraded.hashCode());
        String $hiddenColumn = this.getHiddenColumn();
        result = result * 59 + ($hiddenColumn == null ? 43 : $hiddenColumn.hashCode());
        String $virtualColumn = this.getVirtualColumn();
        result = result * 59 + ($virtualColumn == null ? 43 : $virtualColumn.hashCode());
        String $histogram = this.getHistogram();
        result = result * 59 + ($histogram == null ? 43 : $histogram.hashCode());
        String $qualifiedColName = this.getQualifiedColName();
        result = result * 59 + ($qualifiedColName == null ? 43 : $qualifiedColName.hashCode());
        String $userGenerated = this.getUserGenerated();
        result = result * 59 + ($userGenerated == null ? 43 : $userGenerated.hashCode());
        String $defaultOnNull = this.getDefaultOnNull();
        result = result * 59 + ($defaultOnNull == null ? 43 : $defaultOnNull.hashCode());
        String $identityColumn = this.getIdentityColumn();
        result = result * 59 + ($identityColumn == null ? 43 : $identityColumn.hashCode());
        String $generationType = this.getGenerationType();
        result = result * 59 + ($generationType == null ? 43 : $generationType.hashCode());
        String $inlineCheckGrammar = this.getInlineCheckGrammar();
        result = result * 59 + ($inlineCheckGrammar == null ? 43 : $inlineCheckGrammar.hashCode());
        ObOracleSequence $identityExpr = this.getIdentityExpr();
        result = result * 59 + ($identityExpr == null ? 43 : ((Object)$identityExpr).hashCode());
        return result;
    }

    public String getDataTypeMod() {
        return this.dataTypeMod;
    }

    public void setDataTypeMod(String dataTypeMod) {
        this.dataTypeMod = dataTypeMod;
    }

    public String getDataTypeOwner() {
        return this.dataTypeOwner;
    }

    public void setDataTypeOwner(String dataTypeOwner) {
        this.dataTypeOwner = dataTypeOwner;
    }

    public Long getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(Long dataLength) {
        this.dataLength = dataLength;
    }

    public Integer getDataPrecision() {
        return this.dataPrecision;
    }

    public void setDataPrecision(Integer dataPrecision) {
        this.dataPrecision = dataPrecision;
    }

    public Integer getDataScale() {
        return this.dataScale;
    }

    public void setDataScale(Integer dataScale) {
        this.dataScale = dataScale;
    }

    public Integer getDefaultLength() {
        return this.defaultLength;
    }

    public void setDefaultLength(Integer defaultLength) {
        this.defaultLength = defaultLength;
    }

    public Integer getNumDistinct() {
        return this.numDistinct;
    }

    public void setNumDistinct(Integer numDistinct) {
        this.numDistinct = numDistinct;
    }

    public String getLowValue() {
        return this.lowValue;
    }

    public void setLowValue(String lowValue) {
        this.lowValue = lowValue;
    }

    public String getHighValue() {
        return this.highValue;
    }

    public void setHighValue(String highValue) {
        this.highValue = highValue;
    }

    public String getDensity() {
        return this.density;
    }

    public void setDensity(String density) {
        this.density = density;
    }

    public String getNumNulls() {
        return this.numNulls;
    }

    public void setNumNulls(String numNulls) {
        this.numNulls = numNulls;
    }

    public String getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(String numBuckets) {
        this.numBuckets = numBuckets;
    }

    public String getLastAnalyzed() {
        return this.lastAnalyzed;
    }

    public void setLastAnalyzed(String lastAnalyzed) {
        this.lastAnalyzed = lastAnalyzed;
    }

    public String getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(String sampleSize) {
        this.sampleSize = sampleSize;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public Integer getCharColDeclLength() {
        return this.charColDeclLength;
    }

    public void setCharColDeclLength(Integer charColDeclLength) {
        this.charColDeclLength = charColDeclLength;
    }

    public String getGlobalStats() {
        return this.globalStats;
    }

    public void setGlobalStats(String globalStats) {
        this.globalStats = globalStats;
    }

    public String getUserStats() {
        return this.userStats;
    }

    public void setUserStats(String userStats) {
        this.userStats = userStats;
    }

    public String getAvgColLen() {
        return this.avgColLen;
    }

    public void setAvgColLen(String avgColLen) {
        this.avgColLen = avgColLen;
    }

    public Long getCharLength() {
        return this.charLength;
    }

    public void setCharLength(Long charLength) {
        this.charLength = charLength;
    }

    public String getCharUsed() {
        return this.charUsed;
    }

    public void setCharUsed(String charUsed) {
        this.charUsed = charUsed;
    }

    public String getV80FmtImage() {
        return this.v80FmtImage;
    }

    public void setV80FmtImage(String v80FmtImage) {
        this.v80FmtImage = v80FmtImage;
    }

    public String getDataUpgraded() {
        return this.dataUpgraded;
    }

    public void setDataUpgraded(String dataUpgraded) {
        this.dataUpgraded = dataUpgraded;
    }

    public String getHiddenColumn() {
        return this.hiddenColumn;
    }

    public void setHiddenColumn(String hiddenColumn) {
        this.hiddenColumn = hiddenColumn;
    }

    public String getVirtualColumn() {
        return this.virtualColumn;
    }

    public void setVirtualColumn(String virtualColumn) {
        this.virtualColumn = virtualColumn;
    }

    public int getSegmentColumnId() {
        return this.segmentColumnId;
    }

    public void setSegmentColumnId(int segmentColumnId) {
        this.segmentColumnId = segmentColumnId;
    }

    public int getInternalColumnId() {
        return this.internalColumnId;
    }

    public void setInternalColumnId(int internalColumnId) {
        this.internalColumnId = internalColumnId;
    }

    public String getHistogram() {
        return this.histogram;
    }

    public void setHistogram(String histogram) {
        this.histogram = histogram;
    }

    public String getQualifiedColName() {
        return this.qualifiedColName;
    }

    public void setQualifiedColName(String qualifiedColName) {
        this.qualifiedColName = qualifiedColName;
    }

    public String getUserGenerated() {
        return this.userGenerated;
    }

    public void setUserGenerated(String userGenerated) {
        this.userGenerated = userGenerated;
    }

    public String getDefaultOnNull() {
        return this.defaultOnNull;
    }

    public void setDefaultOnNull(String defaultOnNull) {
        this.defaultOnNull = defaultOnNull;
    }

    public String getIdentityColumn() {
        return this.identityColumn;
    }

    public void setIdentityColumn(String identityColumn) {
        this.identityColumn = identityColumn;
    }

    public String getGenerationType() {
        return this.generationType;
    }

    public void setGenerationType(String generationType) {
        this.generationType = generationType;
    }

    public String getInlineCheckGrammar() {
        return this.inlineCheckGrammar;
    }

    public void setInlineCheckGrammar(String inlineCheckGrammar) {
        this.inlineCheckGrammar = inlineCheckGrammar;
    }

    public ObOracleSequence getIdentityExpr() {
        return this.identityExpr;
    }

    public void setIdentityExpr(ObOracleSequence identityExpr) {
        this.identityExpr = identityExpr;
    }
}

