/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.oboracle;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractIndex;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleIndexPartition;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ObOracleIndex
extends AbstractIndex {
    private final Map<String, String> partitionTypeMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = 8118835403586051723L;
        {
            this.put("HASH", "HASH");
            this.put("LIST_COLU", "LIST");
            this.put("RANGE_COL", "RANGE");
        }
    };
    private final Map<String, String> partitionTemplateMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = 8118835403586051723L;
        {
            this.put("LIST", "PARTITION %s VALUES (%s)");
            this.put("RANGE", "PARTITION %s VALUES LESS THAN (%s)");
        }
    };
    private final Map<String, String> subPartitionTemplateMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = 8118835403586051723L;
        {
            this.put("LIST", "SUBPARTITION %s VALUES (%s)");
            this.put("RANGE", "SUBPARTITION %s VALUES LESS THAN (%s)");
        }
    };
    private String tableType;
    private String uniqueness;
    private String compression;
    private Integer prefixLength;
    private String tablespaceName;
    private Integer iniTrans;
    private Integer maxTrans;
    private Integer initialExtent;
    private Integer nextExtent;
    private Integer minExtents;
    private Integer maxExtents;
    private Integer pctIncrease;
    private Integer pctThreshold;
    private String includeColumn;
    private Integer freeLists;
    private Integer freeListGroups;
    private Integer pctFree;
    private String logging;
    private String blevel;
    private String leafBlocks;
    private String distinctKeys;
    private String avgLeafBlocksPerKey;
    private String avgDataBlocksPerKey;
    private String clusteringFactor;
    private String status;
    private String numRows;
    private String sampleSize;
    private String lastAnalyzed;
    private String degree;
    private String instances;
    private String partitioned;
    private String temporary;
    private String generated;
    private String secondary;
    private String bufferPool;
    private String userStats;
    private String duration;
    private String pctDirectAccess;
    private String itypOwner;
    private String itypName;
    private String parameters;
    private String globalStats;
    private String domIdxStatus;
    private String domIdxOpStatus;
    private String funcIdxStatus;
    private String joinIndex;
    private String iotRedundantPkeyElim;
    private String dropped;
    private String visibility;
    private String domIdxManagement;
    private String segmentCreated;
    private ObOracleIndexPartition indexPartition;

    public ObOracleIndex(ObOracleSchema schema) {
        super(schema);
    }

    @Override
    public ObOracleSchema getSchema() {
        return (ObOracleSchema)super.getSchema();
    }

    public void setSchema(ObOracleSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        ObOracleIndexPartition indexPartition;
        String indexType = this.getIndexType();
        if ("DOMAIN".equals(indexType)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The domain index is unsupported");
        }
        if ("BITMAP".equals(indexType)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The bitmap index is unsupported");
        }
        boolean isReverseIndex = StringUtils.contains(indexType, "NORMAL/REV");
        if (DbType.OBORACLE_2271.isSubsequentFrom(super.getDbType()) && isReverseIndex) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The reverse index is unsupported");
        }
        if ("YES".equals(this.getJoinIndex())) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The join index is unsupported");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        sb.append(this.safetyMapping(this.getUniqueRuleMapping(), this.getUniqueness()));
        String indexName = this.getSchemaIndexName();
        sb.append(" INDEX ").append(indexName);
        sb.append(" ON ").append(this.getSchemaObjectName()).append((CharSequence)this.joinIndexColumns());
        if (isReverseIndex) {
            sb.append(" REVERSE");
        }
        if ((indexPartition = this.getIndexPartition()) != null) {
            sb.append((CharSequence)indexPartition.buildGrammar());
        }
        if ("INVISIBLE".equals(this.getVisibility())) {
            sb.append(" INVISIBLE");
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.INDEX, this.getSimpleIndexName(), this.terminate(sb))});
    }

    @Override
    public StringBuilder joinIndexColumns() {
        ArrayList originIndexColumns = new ArrayList();
        ArrayList changeIndexColumns = new ArrayList();
        this.getIndexColumns().stream().filter(e -> !"I".equals(e.getColumnOrder())).forEach(e -> {
            String columnOrder;
            String columnName = e.getColumnName();
            if (!e.isExpression()) {
                columnName = this.wrap(columnName);
            }
            if (StringUtils.isNotBlank(columnOrder = this.getCollationMapping().get(e.getColumnOrder()))) {
                originIndexColumns.add(columnName + columnOrder);
                changeIndexColumns.add(columnName + " " + "ASC");
            } else {
                originIndexColumns.add(columnName);
                changeIndexColumns.add(columnName);
            }
        });
        ArrayList includeIndexColumns = new ArrayList();
        this.getIndexColumns().stream().filter(e -> "I".equals(e.getColumnOrder())).forEach(e -> {
            String columnName = e.getColumnName();
            if (!e.isExpression()) {
                columnName = this.wrap(columnName);
            }
            includeIndexColumns.add(columnName);
        });
        StringBuilder originIndexClause = new StringBuilder();
        originIndexClause.append((CharSequence)this.enclose(originIndexColumns.stream().collect(Collectors.joining(", "))));
        StringBuilder changeIndexClause = new StringBuilder();
        changeIndexClause.append((CharSequence)this.enclose(changeIndexColumns.stream().collect(Collectors.joining(", "))));
        if (!includeIndexColumns.isEmpty()) {
            String includeClause = includeIndexColumns.stream().collect(Collectors.joining(", "));
            originIndexClause.append(" INCLUDE").append((CharSequence)this.enclose(includeClause));
            changeIndexClause.append(" STORING").append((CharSequence)this.enclose(includeClause));
        }
        return changeIndexClause;
    }

    @Override
    public String toString() {
        return "ObOracleIndex(partitionTypeMapping=" + this.getPartitionTypeMapping() + ", partitionTemplateMapping=" + this.getPartitionTemplateMapping() + ", subPartitionTemplateMapping=" + this.getSubPartitionTemplateMapping() + ", tableType=" + this.getTableType() + ", uniqueness=" + this.getUniqueness() + ", compression=" + this.getCompression() + ", prefixLength=" + this.getPrefixLength() + ", tablespaceName=" + this.getTablespaceName() + ", iniTrans=" + this.getIniTrans() + ", maxTrans=" + this.getMaxTrans() + ", initialExtent=" + this.getInitialExtent() + ", nextExtent=" + this.getNextExtent() + ", minExtents=" + this.getMinExtents() + ", maxExtents=" + this.getMaxExtents() + ", pctIncrease=" + this.getPctIncrease() + ", pctThreshold=" + this.getPctThreshold() + ", includeColumn=" + this.getIncludeColumn() + ", freeLists=" + this.getFreeLists() + ", freeListGroups=" + this.getFreeListGroups() + ", pctFree=" + this.getPctFree() + ", logging=" + this.getLogging() + ", blevel=" + this.getBlevel() + ", leafBlocks=" + this.getLeafBlocks() + ", distinctKeys=" + this.getDistinctKeys() + ", avgLeafBlocksPerKey=" + this.getAvgLeafBlocksPerKey() + ", avgDataBlocksPerKey=" + this.getAvgDataBlocksPerKey() + ", clusteringFactor=" + this.getClusteringFactor() + ", status=" + this.getStatus() + ", numRows=" + this.getNumRows() + ", sampleSize=" + this.getSampleSize() + ", lastAnalyzed=" + this.getLastAnalyzed() + ", degree=" + this.getDegree() + ", instances=" + this.getInstances() + ", partitioned=" + this.getPartitioned() + ", temporary=" + this.getTemporary() + ", generated=" + this.getGenerated() + ", secondary=" + this.getSecondary() + ", bufferPool=" + this.getBufferPool() + ", userStats=" + this.getUserStats() + ", duration=" + this.getDuration() + ", pctDirectAccess=" + this.getPctDirectAccess() + ", itypOwner=" + this.getItypOwner() + ", itypName=" + this.getItypName() + ", parameters=" + this.getParameters() + ", globalStats=" + this.getGlobalStats() + ", domIdxStatus=" + this.getDomIdxStatus() + ", domIdxOpStatus=" + this.getDomIdxOpStatus() + ", funcIdxStatus=" + this.getFuncIdxStatus() + ", joinIndex=" + this.getJoinIndex() + ", iotRedundantPkeyElim=" + this.getIotRedundantPkeyElim() + ", dropped=" + this.getDropped() + ", visibility=" + this.getVisibility() + ", domIdxManagement=" + this.getDomIdxManagement() + ", segmentCreated=" + this.getSegmentCreated() + ", indexPartition=" + this.getIndexPartition() + ")";
    }

    public ObOracleIndex() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObOracleIndex)) {
            return false;
        }
        ObOracleIndex other = (ObOracleIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$prefixLength = this.getPrefixLength();
        Integer other$prefixLength = other.getPrefixLength();
        if (this$prefixLength == null ? other$prefixLength != null : !((Object)this$prefixLength).equals(other$prefixLength)) {
            return false;
        }
        Integer this$iniTrans = this.getIniTrans();
        Integer other$iniTrans = other.getIniTrans();
        if (this$iniTrans == null ? other$iniTrans != null : !((Object)this$iniTrans).equals(other$iniTrans)) {
            return false;
        }
        Integer this$maxTrans = this.getMaxTrans();
        Integer other$maxTrans = other.getMaxTrans();
        if (this$maxTrans == null ? other$maxTrans != null : !((Object)this$maxTrans).equals(other$maxTrans)) {
            return false;
        }
        Integer this$initialExtent = this.getInitialExtent();
        Integer other$initialExtent = other.getInitialExtent();
        if (this$initialExtent == null ? other$initialExtent != null : !((Object)this$initialExtent).equals(other$initialExtent)) {
            return false;
        }
        Integer this$nextExtent = this.getNextExtent();
        Integer other$nextExtent = other.getNextExtent();
        if (this$nextExtent == null ? other$nextExtent != null : !((Object)this$nextExtent).equals(other$nextExtent)) {
            return false;
        }
        Integer this$minExtents = this.getMinExtents();
        Integer other$minExtents = other.getMinExtents();
        if (this$minExtents == null ? other$minExtents != null : !((Object)this$minExtents).equals(other$minExtents)) {
            return false;
        }
        Integer this$maxExtents = this.getMaxExtents();
        Integer other$maxExtents = other.getMaxExtents();
        if (this$maxExtents == null ? other$maxExtents != null : !((Object)this$maxExtents).equals(other$maxExtents)) {
            return false;
        }
        Integer this$pctIncrease = this.getPctIncrease();
        Integer other$pctIncrease = other.getPctIncrease();
        if (this$pctIncrease == null ? other$pctIncrease != null : !((Object)this$pctIncrease).equals(other$pctIncrease)) {
            return false;
        }
        Integer this$pctThreshold = this.getPctThreshold();
        Integer other$pctThreshold = other.getPctThreshold();
        if (this$pctThreshold == null ? other$pctThreshold != null : !((Object)this$pctThreshold).equals(other$pctThreshold)) {
            return false;
        }
        Integer this$freeLists = this.getFreeLists();
        Integer other$freeLists = other.getFreeLists();
        if (this$freeLists == null ? other$freeLists != null : !((Object)this$freeLists).equals(other$freeLists)) {
            return false;
        }
        Integer this$freeListGroups = this.getFreeListGroups();
        Integer other$freeListGroups = other.getFreeListGroups();
        if (this$freeListGroups == null ? other$freeListGroups != null : !((Object)this$freeListGroups).equals(other$freeListGroups)) {
            return false;
        }
        Integer this$pctFree = this.getPctFree();
        Integer other$pctFree = other.getPctFree();
        if (this$pctFree == null ? other$pctFree != null : !((Object)this$pctFree).equals(other$pctFree)) {
            return false;
        }
        Map<String, String> this$partitionTypeMapping = this.getPartitionTypeMapping();
        Map<String, String> other$partitionTypeMapping = other.getPartitionTypeMapping();
        if (this$partitionTypeMapping == null ? other$partitionTypeMapping != null : !((Object)this$partitionTypeMapping).equals(other$partitionTypeMapping)) {
            return false;
        }
        Map<String, String> this$partitionTemplateMapping = this.getPartitionTemplateMapping();
        Map<String, String> other$partitionTemplateMapping = other.getPartitionTemplateMapping();
        if (this$partitionTemplateMapping == null ? other$partitionTemplateMapping != null : !((Object)this$partitionTemplateMapping).equals(other$partitionTemplateMapping)) {
            return false;
        }
        Map<String, String> this$subPartitionTemplateMapping = this.getSubPartitionTemplateMapping();
        Map<String, String> other$subPartitionTemplateMapping = other.getSubPartitionTemplateMapping();
        if (this$subPartitionTemplateMapping == null ? other$subPartitionTemplateMapping != null : !((Object)this$subPartitionTemplateMapping).equals(other$subPartitionTemplateMapping)) {
            return false;
        }
        String this$tableType = this.getTableType();
        String other$tableType = other.getTableType();
        if (this$tableType == null ? other$tableType != null : !this$tableType.equals(other$tableType)) {
            return false;
        }
        String this$uniqueness = this.getUniqueness();
        String other$uniqueness = other.getUniqueness();
        if (this$uniqueness == null ? other$uniqueness != null : !this$uniqueness.equals(other$uniqueness)) {
            return false;
        }
        String this$compression = this.getCompression();
        String other$compression = other.getCompression();
        if (this$compression == null ? other$compression != null : !this$compression.equals(other$compression)) {
            return false;
        }
        String this$tablespaceName = this.getTablespaceName();
        String other$tablespaceName = other.getTablespaceName();
        if (this$tablespaceName == null ? other$tablespaceName != null : !this$tablespaceName.equals(other$tablespaceName)) {
            return false;
        }
        String this$includeColumn = this.getIncludeColumn();
        String other$includeColumn = other.getIncludeColumn();
        if (this$includeColumn == null ? other$includeColumn != null : !this$includeColumn.equals(other$includeColumn)) {
            return false;
        }
        String this$logging = this.getLogging();
        String other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !this$logging.equals(other$logging)) {
            return false;
        }
        String this$blevel = this.getBlevel();
        String other$blevel = other.getBlevel();
        if (this$blevel == null ? other$blevel != null : !this$blevel.equals(other$blevel)) {
            return false;
        }
        String this$leafBlocks = this.getLeafBlocks();
        String other$leafBlocks = other.getLeafBlocks();
        if (this$leafBlocks == null ? other$leafBlocks != null : !this$leafBlocks.equals(other$leafBlocks)) {
            return false;
        }
        String this$distinctKeys = this.getDistinctKeys();
        String other$distinctKeys = other.getDistinctKeys();
        if (this$distinctKeys == null ? other$distinctKeys != null : !this$distinctKeys.equals(other$distinctKeys)) {
            return false;
        }
        String this$avgLeafBlocksPerKey = this.getAvgLeafBlocksPerKey();
        String other$avgLeafBlocksPerKey = other.getAvgLeafBlocksPerKey();
        if (this$avgLeafBlocksPerKey == null ? other$avgLeafBlocksPerKey != null : !this$avgLeafBlocksPerKey.equals(other$avgLeafBlocksPerKey)) {
            return false;
        }
        String this$avgDataBlocksPerKey = this.getAvgDataBlocksPerKey();
        String other$avgDataBlocksPerKey = other.getAvgDataBlocksPerKey();
        if (this$avgDataBlocksPerKey == null ? other$avgDataBlocksPerKey != null : !this$avgDataBlocksPerKey.equals(other$avgDataBlocksPerKey)) {
            return false;
        }
        String this$clusteringFactor = this.getClusteringFactor();
        String other$clusteringFactor = other.getClusteringFactor();
        if (this$clusteringFactor == null ? other$clusteringFactor != null : !this$clusteringFactor.equals(other$clusteringFactor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$numRows = this.getNumRows();
        String other$numRows = other.getNumRows();
        if (this$numRows == null ? other$numRows != null : !this$numRows.equals(other$numRows)) {
            return false;
        }
        String this$sampleSize = this.getSampleSize();
        String other$sampleSize = other.getSampleSize();
        if (this$sampleSize == null ? other$sampleSize != null : !this$sampleSize.equals(other$sampleSize)) {
            return false;
        }
        String this$lastAnalyzed = this.getLastAnalyzed();
        String other$lastAnalyzed = other.getLastAnalyzed();
        if (this$lastAnalyzed == null ? other$lastAnalyzed != null : !this$lastAnalyzed.equals(other$lastAnalyzed)) {
            return false;
        }
        String this$degree = this.getDegree();
        String other$degree = other.getDegree();
        if (this$degree == null ? other$degree != null : !this$degree.equals(other$degree)) {
            return false;
        }
        String this$instances = this.getInstances();
        String other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !this$instances.equals(other$instances)) {
            return false;
        }
        String this$partitioned = this.getPartitioned();
        String other$partitioned = other.getPartitioned();
        if (this$partitioned == null ? other$partitioned != null : !this$partitioned.equals(other$partitioned)) {
            return false;
        }
        String this$temporary = this.getTemporary();
        String other$temporary = other.getTemporary();
        if (this$temporary == null ? other$temporary != null : !this$temporary.equals(other$temporary)) {
            return false;
        }
        String this$generated = this.getGenerated();
        String other$generated = other.getGenerated();
        if (this$generated == null ? other$generated != null : !this$generated.equals(other$generated)) {
            return false;
        }
        String this$secondary = this.getSecondary();
        String other$secondary = other.getSecondary();
        if (this$secondary == null ? other$secondary != null : !this$secondary.equals(other$secondary)) {
            return false;
        }
        String this$bufferPool = this.getBufferPool();
        String other$bufferPool = other.getBufferPool();
        if (this$bufferPool == null ? other$bufferPool != null : !this$bufferPool.equals(other$bufferPool)) {
            return false;
        }
        String this$userStats = this.getUserStats();
        String other$userStats = other.getUserStats();
        if (this$userStats == null ? other$userStats != null : !this$userStats.equals(other$userStats)) {
            return false;
        }
        String this$duration = this.getDuration();
        String other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
            return false;
        }
        String this$pctDirectAccess = this.getPctDirectAccess();
        String other$pctDirectAccess = other.getPctDirectAccess();
        if (this$pctDirectAccess == null ? other$pctDirectAccess != null : !this$pctDirectAccess.equals(other$pctDirectAccess)) {
            return false;
        }
        String this$itypOwner = this.getItypOwner();
        String other$itypOwner = other.getItypOwner();
        if (this$itypOwner == null ? other$itypOwner != null : !this$itypOwner.equals(other$itypOwner)) {
            return false;
        }
        String this$itypName = this.getItypName();
        String other$itypName = other.getItypName();
        if (this$itypName == null ? other$itypName != null : !this$itypName.equals(other$itypName)) {
            return false;
        }
        String this$parameters = this.getParameters();
        String other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters)) {
            return false;
        }
        String this$globalStats = this.getGlobalStats();
        String other$globalStats = other.getGlobalStats();
        if (this$globalStats == null ? other$globalStats != null : !this$globalStats.equals(other$globalStats)) {
            return false;
        }
        String this$domIdxStatus = this.getDomIdxStatus();
        String other$domIdxStatus = other.getDomIdxStatus();
        if (this$domIdxStatus == null ? other$domIdxStatus != null : !this$domIdxStatus.equals(other$domIdxStatus)) {
            return false;
        }
        String this$domIdxOpStatus = this.getDomIdxOpStatus();
        String other$domIdxOpStatus = other.getDomIdxOpStatus();
        if (this$domIdxOpStatus == null ? other$domIdxOpStatus != null : !this$domIdxOpStatus.equals(other$domIdxOpStatus)) {
            return false;
        }
        String this$funcIdxStatus = this.getFuncIdxStatus();
        String other$funcIdxStatus = other.getFuncIdxStatus();
        if (this$funcIdxStatus == null ? other$funcIdxStatus != null : !this$funcIdxStatus.equals(other$funcIdxStatus)) {
            return false;
        }
        String this$joinIndex = this.getJoinIndex();
        String other$joinIndex = other.getJoinIndex();
        if (this$joinIndex == null ? other$joinIndex != null : !this$joinIndex.equals(other$joinIndex)) {
            return false;
        }
        String this$iotRedundantPkeyElim = this.getIotRedundantPkeyElim();
        String other$iotRedundantPkeyElim = other.getIotRedundantPkeyElim();
        if (this$iotRedundantPkeyElim == null ? other$iotRedundantPkeyElim != null : !this$iotRedundantPkeyElim.equals(other$iotRedundantPkeyElim)) {
            return false;
        }
        String this$dropped = this.getDropped();
        String other$dropped = other.getDropped();
        if (this$dropped == null ? other$dropped != null : !this$dropped.equals(other$dropped)) {
            return false;
        }
        String this$visibility = this.getVisibility();
        String other$visibility = other.getVisibility();
        if (this$visibility == null ? other$visibility != null : !this$visibility.equals(other$visibility)) {
            return false;
        }
        String this$domIdxManagement = this.getDomIdxManagement();
        String other$domIdxManagement = other.getDomIdxManagement();
        if (this$domIdxManagement == null ? other$domIdxManagement != null : !this$domIdxManagement.equals(other$domIdxManagement)) {
            return false;
        }
        String this$segmentCreated = this.getSegmentCreated();
        String other$segmentCreated = other.getSegmentCreated();
        if (this$segmentCreated == null ? other$segmentCreated != null : !this$segmentCreated.equals(other$segmentCreated)) {
            return false;
        }
        ObOracleIndexPartition this$indexPartition = this.getIndexPartition();
        ObOracleIndexPartition other$indexPartition = other.getIndexPartition();
        return !(this$indexPartition == null ? other$indexPartition != null : !((Object)this$indexPartition).equals(other$indexPartition));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObOracleIndex;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $prefixLength = this.getPrefixLength();
        result = result * 59 + ($prefixLength == null ? 43 : ((Object)$prefixLength).hashCode());
        Integer $iniTrans = this.getIniTrans();
        result = result * 59 + ($iniTrans == null ? 43 : ((Object)$iniTrans).hashCode());
        Integer $maxTrans = this.getMaxTrans();
        result = result * 59 + ($maxTrans == null ? 43 : ((Object)$maxTrans).hashCode());
        Integer $initialExtent = this.getInitialExtent();
        result = result * 59 + ($initialExtent == null ? 43 : ((Object)$initialExtent).hashCode());
        Integer $nextExtent = this.getNextExtent();
        result = result * 59 + ($nextExtent == null ? 43 : ((Object)$nextExtent).hashCode());
        Integer $minExtents = this.getMinExtents();
        result = result * 59 + ($minExtents == null ? 43 : ((Object)$minExtents).hashCode());
        Integer $maxExtents = this.getMaxExtents();
        result = result * 59 + ($maxExtents == null ? 43 : ((Object)$maxExtents).hashCode());
        Integer $pctIncrease = this.getPctIncrease();
        result = result * 59 + ($pctIncrease == null ? 43 : ((Object)$pctIncrease).hashCode());
        Integer $pctThreshold = this.getPctThreshold();
        result = result * 59 + ($pctThreshold == null ? 43 : ((Object)$pctThreshold).hashCode());
        Integer $freeLists = this.getFreeLists();
        result = result * 59 + ($freeLists == null ? 43 : ((Object)$freeLists).hashCode());
        Integer $freeListGroups = this.getFreeListGroups();
        result = result * 59 + ($freeListGroups == null ? 43 : ((Object)$freeListGroups).hashCode());
        Integer $pctFree = this.getPctFree();
        result = result * 59 + ($pctFree == null ? 43 : ((Object)$pctFree).hashCode());
        Map<String, String> $partitionTypeMapping = this.getPartitionTypeMapping();
        result = result * 59 + ($partitionTypeMapping == null ? 43 : ((Object)$partitionTypeMapping).hashCode());
        Map<String, String> $partitionTemplateMapping = this.getPartitionTemplateMapping();
        result = result * 59 + ($partitionTemplateMapping == null ? 43 : ((Object)$partitionTemplateMapping).hashCode());
        Map<String, String> $subPartitionTemplateMapping = this.getSubPartitionTemplateMapping();
        result = result * 59 + ($subPartitionTemplateMapping == null ? 43 : ((Object)$subPartitionTemplateMapping).hashCode());
        String $tableType = this.getTableType();
        result = result * 59 + ($tableType == null ? 43 : $tableType.hashCode());
        String $uniqueness = this.getUniqueness();
        result = result * 59 + ($uniqueness == null ? 43 : $uniqueness.hashCode());
        String $compression = this.getCompression();
        result = result * 59 + ($compression == null ? 43 : $compression.hashCode());
        String $tablespaceName = this.getTablespaceName();
        result = result * 59 + ($tablespaceName == null ? 43 : $tablespaceName.hashCode());
        String $includeColumn = this.getIncludeColumn();
        result = result * 59 + ($includeColumn == null ? 43 : $includeColumn.hashCode());
        String $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : $logging.hashCode());
        String $blevel = this.getBlevel();
        result = result * 59 + ($blevel == null ? 43 : $blevel.hashCode());
        String $leafBlocks = this.getLeafBlocks();
        result = result * 59 + ($leafBlocks == null ? 43 : $leafBlocks.hashCode());
        String $distinctKeys = this.getDistinctKeys();
        result = result * 59 + ($distinctKeys == null ? 43 : $distinctKeys.hashCode());
        String $avgLeafBlocksPerKey = this.getAvgLeafBlocksPerKey();
        result = result * 59 + ($avgLeafBlocksPerKey == null ? 43 : $avgLeafBlocksPerKey.hashCode());
        String $avgDataBlocksPerKey = this.getAvgDataBlocksPerKey();
        result = result * 59 + ($avgDataBlocksPerKey == null ? 43 : $avgDataBlocksPerKey.hashCode());
        String $clusteringFactor = this.getClusteringFactor();
        result = result * 59 + ($clusteringFactor == null ? 43 : $clusteringFactor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $numRows = this.getNumRows();
        result = result * 59 + ($numRows == null ? 43 : $numRows.hashCode());
        String $sampleSize = this.getSampleSize();
        result = result * 59 + ($sampleSize == null ? 43 : $sampleSize.hashCode());
        String $lastAnalyzed = this.getLastAnalyzed();
        result = result * 59 + ($lastAnalyzed == null ? 43 : $lastAnalyzed.hashCode());
        String $degree = this.getDegree();
        result = result * 59 + ($degree == null ? 43 : $degree.hashCode());
        String $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : $instances.hashCode());
        String $partitioned = this.getPartitioned();
        result = result * 59 + ($partitioned == null ? 43 : $partitioned.hashCode());
        String $temporary = this.getTemporary();
        result = result * 59 + ($temporary == null ? 43 : $temporary.hashCode());
        String $generated = this.getGenerated();
        result = result * 59 + ($generated == null ? 43 : $generated.hashCode());
        String $secondary = this.getSecondary();
        result = result * 59 + ($secondary == null ? 43 : $secondary.hashCode());
        String $bufferPool = this.getBufferPool();
        result = result * 59 + ($bufferPool == null ? 43 : $bufferPool.hashCode());
        String $userStats = this.getUserStats();
        result = result * 59 + ($userStats == null ? 43 : $userStats.hashCode());
        String $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
        String $pctDirectAccess = this.getPctDirectAccess();
        result = result * 59 + ($pctDirectAccess == null ? 43 : $pctDirectAccess.hashCode());
        String $itypOwner = this.getItypOwner();
        result = result * 59 + ($itypOwner == null ? 43 : $itypOwner.hashCode());
        String $itypName = this.getItypName();
        result = result * 59 + ($itypName == null ? 43 : $itypName.hashCode());
        String $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
        String $globalStats = this.getGlobalStats();
        result = result * 59 + ($globalStats == null ? 43 : $globalStats.hashCode());
        String $domIdxStatus = this.getDomIdxStatus();
        result = result * 59 + ($domIdxStatus == null ? 43 : $domIdxStatus.hashCode());
        String $domIdxOpStatus = this.getDomIdxOpStatus();
        result = result * 59 + ($domIdxOpStatus == null ? 43 : $domIdxOpStatus.hashCode());
        String $funcIdxStatus = this.getFuncIdxStatus();
        result = result * 59 + ($funcIdxStatus == null ? 43 : $funcIdxStatus.hashCode());
        String $joinIndex = this.getJoinIndex();
        result = result * 59 + ($joinIndex == null ? 43 : $joinIndex.hashCode());
        String $iotRedundantPkeyElim = this.getIotRedundantPkeyElim();
        result = result * 59 + ($iotRedundantPkeyElim == null ? 43 : $iotRedundantPkeyElim.hashCode());
        String $dropped = this.getDropped();
        result = result * 59 + ($dropped == null ? 43 : $dropped.hashCode());
        String $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : $visibility.hashCode());
        String $domIdxManagement = this.getDomIdxManagement();
        result = result * 59 + ($domIdxManagement == null ? 43 : $domIdxManagement.hashCode());
        String $segmentCreated = this.getSegmentCreated();
        result = result * 59 + ($segmentCreated == null ? 43 : $segmentCreated.hashCode());
        ObOracleIndexPartition $indexPartition = this.getIndexPartition();
        result = result * 59 + ($indexPartition == null ? 43 : ((Object)$indexPartition).hashCode());
        return result;
    }

    public Map<String, String> getPartitionTypeMapping() {
        return this.partitionTypeMapping;
    }

    public Map<String, String> getPartitionTemplateMapping() {
        return this.partitionTemplateMapping;
    }

    public Map<String, String> getSubPartitionTemplateMapping() {
        return this.subPartitionTemplateMapping;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getUniqueness() {
        return this.uniqueness;
    }

    public void setUniqueness(String uniqueness) {
        this.uniqueness = uniqueness;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public Integer getPrefixLength() {
        return this.prefixLength;
    }

    public void setPrefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public void setTablespaceName(String tablespaceName) {
        this.tablespaceName = tablespaceName;
    }

    public Integer getIniTrans() {
        return this.iniTrans;
    }

    public void setIniTrans(Integer iniTrans) {
        this.iniTrans = iniTrans;
    }

    public Integer getMaxTrans() {
        return this.maxTrans;
    }

    public void setMaxTrans(Integer maxTrans) {
        this.maxTrans = maxTrans;
    }

    public Integer getInitialExtent() {
        return this.initialExtent;
    }

    public void setInitialExtent(Integer initialExtent) {
        this.initialExtent = initialExtent;
    }

    public Integer getNextExtent() {
        return this.nextExtent;
    }

    public void setNextExtent(Integer nextExtent) {
        this.nextExtent = nextExtent;
    }

    public Integer getMinExtents() {
        return this.minExtents;
    }

    public void setMinExtents(Integer minExtents) {
        this.minExtents = minExtents;
    }

    public Integer getMaxExtents() {
        return this.maxExtents;
    }

    public void setMaxExtents(Integer maxExtents) {
        this.maxExtents = maxExtents;
    }

    public Integer getPctIncrease() {
        return this.pctIncrease;
    }

    public void setPctIncrease(Integer pctIncrease) {
        this.pctIncrease = pctIncrease;
    }

    public Integer getPctThreshold() {
        return this.pctThreshold;
    }

    public void setPctThreshold(Integer pctThreshold) {
        this.pctThreshold = pctThreshold;
    }

    public String getIncludeColumn() {
        return this.includeColumn;
    }

    public void setIncludeColumn(String includeColumn) {
        this.includeColumn = includeColumn;
    }

    public Integer getFreeLists() {
        return this.freeLists;
    }

    public void setFreeLists(Integer freeLists) {
        this.freeLists = freeLists;
    }

    public Integer getFreeListGroups() {
        return this.freeListGroups;
    }

    public void setFreeListGroups(Integer freeListGroups) {
        this.freeListGroups = freeListGroups;
    }

    public Integer getPctFree() {
        return this.pctFree;
    }

    public void setPctFree(Integer pctFree) {
        this.pctFree = pctFree;
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String logging) {
        this.logging = logging;
    }

    public String getBlevel() {
        return this.blevel;
    }

    public void setBlevel(String blevel) {
        this.blevel = blevel;
    }

    public String getLeafBlocks() {
        return this.leafBlocks;
    }

    public void setLeafBlocks(String leafBlocks) {
        this.leafBlocks = leafBlocks;
    }

    public String getDistinctKeys() {
        return this.distinctKeys;
    }

    public void setDistinctKeys(String distinctKeys) {
        this.distinctKeys = distinctKeys;
    }

    public String getAvgLeafBlocksPerKey() {
        return this.avgLeafBlocksPerKey;
    }

    public void setAvgLeafBlocksPerKey(String avgLeafBlocksPerKey) {
        this.avgLeafBlocksPerKey = avgLeafBlocksPerKey;
    }

    public String getAvgDataBlocksPerKey() {
        return this.avgDataBlocksPerKey;
    }

    public void setAvgDataBlocksPerKey(String avgDataBlocksPerKey) {
        this.avgDataBlocksPerKey = avgDataBlocksPerKey;
    }

    public String getClusteringFactor() {
        return this.clusteringFactor;
    }

    public void setClusteringFactor(String clusteringFactor) {
        this.clusteringFactor = clusteringFactor;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getNumRows() {
        return this.numRows;
    }

    public void setNumRows(String numRows) {
        this.numRows = numRows;
    }

    public String getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(String sampleSize) {
        this.sampleSize = sampleSize;
    }

    public String getLastAnalyzed() {
        return this.lastAnalyzed;
    }

    public void setLastAnalyzed(String lastAnalyzed) {
        this.lastAnalyzed = lastAnalyzed;
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String degree) {
        this.degree = degree;
    }

    public String getInstances() {
        return this.instances;
    }

    public void setInstances(String instances) {
        this.instances = instances;
    }

    public String getPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(String partitioned) {
        this.partitioned = partitioned;
    }

    public String getTemporary() {
        return this.temporary;
    }

    public void setTemporary(String temporary) {
        this.temporary = temporary;
    }

    public String getGenerated() {
        return this.generated;
    }

    public void setGenerated(String generated) {
        this.generated = generated;
    }

    public String getSecondary() {
        return this.secondary;
    }

    public void setSecondary(String secondary) {
        this.secondary = secondary;
    }

    public String getBufferPool() {
        return this.bufferPool;
    }

    public void setBufferPool(String bufferPool) {
        this.bufferPool = bufferPool;
    }

    public String getUserStats() {
        return this.userStats;
    }

    public void setUserStats(String userStats) {
        this.userStats = userStats;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getPctDirectAccess() {
        return this.pctDirectAccess;
    }

    public void setPctDirectAccess(String pctDirectAccess) {
        this.pctDirectAccess = pctDirectAccess;
    }

    public String getItypOwner() {
        return this.itypOwner;
    }

    public void setItypOwner(String itypOwner) {
        this.itypOwner = itypOwner;
    }

    public String getItypName() {
        return this.itypName;
    }

    public void setItypName(String itypName) {
        this.itypName = itypName;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public String getGlobalStats() {
        return this.globalStats;
    }

    public void setGlobalStats(String globalStats) {
        this.globalStats = globalStats;
    }

    public String getDomIdxStatus() {
        return this.domIdxStatus;
    }

    public void setDomIdxStatus(String domIdxStatus) {
        this.domIdxStatus = domIdxStatus;
    }

    public String getDomIdxOpStatus() {
        return this.domIdxOpStatus;
    }

    public void setDomIdxOpStatus(String domIdxOpStatus) {
        this.domIdxOpStatus = domIdxOpStatus;
    }

    public String getFuncIdxStatus() {
        return this.funcIdxStatus;
    }

    public void setFuncIdxStatus(String funcIdxStatus) {
        this.funcIdxStatus = funcIdxStatus;
    }

    public String getJoinIndex() {
        return this.joinIndex;
    }

    public void setJoinIndex(String joinIndex) {
        this.joinIndex = joinIndex;
    }

    public String getIotRedundantPkeyElim() {
        return this.iotRedundantPkeyElim;
    }

    public void setIotRedundantPkeyElim(String iotRedundantPkeyElim) {
        this.iotRedundantPkeyElim = iotRedundantPkeyElim;
    }

    public String getDropped() {
        return this.dropped;
    }

    public void setDropped(String dropped) {
        this.dropped = dropped;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getDomIdxManagement() {
        return this.domIdxManagement;
    }

    public void setDomIdxManagement(String domIdxManagement) {
        this.domIdxManagement = domIdxManagement;
    }

    public String getSegmentCreated() {
        return this.segmentCreated;
    }

    public void setSegmentCreated(String segmentCreated) {
        this.segmentCreated = segmentCreated;
    }

    public ObOracleIndexPartition getIndexPartition() {
        return this.indexPartition;
    }

    public void setIndexPartition(ObOracleIndexPartition indexPartition) {
        this.indexPartition = indexPartition;
    }
}

