/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.tablefmt;

import com.oceanbase.tools.loaddump.tablefmt.BorderStyle;
import com.oceanbase.tools.loaddump.tablefmt.Cell;
import com.oceanbase.tools.loaddump.tablefmt.CellStyle;
import com.oceanbase.tools.loaddump.tablefmt.Column;
import com.oceanbase.tools.loaddump.tablefmt.Row;
import com.oceanbase.tools.loaddump.tablefmt.ShownBorders;
import com.oceanbase.tools.loaddump.tablefmt.TableStyle;
import java.util.ArrayList;
import java.util.List;

public class Table {
    private static final int DEFAULT_MIN_WIDTH = 0;
    private static final int DEFAULT_MAX_WIDTH = Integer.MAX_VALUE;
    private TableStyle tableStyle;
    private List<Row> rows;
    private List<Column> columns;
    private int totalColumns;
    private int currentColumn;
    private Row currentRow;

    public Table(int totalColumns) {
        this.initialize(totalColumns);
        this.tableStyle = new TableStyle(BorderStyle.HORIZONTAL_ONLY, ShownBorders.SURROUND_HEADER_AND_COLUMNS, 0, null);
    }

    public Table(int totalColumns, BorderStyle borderStyle) {
        this.initialize(totalColumns);
        this.tableStyle = new TableStyle(borderStyle, ShownBorders.SURROUND_HEADER_AND_COLUMNS, 0, null);
    }

    private void initialize(int totalColumns) {
        this.totalColumns = totalColumns;
        this.rows = new ArrayList<Row>();
        this.columns = new ArrayList<Column>();
        for (int i = 0; i < this.totalColumns; ++i) {
            this.columns.add(new Column(i, 0, Integer.MAX_VALUE));
        }
        this.currentColumn = 0;
        this.currentRow = null;
    }

    public void setColumnWidth(int col, int minWidth, int maxWidth) {
        this.columns.get(col).setWidthRange(minWidth, maxWidth);
    }

    public void addCell(String content) {
        this.addCell(content, new CellStyle());
    }

    public void addCell(String content, int colSpan) {
        this.addCell(content, new CellStyle(), colSpan);
    }

    public void addCell(String content, CellStyle style) {
        this.addCell(content, style, 1);
    }

    public void addCell(String content, CellStyle style, int colSpan) {
        int adjColSpan;
        if (this.currentRow == null || this.currentColumn >= this.totalColumns) {
            this.currentRow = new Row();
            this.rows.add(this.currentRow);
            this.currentColumn = 0;
        }
        int n = adjColSpan = colSpan > 0 ? colSpan : 1;
        if (this.currentColumn + adjColSpan > this.totalColumns) {
            adjColSpan = this.totalColumns - this.currentColumn;
        }
        this.currentRow.addCell(content, style, adjColSpan);
        this.currentColumn += adjColSpan;
    }

    List<Row> getRows() {
        return this.rows;
    }

    List<Column> getColumns() {
        return this.columns;
    }

    public StringBuilder render() {
        this.calculateColumnsWidth();
        return this.tableStyle.renderTable(this);
    }

    public String[] renderAsStringArray() {
        this.calculateColumnsWidth();
        return this.tableStyle.renderAsStringArray(this);
    }

    int getTotalColumns() {
        return this.totalColumns;
    }

    private void calculateColumnsWidth() {
        for (Row r : this.rows) {
            int startCol = 0;
            for (Cell cell : r.getCells()) {
                int endCol = startCol + cell.getColSpan() - 1;
                try {
                    Column col = this.columns.get(endCol);
                    col.add(cell);
                    startCol += cell.getColSpan();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
        }
        for (Column col : this.columns) {
            col.calculateWidth(this.columns, this.tableStyle.borderStyle.getTCCorner().length());
        }
    }
}

