/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.context.SqlContext;
import com.oceanbase.tools.loaddump.parser.record.Record;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.NumberUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlUtils.class);
    public static final String FLOAT_REGEX = "(\\+|\\-)?\\d+\\.?\\d*";
    public static final String SUB_TIME_REGEX = "\\d{2} \\d{2}:\\d{2}:\\d{2}.(\\d{6}|\\d{9})";
    private static final int MAXIMUM_CAPACITY = 16384;
    private static final Logger BAD_RECORD_LOGGER = LoggerFactory.getLogger((String)"BadRecordLogger");
    private static final Map<ServerMode, String> CACHE = new HashMap<ServerMode, String>();
    private static final Set<String> CHAR_TYPES = new HashSet<String>();
    private static final Set<String> BINARY_TYPES = new HashSet<String>();
    private static final String[] STORAGE_CAPACITY_UNIT = new String[]{" B", " KB", " MB", " GB", " TB", " PB"};

    private SqlUtils() {
    }

    public static int powerOfTwo(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 16384 ? 16384 : n + 1);
    }

    public static SqlContext translateInsertMultiValuesSqlContext(TableInfo tableInfo, List<Record> records) {
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"The table info is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(records), (Object)"The record list is null");
        boolean status = true;
        int valueCount = records.get(0).size();
        int recordCount = 0;
        ArrayList args = new ArrayList(valueCount * records.size());
        ArrayList<String> tmpArgs = new ArrayList<String>(valueCount);
        block0: for (Record record : records) {
            if (!record.isValid()) {
                BAD_RECORD_LOGGER.error("{} VALUES ({});\nCause: {}\n", new Object[]{tableInfo.getInsertPrefix(), record.getValues().stream().map(e -> e == null ? "null" : "'" + e + "'").collect(Collectors.joining(",")), record.getBadCause()});
                continue;
            }
            tmpArgs.clear();
            int valueSize = record.size();
            for (int logicPosition = 0; logicPosition < valueSize; ++logicPosition) {
                Integer offset = tableInfo.getPhysicOffset(logicPosition);
                if (offset == null) {
                    status = false;
                    BAD_RECORD_LOGGER.error("{} VALUES ({});\nCause: {}\n", new Object[]{tableInfo.getInsertPrefix(), record.getValues().stream().map(e -> e == null ? "null" : "'" + e + "'").collect(Collectors.joining(",")), "No table column matches the logical offset " + logicPosition + " of this record"});
                    continue block0;
                }
                if (tableInfo.isVirtualColumn(logicPosition) || tableInfo.containsDbSequence(tableInfo.getColumnNameList().get(logicPosition))) continue;
                String value = record.get(logicPosition);
                boolean isNullable = tableInfo.isNullable(logicPosition);
                if (isNullable && (StringUtils.isEmpty(value) || "null".equalsIgnoreCase(value)) && !SqlUtils.isCharType(tableInfo.getColumnTypeName(logicPosition))) {
                    value = null;
                }
                tmpArgs.add(value);
            }
            ++recordCount;
            args.addAll(tmpArgs);
        }
        ArrayList<List<String>> batchArgs = new ArrayList<List<String>>(1);
        batchArgs.add(args);
        String insert = tableInfo.cachedSqlStmt(records.get(0).size(), recordCount);
        return new SqlContext(insert, recordCount, batchArgs, status);
    }

    public static List<SqlContext> translateInsertSingleValueSqlContext(TableInfo tableInfo, List<Record> records) {
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"The table info is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(records), (Object)"The record list is null");
        int valueCount = records.get(0).size();
        ArrayList<SqlContext> contexts = new ArrayList<SqlContext>();
        block0: for (Record record : records) {
            if (!record.isValid()) {
                BAD_RECORD_LOGGER.error("{} VALUES ({});\nCause: {}\n", new Object[]{tableInfo.getInsertPrefix(), record.getValues().stream().map(e -> e == null ? "null" : "'" + e + "'").collect(Collectors.joining(",")), record.getBadCause()});
                continue;
            }
            ArrayList<List<String>> batchArgs = new ArrayList<List<String>>(1);
            valueCount = Math.max(valueCount, record.size());
            ArrayList<String> values = new ArrayList<String>(valueCount);
            for (int logicPosition = 0; logicPosition < valueCount; ++logicPosition) {
                Integer offset = tableInfo.getPhysicOffset(logicPosition);
                if (offset == null) {
                    BAD_RECORD_LOGGER.error("{} VALUES ({});\nCause: {}\n", new Object[]{tableInfo.getInsertPrefix(), record.getValues().stream().map(e -> e == null ? "null" : "'" + e + "'").collect(Collectors.joining(",")), "No table column matches the logical offset " + logicPosition + " of this record"});
                    continue block0;
                }
                String columnName = tableInfo.getColumnNameList().get(logicPosition);
                if (tableInfo.isVirtualColumn(columnName) || tableInfo.containsDbSequence(columnName)) continue;
                String value = record.get(logicPosition);
                boolean isNullable = tableInfo.isNullable(logicPosition);
                if (isNullable && (StringUtils.isEmpty(value) || "null".equalsIgnoreCase(value)) && !SqlUtils.isCharType(tableInfo.getColumnTypeName(logicPosition))) {
                    value = null;
                }
                values.add(value);
            }
            batchArgs.add(values);
            String insert = tableInfo.cachedSqlStmt(valueCount, 1);
            contexts.add(new SqlContext(insert, 1, batchArgs, true));
        }
        return contexts;
    }

    public static SqlContext translateInsertBatchValueSqlContext(TableInfo tableInfo, List<Record> records) {
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"The table info is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(records), (Object)"The record list is null");
        int valueCount = records.get(0).size();
        int recordCount = records.size();
        ArrayList<List<String>> batchArgs = new ArrayList<List<String>>(recordCount);
        boolean status = true;
        block0: for (Record record : records) {
            if (!record.isValid()) {
                status = false;
                BAD_RECORD_LOGGER.error("{} VALUES ({});\nCause: {}\n", new Object[]{tableInfo.getInsertPrefix(), record.getValues().stream().map(e -> e == null ? "null" : "'" + e + "'").collect(Collectors.joining(",")), record.getBadCause()});
                continue;
            }
            valueCount = Math.max(valueCount, record.size());
            ArrayList<String> values = new ArrayList<String>(valueCount);
            for (int logicPosition = 0; logicPosition < valueCount; ++logicPosition) {
                Integer offset = tableInfo.getPhysicOffset(logicPosition);
                String columnName = tableInfo.getColumnNameList().get(logicPosition);
                if (tableInfo.isVirtualColumn(columnName)) continue;
                if (offset == null) {
                    status = false;
                    BAD_RECORD_LOGGER.error("{} VALUES ({});\nCause: {}\n", new Object[]{tableInfo.getInsertPrefix(), record.getValues().stream().map(e -> e == null ? "null" : "'" + e + "'").collect(Collectors.joining(",")), "No table column matches the logical offset " + logicPosition + " of this record"});
                    continue block0;
                }
                if (tableInfo.containsDbSequence(columnName)) continue;
                String value = record.get(logicPosition);
                boolean isNullable = tableInfo.isNullable(logicPosition);
                if (isNullable && (StringUtils.isEmpty(value) || "null".equalsIgnoreCase(value)) && !SqlUtils.isCharType(tableInfo.getColumnTypeName(logicPosition))) {
                    value = null;
                }
                values.add(value);
            }
            batchArgs.add(values);
        }
        String insert = tableInfo.cachedSqlStmt(valueCount, 1);
        return new SqlContext(insert, 1, batchArgs, status);
    }

    public static SqlContext translateDeleteSqlContext(TableInfo tableInfo, List<Record> records) {
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"The table info is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(records), (Object)"The record list is null");
        boolean status = true;
        int valueSize = records.get(0).size();
        int recordSize = records.size();
        List<String> primaryColumns = tableInfo.getPrimaryColumnNames();
        ArrayList<String> args = new ArrayList<String>(recordSize);
        Map<String, List<String>> uniqueKeyMap = tableInfo.getUniqueKeyMap();
        boolean hasPrimaryKey = tableInfo.hasPrimaryKey();
        boolean hasUniqueKey = tableInfo.hasUniqueKey();
        StringBuilder delete = new StringBuilder(1024 * records.size());
        delete.append("DELETE FROM ").append(tableInfo.getSchemaTable()).append(" WHERE ");
        Iterator<Record> iterator = records.iterator();
        while (iterator.hasNext()) {
            Record record = iterator.next();
            try {
                delete.append("(");
                valueSize = Math.max(valueSize, record.size());
                ArrayList<String> values = new ArrayList<String>(valueSize);
                if (hasPrimaryKey) {
                    delete.append((CharSequence)SqlUtils.buildCondition(primaryColumns, values, tableInfo, record));
                }
                if (hasUniqueKey) {
                    if (hasPrimaryKey) {
                        delete.append(" OR ");
                    }
                    Iterator<Map.Entry<String, List<String>>> entries = uniqueKeyMap.entrySet().iterator();
                    while (entries.hasNext()) {
                        delete.append((CharSequence)SqlUtils.buildCondition(entries.next().getValue(), values, tableInfo, record));
                        if (!entries.hasNext()) continue;
                        delete.append(" OR ");
                    }
                }
                delete.append(")");
                if (iterator.hasNext()) {
                    delete.append(" OR ");
                }
                args.addAll(values);
            }
            catch (Exception ex) {
                status = false;
                log.error("Fatal Error: {}. See the bad record in the file: ../logs/ob-loader-dumper.bad", (Object)ExceptionUtils.getRootCauseMessage(ex));
                BAD_RECORD_LOGGER.error("{} VALUES ({});\nCause: {}\n", new Object[]{tableInfo.getInsertPrefix(), record.getValues().stream().map(e -> e == null ? "null" : "'" + e + "'").collect(Collectors.joining(",")), ex.getMessage()});
            }
        }
        ArrayList<List<String>> batchArgs = new ArrayList<List<String>>(1);
        batchArgs.add(args);
        return new SqlContext(delete.toString(), records.size(), batchArgs, status);
    }

    public static List<SqlContext> translateMergeIntoSingleStatement(TableInfo tableInfo, List<Record> records) {
        Preconditions.checkArgument((tableInfo != null ? 1 : 0) != 0, (Object)"The table info is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(records), (Object)"The record list is null");
        int valueCount = records.get(0).size();
        ArrayList<SqlContext> contexts = new ArrayList<SqlContext>();
        block0: for (Record record : records) {
            if (!record.isValid()) {
                BAD_RECORD_LOGGER.error("{} VALUES ({});\nCause: {}\n", new Object[]{tableInfo.getInsertPrefix(), record.getValues().stream().map(e -> e == null ? "null" : "'" + e + "'").collect(Collectors.joining(",")), record.getBadCause()});
                continue;
            }
            valueCount = Math.max(valueCount, record.size());
            ArrayList<String> values = new ArrayList<String>(valueCount);
            String sql = tableInfo.cachedMergeIntoSqlStmt(valueCount);
            for (int logicPosition = 0; logicPosition < valueCount; ++logicPosition) {
                Integer offset = tableInfo.getPhysicOffset(logicPosition);
                if (offset == null) {
                    BAD_RECORD_LOGGER.error("{} VALUES ({});\nCause: {}\n", new Object[]{tableInfo.getInsertPrefix(), record.getValues().stream().map(e -> e == null ? "null" : "'" + e + "'").collect(Collectors.joining(",")), "No table column matches the logical offset " + logicPosition + " of this record"});
                    continue block0;
                }
                String columnName = tableInfo.getColumnNameList().get(logicPosition);
                if (tableInfo.isVirtualColumn(columnName) || tableInfo.containsDbSequence(columnName)) continue;
                String value = record.get(logicPosition);
                boolean isNullable = tableInfo.isNullable(logicPosition);
                if (isNullable && (StringUtils.isEmpty(value) || "null".equalsIgnoreCase(value)) && !SqlUtils.isCharType(tableInfo.getColumnTypeName(logicPosition))) {
                    value = null;
                }
                values.add(value);
            }
            ArrayList<List<String>> batchArgs = new ArrayList<List<String>>(1);
            batchArgs.add(values);
            contexts.add(new SqlContext(sql, 1, batchArgs, true));
        }
        return contexts;
    }

    private static StringBuilder buildCondition(List<String> keyColumns, List<String> values, TableInfo tableInfo, Record record) {
        boolean isUseUnhex = tableInfo.isMySqlMode() && !tableInfo.isIgnoreUnhex();
        int capacity = keyColumns.stream().mapToInt(String::length).sum() + values.size() * 16;
        StringBuilder condition = new StringBuilder(capacity);
        condition.append("(");
        Iterator<String> iter = keyColumns.iterator();
        while (iter.hasNext()) {
            String column = iter.next();
            Integer logicPosition = tableInfo.getLogicOffset(column);
            Integer offset = tableInfo.getPhysicOffset(logicPosition);
            if (offset == null || tableInfo.isVirtualColumn(logicPosition)) continue;
            condition.append(column);
            String value = record.get(logicPosition);
            boolean isNullable = tableInfo.isNullable(logicPosition);
            if (isNullable && StringUtils.isEmpty(value) && !SqlUtils.isCharType(tableInfo.getColumnTypeName(logicPosition))) {
                value = null;
            }
            if (isNullable && "null".equalsIgnoreCase(value) && !SqlUtils.isCharType(tableInfo.getColumnTypeName(logicPosition))) {
                value = null;
            }
            if (value != null) {
                condition.append("=");
                if (isUseUnhex && SqlUtils.isBinaryType(tableInfo.getColumnTypeName(logicPosition))) {
                    condition.append("unhex(?)");
                } else {
                    condition.append("?");
                }
                values.add(value);
            } else {
                condition.append(" IS NULL");
            }
            if (!iter.hasNext()) continue;
            condition.append(" AND ");
        }
        return condition.append(")");
    }

    public static Record parseStatement(Record record, TableInfo tableInfo) {
        String dbType = CACHE.get((Object)tableInfo.getServer());
        SQLStatement statement = SQLUtils.parseSingleStatement((String)record.getOriginContent(), (String)dbType, (SQLParserFeature[])new SQLParserFeature[0]);
        if (statement instanceof SQLInsertStatement) {
            SQLInsertStatement insert = (SQLInsertStatement)statement;
            record.setValues(insert.getValues().getValues().stream().map(e -> SqlUtils.extractValue(tableInfo, e)).collect(Collectors.toList()));
            return record;
        }
        throw new UnsupportedOperationException("Unknown statement: " + statement.getClass());
    }

    private static String extractValue(TableInfo tableInfo, SQLExpr expr) {
        if (expr instanceof SQLCharExpr) {
            return String.valueOf(((SQLCharExpr)expr).getValue());
        }
        if (expr instanceof SQLNullExpr) {
            return null;
        }
        if (expr instanceof SQLMethodInvokeExpr) {
            StringBuilder sb = new StringBuilder(1024);
            String methodName = ((SQLMethodInvokeExpr)expr).getMethodName();
            List arguments = ((SQLMethodInvokeExpr)expr).getArguments();
            boolean needMethodName = false;
            Iterator iter = arguments.iterator();
            while (iter.hasNext()) {
                if (!tableInfo.isIgnoreUnhex() && ("unhex".equalsIgnoreCase(methodName) || "HEXTORAW".equalsIgnoreCase(methodName))) {
                    sb.append(SqlUtils.extractValue(tableInfo, (SQLExpr)iter.next()));
                } else {
                    if ("to_date".equalsIgnoreCase(methodName) || "to_timestamp".equalsIgnoreCase(methodName) || "to_timestamp_tz".equalsIgnoreCase(methodName)) {
                        sb.append(SqlUtils.extractValue(tableInfo, (SQLExpr)iter.next()));
                        break;
                    }
                    sb.append("'").append(SqlUtils.extractValue(tableInfo, (SQLExpr)iter.next())).append("'");
                    needMethodName = true;
                }
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            if (!needMethodName) {
                return sb.toString();
            }
            return methodName + "(" + sb + ")";
        }
        return String.valueOf(((SQLValuableExpr)expr).getValue());
    }

    public static String convertUnit(double size) {
        int unitIndex = 0;
        while (size > 1024.0) {
            size /= 1024.0;
            ++unitIndex;
        }
        return new BigDecimal(size).setScale(2, RoundingMode.HALF_UP).doubleValue() + STORAGE_CAPACITY_UNIT[unitIndex];
    }

    public static boolean isCharType(String dataType) {
        Preconditions.checkArgument((dataType != null ? 1 : 0) != 0, (Object)"The data type is null");
        return CHAR_TYPES.contains(dataType);
    }

    public static boolean isBinaryType(String dataType) {
        Preconditions.checkArgument((dataType != null ? 1 : 0) != 0, (Object)"The data type is null");
        return BINARY_TYPES.contains(dataType);
    }

    public static boolean isAlmostTheSame(String duplicate, String constraint) {
        String[] constraints;
        if (duplicate == null || constraint == null) {
            return false;
        }
        String[] duplicates = duplicate.split("-");
        if (duplicates.length != (constraints = constraint.split("-")).length) {
            return false;
        }
        for (int i = 0; i < duplicates.length; ++i) {
            String duplic = duplicates[i];
            String constr = constraints[i];
            if (i > 1 && duplic.matches(SUB_TIME_REGEX)) {
                String timeStr1 = duplicates[i - 2] + "-" + duplicates[i - 1] + "-" + duplic;
                String timeStr2 = constraints[i - 2] + "-" + constraints[i - 1] + "-" + constr;
                String format = constr.contains(":") ? Constants.DEFAULT_TIMESTAMP_PATTERN : Constants.DEFAULT_MYSQL_DATE_PATTERN;
                try {
                    Timestamp timestamp1 = Timestamp.valueOf(timeStr1);
                    Timestamp timestamp2 = new Timestamp(new SimpleDateFormat(format).parse(timeStr2).getTime());
                    if (timestamp1.equals(timestamp2)) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (duplic.matches(FLOAT_REGEX)) {
                duplic = NumberUtils.trimTailZero(duplic);
            }
            if (constr.matches(FLOAT_REGEX)) {
                constr = NumberUtils.trimTailZero(constr);
            }
            if (StringUtils.equals(duplic, constr)) continue;
            return false;
        }
        return true;
    }

    static {
        CACHE.put(ServerMode.MYSQL, "mysql");
        CACHE.put(ServerMode.ORACLE, "oracle");
        CHAR_TYPES.add("char");
        CHAR_TYPES.add("nchar");
        CHAR_TYPES.add("varchar");
        CHAR_TYPES.add("nvarchar");
        CHAR_TYPES.add("varchar2");
        CHAR_TYPES.add("tinytext");
        CHAR_TYPES.add("text");
        CHAR_TYPES.add("mediumtext");
        CHAR_TYPES.add("longtext");
        CHAR_TYPES.add("enum");
        BINARY_TYPES.add("bit");
        BINARY_TYPES.add("raw");
        BINARY_TYPES.add("long raw");
        BINARY_TYPES.add("binary");
        BINARY_TYPES.add("varbinary");
        BINARY_TYPES.add("longvarbinary");
        BINARY_TYPES.add("tinyblob");
        BINARY_TYPES.add("blob");
        BINARY_TYPES.add("mediumblob");
        BINARY_TYPES.add("longblob");
    }
}

