/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.remote;

import com.oceanbase.tools.loaddump.common.enums.UploadBehavior;
import com.oceanbase.tools.loaddump.writer.file.AbstractFileWriter;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteWriter
extends AbstractRollingFileWriter {
    private static final Logger log = LoggerFactory.getLogger(AbstractRemoteWriter.class);
    protected UploadBehavior uploadBehavior;
    protected AbstractFileWriter localFileWriter;

    public AbstractRemoteWriter(int groupNo, String filePath, String fileName, String fileSuffix) {
        this(groupNo, filePath, fileName, fileSuffix, UploadBehavior.WRITE_APPEND);
    }

    public AbstractRemoteWriter(int groupNo, String filePath, String fileName, String fileSuffix, UploadBehavior uploadBehavior) {
        super(groupNo, filePath, fileName, fileSuffix);
        this.uploadBehavior = uploadBehavior;
        this.localFileWriter = this.createLocalFileWriter();
    }

    @Override
    public long write(Object line) throws Exception {
        if (this.uploadBehavior == UploadBehavior.WRITE_APPEND) {
            return this.writeAppend(line);
        }
        if (this.uploadBehavior == UploadBehavior.FAST) {
            return this.writeThenUpload(line);
        }
        throw new UnsupportedOperationException("Unsupported upload behavior: \"" + (Object)((Object)this.uploadBehavior) + "\".");
    }

    private AbstractFileWriter createLocalFileWriter() {
        return null;
    }

    public abstract long writeAppend(Object var1) throws Exception;

    public abstract long writeThenUpload(Object var1) throws Exception;
}

