/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.remote;

import com.amazonaws.services.s3.transfer.TransferManager;
import com.oceanbase.tools.loaddump.common.enums.UploadBehavior;
import com.oceanbase.tools.loaddump.writer.remote.AbstractRemoteWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Writer
extends AbstractRemoteWriter {
    private static final Logger log = LoggerFactory.getLogger(S3Writer.class);
    private final TransferManager transferManager;

    public S3Writer(int groupNo, String filePath, String fileName, String fileSuffix, UploadBehavior uploadBehavior, TransferManager transferManager) {
        super(groupNo, filePath, fileName, fileSuffix, uploadBehavior);
        this.transferManager = transferManager;
    }

    @Override
    public long writeAppend(Object line) throws Exception {
        throw new UnsupportedOperationException("S3 is not support write append. Please use --upload-behavior=FAST");
    }

    @Override
    public long writeThenUpload(Object line) throws Exception {
        long writtenBytes = this.localFileWriter.write(line);
        if (writtenBytes > Integer.MAX_VALUE) {
            this.localFileWriter = this.rollover();
        }
        return writtenBytes;
    }

    @Override
    public void attemptCloseResource() {
    }

    @Override
    public S3Writer current() throws Exception {
        return this;
    }

    @Override
    public S3Writer current(int bufferSize) throws Exception {
        return this;
    }
}

