/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.client;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.AdvancedOption;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.Database;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.Manifest;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.dumper.record.RecordFileDumper;
import com.oceanbase.tools.loaddump.dumper.schema.SchemaFileDumper;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import com.oceanbase.tools.loaddump.utils.SerializeUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.logging.log4j.ThreadContext;

public class DumpClient
implements Closeable {
    protected State state;
    protected final DumpParameter parameter;
    protected boolean closed;
    protected ConnectionKey connectionKey;

    protected DumpClient(DumpParameter parameter) {
        this.parameter = parameter;
        ThreadContext.put((String)"task.workspace", (String)parameter.getLogsPath());
    }

    public TaskContext dumpSchema() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"Not initialized");
        Preconditions.checkArgument((boolean)this.parameter.isIncludeDdl(), (Object)"Option [--ddl] is missing");
        return new SchemaFileDumper(this.parameter).prepare().dumpSchemaAsync();
    }

    public TaskContext dumpRecord() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"Not initialized");
        Preconditions.checkArgument((this.parameter.getDataFormat() != null ? 1 : 0) != 0, (String)"Option %s is missing", (Object)DataFormat.appendRecordOption());
        return new RecordFileDumper(this.parameter).prepare().dumpRecordAsync();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.connectionKey != null) {
            this.connectionKey.getSessionManager().destroy();
        }
        this.closed = true;
    }

    public static class Builder {
        private final DumpParameter parameter;

        public Builder(DumpParameter parameter) {
            this.parameter = parameter;
        }

        public DumpClient build() throws Exception {
            DumpClient target = new DumpClient(this.parameter);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank(this.parameter.getRootPath()), (Object)"The root path is null");
            target.connectionKey = this.parameter.buildConnectionKey();
            ServerMode serverMode = target.connectionKey.getServerMode();
            Set tableSet = this.parameter.getWhiteListMap().getOrDefault((Object)ObjectType.TABLE, new HashSet());
            if (StringUtils.isNotBlank(this.parameter.getCtlPath()) && CollectionUtils.isNotEmpty((Collection)tableSet)) {
                ControlManager cm = ControlManager.parse(new File(this.parameter.getCtlPath()), this.parameter.getDatabaseName(), tableSet, serverMode);
                this.parameter.setControlManager(cm);
                if (MapUtils.isEmpty(this.parameter.getColumnNameMapping())) {
                    this.parameter.getColumnNameMapping().putAll(cm.getColumnNameMapping());
                }
            }
            if (this.parameter.isSnapshot() && serverMode.isPreviousV4() && target.connectionKey.hasNoSysPrivileges()) {
                throw new IllegalArgumentException("Option --snapshot required sys privilege when the OceanBase < 4.0.0.0");
            }
            if (this.parameter.isEnableHiddenPk() && serverMode.isPreviousV4()) {
                if (serverMode.isMysqlMode() && !target.connectionKey.getUsername().equals("__oceanbase_inner_drc_user")) {
                    throw new IllegalArgumentException("The user with option --enable-hidden-pk must be \"__oceanbase_inner_drc_user\"");
                }
                if (serverMode.isOracleMode() && !target.connectionKey.getUsername().equals("__OCEANBASE_INNER_DRC_USER")) {
                    throw new IllegalArgumentException("The user with option --enable-hidden-pk must be \"__OCEANBASE_INNER_DRC_USER\"");
                }
            }
            if (this.parameter.getDataFormat() == DataFormat.CSV) {
                Manifest manifest = new Manifest(this.parameter);
                try {
                    SerializeUtils.serializeObjectByKryo(manifest, manifest.toPath());
                }
                catch (Exception e) {
                    LogUtils.info("Serialization of \".MANIFEST.bin\" failed. This does not impact data integrity.\n-\tNote: \".MANIFEST.bin\" is a binary file that specifies the current CSV format, in most cases, it's not necessary and okay to be ignored.");
                }
            }
            AdvancedOption advancedOption = new AdvancedOption(this.parameter, target.connectionKey.getServerMode());
            Database database = target.connectionKey.getMetadataProvider().queryDatabase(target.connectionKey, advancedOption);
            this.parameter.setDatabase(database);
            this.parameter.setDatabaseName(database.getSchemaName());
            if (this.parameter.isIncludeDdl()) {
                this.parameter.getWhiteListMap().putAll(advancedOption.getAllowedObjectMap());
            }
            target.state = State.INITIAL;
            return target;
        }
    }
}

