/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.cmd;

import com.alibaba.druid.filter.config.ConfigTools;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.cmd.Common;
import com.oceanbase.tools.loaddump.cmd.Connection;
import com.oceanbase.tools.loaddump.cmd.ObjectTypes;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.model.BaseParameter;
import com.oceanbase.tools.loaddump.common.model.RuntimeMetrics;
import com.oceanbase.tools.loaddump.common.model.SessionConfig;
import com.oceanbase.tools.loaddump.common.model.StorageUri;
import com.oceanbase.tools.loaddump.common.model.Version;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.decrypt.DecryptTools;
import com.oceanbase.tools.loaddump.decrypt.SecureContent;
import com.oceanbase.tools.loaddump.factory.StorageConfigFactory;
import com.oceanbase.tools.loaddump.utils.CodecUtils;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.JacksonUtils;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import com.oceanbase.tools.loaddump.utils.ProgressLogger;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.utils.TimeUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public abstract class AbstractCommandParser {
    private static final Logger log = LoggerFactory.getLogger(AbstractCommandParser.class);
    public static final List<String> STARS_WILDCARD = Lists.newArrayList((Object[])new String[]{"*", "\\*"});
    private static final Set<String> SECURITY_SENSITIVE_ARGS = Sets.newHashSet((Object[])new String[]{"--password", "--sys-password"});
    @CommandLine.ArgGroup(validate=false, heading="%nCommon options:%n")
    protected Common common;
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    protected abstract BaseParameter parseCommandArgs() throws Exception;

    protected void parseCommonArgs(BaseParameter parameter) throws Exception {
        List columnNames;
        Common.Base base = this.common.getBase();
        this.assertParamConflict(base);
        String filePath = base.getFilePath();
        parameter.setFilePath(filePath);
        this.parseDataConfig(base, parameter);
        SecureContent secureContent = DecryptTools.decrypt();
        this.parseJdbcConfig(base, parameter, secureContent);
        this.parseSessionConfig(base, parameter);
        String storageUri = base.getStorageUri();
        if (StringUtils.isNotBlank(storageUri)) {
            parameter.setStorageConfig(StorageConfigFactory.createStorageConfig(storageUri, secureContent));
        }
        parameter.setRetry(base.isRetry());
        parameter.setLogPath(base.getLogPath());
        parameter.setCtlPath(base.getCtlPath());
        parameter.setEnableHiddenPk(base.isEnableHiddenPk());
        parameter.setThreads(Math.max(1, base.getThread()));
        parameter.setParallel(base.getParallel());
        if (base.getExcludeDataTypes() != null) {
            List dataTypes = base.getExcludeDataTypes().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(dataTypes), (Object)"Cli args of --exclude-data-types is required");
            parameter.getExcludeDataTypes().addAll(dataTypes);
        }
        if (base.getExcludeColumnNames() != null) {
            columnNames = base.getExcludeColumnNames().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columnNames), (Object)"Cli args of --exclude-column-names is required");
            parameter.getExcludeColumnNames().addAll(columnNames);
        }
        if (base.getIncludeColumnNames() != null) {
            columnNames = base.getIncludeColumnNames().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columnNames), (Object)"Cli args of --include-column-names is required");
            parameter.getIncludeColumnNames().addAll(columnNames);
        }
    }

    protected Map<String, String> buildTableMapping() {
        ObjectTypes objectTypes = this.common.getObjectTypes();
        Preconditions.checkArgument((objectTypes != null && CollectionUtils.isNotEmpty(objectTypes.getTables()) ? 1 : 0) != 0, (Object)"--table is missing");
        List<String> sourceTables = JvmArgs.getSourceTables();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(sourceTables), (Object)"Please check vm args -DsourceTable is missing");
        List targetTables = objectTypes.getTables().stream().map(t -> DBUtils.extractObjectName(t, null)).collect(Collectors.toList());
        Preconditions.checkArgument((targetTables.size() == sourceTables.size() ? 1 : 0) != 0, (Object)"Args of --table and -DsourceTable is not match");
        return Stream.iterate(0, t -> t + 1).limit(sourceTables.size()).collect(Collectors.toMap(sourceTables::get, targetTables::get));
    }

    protected void printParseArgs() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("Parsed args:\n");
        List options = this.spec.options();
        for (CommandLine.Model.OptionSpec opt : options) {
            try {
                if (opt.getter() == null || opt.getValue() == null || opt.initialValue() != null && (opt.initialValue() == null || opt.getValue().equals(opt.initialValue()))) continue;
                String arg = opt.longestName();
                sb.append("[").append(arg).append("] ");
                if (SECURITY_SENSITIVE_ARGS.contains(arg)) {
                    sb.append("******\n");
                    continue;
                }
                if ("--storage-uri".equals(arg)) {
                    sb.append(StorageUri.maskSensitiveParams(opt.getValue().toString())).append("\n");
                    continue;
                }
                sb.append(opt.getValue().toString()).append("\n");
            }
            catch (Exception exception) {}
        }
        LogUtils.info(sb.toString());
    }

    protected void doFinally(RuntimeMetrics metrics, int status) {
        if (JvmArgs.isBackupRestoreMode && metrics != null) {
            metrics.setStatus(status == 0 ? "SUCCESS" : "FAILURE");
            metrics.setProgress(100.0);
            String result = "{\"endTimestamp\":\"" + System.currentTimeMillis() + "\"}";
            metrics.setResult(result);
            ProgressLogger.info(JacksonUtils.toJsonString(metrics), new Object[0]);
        }
        if (!JvmArgs.isDebugable) {
            if (status == 0) {
                if (JvmArgs.isMultiTask) {
                    log.info("System exit {}", (Object)status);
                } else {
                    LogUtils.info("System exit {}", status);
                }
            } else if (JvmArgs.isMultiTask) {
                log.error("System exit {}", (Object)status);
            } else {
                LogUtils.error("System exit {}", status);
            }
            System.exit(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long waitUntilDone(@NonNull TaskContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        long status = 0L;
        long count = 1L;
        while (!context.isAllTasksFinished()) {
            this.logProgress(context, count);
            ++count;
            TimeUtils.sleep(TimeUnit.MILLISECONDS, 1000L);
        }
        try {
            context.shutdown();
            log.debug("Shutdown task context finished");
        }
        catch (Exception e) {
            try {
                context.shutdownNow();
                log.info("Shutdown task context immediately finished");
            }
            catch (Exception ex) {
                log.error("Shutdown task context immediately failed", (Throwable)ex);
            }
        }
        finally {
            if (!context.isAllTasksSuccessed()) {
                context.getFailureTaskDetails().forEach(t -> log.error("Error: {}", (Object)t.getError()));
                status = 1L;
            }
            log.info(context.getProgress().toString());
            log.info(context.getSummary().toHumanReadableFormat());
        }
        return status;
    }

    protected void logProgress(TaskContext context, long counter) {
        if (counter % 5L == 0L) {
            RuntimeMetrics metrics = context.getRuntimeMetrics();
            metrics.setStatus("RUNNING");
            ProgressLogger.info(JacksonUtils.toJsonString(metrics), new Object[0]);
        }
        if (counter % 30L == 0L) {
            log.info(context.getProgress().toString());
            context.getServerStatus().log();
        }
    }

    protected String parseSpecialChar(@NonNull String character) throws Exception {
        if (character == null) {
            throw new NullPointerException("character is marked non-null but is null");
        }
        String trimmedChar = character.trim().toLowerCase();
        if (trimmedChar.startsWith("0x") && trimmedChar.length() % 4 == 0) {
            return CodecUtils.decodeHex(trimmedChar.split("0x"));
        }
        if (trimmedChar.startsWith("x") && trimmedChar.length() % 3 == 0) {
            return CodecUtils.decodeHex(trimmedChar.split("x"));
        }
        return character;
    }

    protected Map<ObjectType, Set<String>> parseAllowedObjects(ObjectTypes objects) {
        HashMap<ObjectType, Set<String>> allowedObjectMap = new HashMap<ObjectType, Set<String>>(16);
        this.parseObjectNames(allowedObjectMap, ObjectType.TABLE, objects.getTables(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.TABLE_GROUP, objects.getTableGroups(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.VIEW, objects.getViews(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.TRIGGER, objects.getTriggers(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.SEQUENCE, objects.getSequences(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.SYNONYM, objects.getSynonyms(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.PUBLIC_SYNONYM, objects.getPublicSynonyms(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.FUNCTION, objects.getFunctions(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.PROCEDURE, objects.getProcedures(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.TYPE, objects.getTypes(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.TYPE_BODY, objects.getTypeBodies(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.PACKAGE, objects.getPackages(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.PACKAGE_BODY, objects.getPackageBodies(), objects.isAll());
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(allowedObjectMap), (Object)"Cli args of --table,--view or other options are required");
        return allowedObjectMap;
    }

    protected Map<ObjectType, Set<String>> parseDisallowedObjects(ObjectTypes objects) {
        HashMap<ObjectType, Set<String>> disallowedObjectMap = new HashMap<ObjectType, Set<String>>(16);
        this.parseObjectNames(disallowedObjectMap, ObjectType.TABLE, objects.getExcludeTables(), false);
        return disallowedObjectMap;
    }

    protected void parseObjectNames(Map<ObjectType, Set<String>> objectMap, ObjectType objectType, List<String> objectNames, boolean withAll) {
        List<Object> list = objectNames = objectNames == null ? Lists.newArrayList() : objectNames;
        if (withAll || objectNames.size() == 1 && STARS_WILDCARD.contains(objectNames.get(0))) {
            if (!withAll) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)objectNames.get(0)), (String)"Invalid object names: \"%s\"", (Object)objectNames.get(0));
            }
            objectMap.computeIfAbsent(objectType, v -> new HashSet()).addAll(Sets.newHashSet());
        } else {
            Set specifiedObjects = objectNames.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(specifiedObjects)) {
                objectMap.computeIfAbsent(objectType, v -> new HashSet()).addAll(specifiedObjects);
            }
        }
    }

    private void parseDataConfig(Common.Base base, BaseParameter parameter) throws Exception {
        if (base.isSql()) {
            parameter.setDataFormat(DataFormat.SQL);
        } else if (base.isCsv()) {
            parameter.setDataFormat(DataFormat.CSV);
            String colSep = this.parseSpecialChar(base.getColumnSeparator());
            Preconditions.checkArgument((colSep.length() == 1 ? 1 : 0) != 0, (Object)"Option --column-separator only accept a single character");
            parameter.setColumnSeparator(Character.valueOf(colSep.charAt(0)));
            String colDel = this.parseSpecialChar(base.getColumnDelimiter());
            Preconditions.checkArgument((colDel.length() == 1 ? 1 : 0) != 0, (Object)"Option --column-delimiter only accept a single character");
            parameter.setColumnDelimiter(Character.valueOf(colDel.charAt(0)));
        } else if (base.isCut()) {
            parameter.setNullString(null);
            parameter.setDataFormat(DataFormat.CUT);
            parameter.setColumnSplitter(this.parseSpecialChar(base.getColumnSplitter()));
        } else if (base.isOrc()) {
            parameter.setDataFormat(DataFormat.ORC);
        } else if (base.isPar()) {
            parameter.setDataFormat(DataFormat.PAR);
        } else if (base.isPos()) {
            parameter.setDataFormat(DataFormat.POS);
        }
        Preconditions.checkArgument((parameter.getDataFormat() != null || base.isDdl() ? 1 : 0) != 0, (Object)"Data format not specified. You may use one of the following options [--sql, --csv, --cut, --orc, --par, --pos] for data export. Use --ddl for schema export.\n-\tNote: The --ddl option can be combined with any of the data format options if you wish to export both schema (DDL) and data.");
        parameter.setIncludeDdl(base.isDdl());
        parameter.setFileEncoding(base.getFileEncoding());
        parameter.setSkipHeader(base.isSkipHeader());
        parameter.setNullString(base.getNullString());
        parameter.setEmptyString(base.getEmptyString());
        parameter.setTrailingDelimiter(base.isTrailDelimiter());
        parameter.setLineSeparator(this.parseSpecialChar(base.getLineSeparator()));
        parameter.setWithTrim(base.isWithTrim());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(base.getEscapeCharacter()), (Object)"Option --escape-character cannot be empty or blank");
        String escapeStr = this.parseSpecialChar(base.getEscapeCharacter());
        if (escapeStr.length() != 1) {
            throw new IllegalArgumentException("Option --escape-character only accept a single character");
        }
        char escapeChar = escapeStr.charAt(0);
        parameter.setEscapeCharacter(Character.isWhitespace(escapeChar) ? null : Character.valueOf(escapeChar));
    }

    private void parseJdbcConfig(Common.Base base, BaseParameter parameter, SecureContent secureContent) throws Exception {
        Connection conn = this.common.getConnection();
        String user = conn.getUser();
        String host = conn.getHost();
        String port = conn.getPort();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(host), (Object)"Option -h/--host is required");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(port), (Object)"Option -P/--port is required");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(user), (Object)"Option -u/--user is required");
        parameter.setHost(host);
        parameter.setPort(port);
        String[] userComponent = user.split("[@#]");
        Preconditions.checkArgument((userComponent.length > 0 && userComponent.length <= 3 ? 1 : 0) != 0, (Object)"Invalid format for -u/--user. A valid input should be `user`, `user@tenant` or `user@tenant#cluster`");
        parameter.setUser(DBUtils.extractObjectName(userComponent[0], null));
        if (conn.getTenant() != null) {
            parameter.setTenant(conn.getTenant());
        } else {
            parameter.setTenant(userComponent.length > 1 ? userComponent[1] : null);
        }
        if (conn.getCluster() != null) {
            parameter.setCluster(conn.getCluster());
        } else {
            parameter.setCluster(userComponent.length > 2 ? userComponent[2] : null);
        }
        if (StringUtils.isBlank(conn.getPassword())) {
            parameter.setPassword(secureContent.getPassword());
        } else {
            parameter.setPassword(conn.getPassword());
        }
        String databaseName = conn.getDatabase();
        databaseName = StringUtils.isBlank(databaseName) ? user : databaseName;
        parameter.setDatabaseName(DBUtils.extractObjectName(databaseName, null));
        parameter.setConnectDatabaseName(DBUtils.extractObjectName(databaseName, null));
        parameter.setSysUser(conn.getSysUser());
        if (StringUtils.isBlank(conn.getSysPassword())) {
            String secureFile = System.getProperty("obproxy.configurationFile");
            if (StringUtils.isBlank(secureFile) || !FileUtils.exists(secureFile)) {
                parameter.setSysPassword(secureContent.getSysPassword());
            } else {
                AbstractCommandParser.decryptBySecureFile(secureFile, parameter);
            }
        } else {
            parameter.setSysPassword(conn.getSysPassword());
        }
        parameter.setLogicalDatabase(base.isLogicalDatabase());
        parameter.setNoSys(parameter.isLogicalDatabase() || base.isNoSys());
        parameter.setPubCloud(parameter.isLogicalDatabase() || base.isPublicCloud());
        parameter.setUseServer(base.isUseServer());
    }

    public void parseSessionConfig(Common.Base base, BaseParameter parameter) {
        String configFilePath = System.getProperty("session.configurationFile");
        if (StringUtils.isNotBlank(base.getSessionConfig())) {
            configFilePath = base.getSessionConfig();
        }
        if (StringUtils.isBlank(configFilePath)) {
            log.warn("No available session configuration file was specified");
            parameter.setSessionConfig(new SessionConfig());
            return;
        }
        if (configFilePath.startsWith("file://")) {
            configFilePath = configFilePath.substring("file://".length());
        }
        parameter.setSessionConfig(SessionConfig.fromJson(new File(configFilePath)));
        SessionConfig config = parameter.getSessionConfig();
        if (StringUtils.isNotBlank(base.getNlsDateFormat())) {
            config.addInitSql4Oracle("alter session set nls_date_format='" + base.getNlsDateFormat() + "'");
        }
        if (StringUtils.isNotBlank(base.getNlsTimestampFormat())) {
            config.addInitSql4Oracle("alter session set nls_timestamp_format='" + base.getNlsTimestampFormat() + "'");
        }
        if (StringUtils.isNotBlank(base.getNlsTimestampTzFormat())) {
            config.addInitSql4Oracle("alter session set nls_timestamp_tz_format='" + base.getNlsTimestampTzFormat() + "'");
        }
        if (StringUtils.isNotBlank(base.getCharacterSet())) {
            config.setJdbcOption("characterEncoding", base.getCharacterSet());
        }
    }

    private static void decryptBySecureFile(String secureFile, BaseParameter parameter) throws Exception {
        List lines;
        String security;
        if ((secureFile = secureFile.trim()).startsWith("file://")) {
            secureFile = secureFile.substring("file://".length());
        }
        if (StringUtils.isNotEmpty(security = String.join((CharSequence)"\n", lines = IOUtils.readLines((Reader)new FileReader(secureFile))))) {
            String[] array = security.split(" ");
            if (array.length < 3) {
                LogUtils.error("The security certificate file: \"{}\" has been corrupted", secureFile);
                return;
            }
            parameter.setSysUser("proxyro");
            parameter.setSysPassword(ConfigTools.decrypt((String)array[1], (String)array[2]));
        }
        LogUtils.info("The security certificate file: \"{}\" has been parsed", secureFile);
    }

    protected void assertParamConflict(Common.Base base) {
        boolean hasWhiteList = CollectionUtils.isNotEmpty(base.getIncludeColumnNames());
        boolean hasBlackList = CollectionUtils.isNotEmpty(base.getExcludeColumnNames()) || CollectionUtils.isNotEmpty(base.getExcludeDataTypes());
        boolean hasControlFile = StringUtils.isNotBlank(base.getCtlPath());
        Preconditions.checkArgument((!hasControlFile || !hasWhiteList && !hasBlackList ? 1 : 0) != 0, (Object)"Using both the control file and white/black list options is not allowed.");
        Preconditions.checkArgument((!hasWhiteList || !hasBlackList ? 1 : 0) != 0, (Object)"Using both the white list and black list options is not allowed.");
    }

    protected static void checkJavaVersion() {
        Version lowerBound = new Version("1.8.0_300");
        Version upperBound = new Version("9");
        Version javaVersion = new Version(System.getProperty("java.version"));
        if (javaVersion.isNewerThan(upperBound) || javaVersion.isOlderThan(lowerBound)) {
            LogUtils.warn("The Java version ({}) you are currently using is not recommended. Recommended range: [1.8.0_300, 9.0.0)", javaVersion);
        }
    }
}

