/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.enums;

import com.oceanbase.obtools.dbdiff.enums.DbType;
import lombok.NonNull;

public enum CompatMode {
    MYSQL56("mysql56", DbType.MYSQL_56),
    MYSQL57("mysql57", DbType.MYSQL_57),
    MYSQL80("mysql80", DbType.MYSQL_80);

    final String name;
    final DbType dbType;

    private CompatMode(String name, DbType dbType) {
        this.name = name;
        this.dbType = dbType;
    }

    @NonNull
    public static CompatMode of(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        for (CompatMode mode : CompatMode.values()) {
            if (!mode.name.equalsIgnoreCase(name)) continue;
            return mode;
        }
        throw new IllegalArgumentException("Unknown compat mode: " + name + ". Available options: mysql56, mysql57 and mysql80");
    }

    public String getName() {
        return this.name;
    }

    public DbType getDbType() {
        return this.dbType;
    }
}

