/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.enums;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.exception.UnknownServerModeException;
import com.oceanbase.tools.loaddump.common.model.Version;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public enum ServerMode {
    MYSQL(new String[]{"char", "varchar", "tinytext", "text", "mediumtext", "longtext", "json"}, new String[]{"bit", "char", "varchar", "tinyblob", "tinytext", "blob", "text", "mediumblob", "mediumtext", "longblob", "longtext", "date", "time", "year", "datetime", "timestamp", "enum", "set", "binary", "varbinary", "longvarbinary", "json"}),
    ORACLE(new String[]{"char", "nchar", "varchar", "varchar2", "nvarchar2", "nclob", "clob"}, new String[]{"char", "nchar", "varchar", "varchar2", "nvarchar2", "nclob", "clob", "date", "timestamp", "timestamp with time zone", "timestamp with local time zone", "raw", "long raw", "blob", "interval day to second", "interval year to month", "intervalym", "intervalds"});

    private final Set<String> typesNeedEscape = new HashSet<String>();
    private final Set<String> typesNeedQuote = new HashSet<String>();
    private String version;

    private ServerMode(String[] typesNeedEscape, String[] typesNeedQuote) {
        this.typesNeedEscape.addAll(Arrays.asList(typesNeedEscape));
        this.typesNeedQuote.addAll(Arrays.asList(typesNeedQuote));
    }

    public static ServerMode of(String mode) {
        if (MYSQL.name().equalsIgnoreCase(mode)) {
            return MYSQL;
        }
        if (ORACLE.name().equalsIgnoreCase(mode)) {
            return ORACLE;
        }
        throw new UnknownServerModeException("Unknown server mode: " + mode);
    }

    public boolean isNeedEscape(String type) {
        return this.typesNeedEscape.contains(type);
    }

    public boolean isNeedQuote(String type) {
        return this.typesNeedQuote.contains(type);
    }

    public boolean isPrevious(String version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(version), (Object)"The version is null");
        return new Version(this.getVersion()).isOlderThan(new Version(version));
    }

    public boolean isSubsequent(String version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(version), (Object)"The version is null");
        return new Version(this.getVersion()).isNewerThan(new Version(version)) || new Version(this.getVersion()).equals(new Version(version));
    }

    public boolean isOracleMode() {
        return ORACLE.name().equalsIgnoreCase(this.name());
    }

    public boolean isMysqlMode() {
        return MYSQL.name().equalsIgnoreCase(this.name());
    }

    public boolean isPreviousV2() {
        return this.isPrevious("2.0.0.0");
    }

    public boolean isPreviousV2270() {
        return this.isPrevious("2.2.70");
    }

    public boolean isPreviousV2250() {
        return this.isPrevious("2.2.50");
    }

    public boolean isPreviousV3230() {
        return this.isPrevious("3.2.3.0");
    }

    public boolean isPreviousV4() {
        return this.isPrevious("4.0.0.0");
    }

    public String wrapName(String objectName) {
        if (this.isMysqlMode()) {
            return "`" + objectName + "`";
        }
        if (this.isOracleMode()) {
            return "\"" + objectName.replace("\"", "\"\"") + "\"";
        }
        throw new IllegalArgumentException("Unsupported server mode: " + this.name());
    }

    public String toCaseSensitiveName(String objectName) {
        if (this.isMysqlMode()) {
            return objectName.toLowerCase(Locale.getDefault());
        }
        if (this.isOracleMode()) {
            return objectName.toUpperCase(Locale.getDefault());
        }
        throw new IllegalArgumentException("Unsupported server mode: " + this.name());
    }

    public String toString() {
        return this.isMysqlMode() ? "OBMYSQL-" + this.version : "OBORACLE-" + this.version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

