/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.metadata;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.LoadStatus;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.metadata.AbstractMetadataProvider;
import com.oceanbase.tools.loaddump.jdbc.JdbcExecutor;
import com.oceanbase.tools.loaddump.manager.SessionManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataProviderV4
extends AbstractMetadataProvider {
    private static final Logger log = LoggerFactory.getLogger(MetadataProviderV4.class);
    static final String SERVER_STATUS_QUERY_ORACLE = "select distinct m.svr_ip,l.sql_port,m.memstore_used/m.memstore_limit,d.status,d.is_suspended from SYS.GV$OB_MEMSTORE m,SYS.DBA_OB_MAJOR_COMPACTION d,SYS.DBA_OB_LS_LOCATIONS l where m.svr_ip=l.svr_ip and m.svr_port=l.svr_port";
    static final String SERVER_STATUS_QUERY_MYSQL = "select distinct m.svr_ip,l.sql_port,m.memstore_used / m.memstore_limit,d.status,d.is_suspended from oceanbase.GV$OB_MEMSTORE m,oceanbase.DBA_OB_MAJOR_COMPACTION d,oceanbase.DBA_OB_LS_LOCATIONS l where m.svr_ip=l.svr_ip and m.svr_port=l.svr_port";
    static final String GET_FROZEN_TIME_ORACLE = "select START_TIME as frozen_time from SYS.DBA_OB_MAJOR_COMPACTION";
    static final String GET_FROZEN_TIME_MYSQL = "select START_TIME as frozen_time from oceanbase.DBA_OB_MAJOR_COMPACTION";
    static final String GET_FROZEN_VERSION_ORACLE = "select FROZEN_SCN as frozen_version from SYS.DBA_OB_MAJOR_COMPACTION";
    static final String GET_FROZEN_VERSION_MYSQL = "select FROZEN_SCN as frozen_version from oceanbase.DBA_OB_MAJOR_COMPACTION";
    static final String GET_DATABASE_CREATE_TIME_MYSQL = "select gmt_create as create_time from oceanbase.__all_database where database_name=?";
    static final String GET_DATABASE_CREATE_TIME_ORACLE = "select CREATED as create_time from SYS.ALL_USERS where USERNAME=?";
    static final String GET_LATEST_MERGED_VERSION_SQL_ORACLE = "select LAST_SCN from SYS.DBA_OB_MAJOR_COMPACTION";
    static final String GET_LATEST_MERGED_VERSION_SQL_MYSQL = "select LAST_SCN from oceanbase.DBA_OB_MAJOR_COMPACTION";
    static final String GET_LATEST_MERGED_TIME_SQL_MYSQL = "select LAST_FINISH_TIME from oceanbase.DBA_OB_MAJOR_COMPACTION";
    static final String GET_LATEST_MERGED_TIME_SQL_ORACLE = "select LAST_FINISH_TIME from SYS.DBA_OB_MAJOR_COMPACTION";
    static final String GET_PRIMARY_KEY_OBMYSQL = "select s.column_name,s.SEQ_IN_INDEX-1 from information_schema.STATISTICS s,information_schema.COLUMNS c where s.table_schema=c.table_schema and s.table_name=c.table_name and s.table_schema=? and s.table_name=? and c.COLUMN_KEY='PRI' order by SEQ_IN_INDEX asc";
    static final String GET_PRIMARY_KEY_OBORACLE = "select column_name,position -1 from ALL_CONS_COLUMNS d,ALL_CONSTRAINTS c where d.owner=? and d.table_name=? and c.CONSTRAINT_TYPE='P' and d.CONSTRAINT_NAME=c.CONSTRAINT_NAME and d.owner=c.owner and d.table_name=c.table_name order by position";

    public MetadataProviderV4(SessionManager sessionManager) {
        super(sessionManager);
    }

    @Override
    public Map<String, LoadStatus> queryObserverLoad(ServerMode serverMode, String tenantName) throws Exception {
        String sql = serverMode.isOracleMode() ? SERVER_STATUS_QUERY_ORACLE : SERVER_STATUS_QUERY_MYSQL;
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            Map<String, LoadStatus> map = JdbcExecutor.queryMap(conn, sql, rs -> {
                HashMap<String, LoadStatus> loadStatusMap = new HashMap<String, LoadStatus>(16);
                while (rs.next()) {
                    String address = rs.getString(1) + ":" + rs.getString(2);
                    boolean merging = "MERGING".equals(rs.getString(4)) && "NO".equals(rs.getString(5));
                    LoadStatus loadStatus = new LoadStatus(merging, rs.getDouble(3));
                    loadStatus.setLeaderServer(address);
                    loadStatusMap.put(address, loadStatus);
                }
                return loadStatusMap;
            });
            return map;
        }
    }

    @Override
    public long queryFrozenVersion(ServerMode serverMode) throws Exception {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            String sql = serverMode.isOracleMode() ? GET_FROZEN_VERSION_ORACLE : GET_FROZEN_VERSION_MYSQL;
            long l = JdbcExecutor.query(conn, sql, rs -> rs.next() ? rs.getLong(1) : 0L);
            return l;
        }
    }

    @Override
    public long queryFrozenTime(ServerMode serverMode) throws Exception {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            String sql = serverMode.isOracleMode() ? GET_FROZEN_TIME_ORACLE : GET_FROZEN_TIME_MYSQL;
            long l = JdbcExecutor.query(conn, sql, rs -> rs.next() ? rs.getTimestamp(1).getTime() * 1000L : 0L);
            return l;
        }
    }

    @Override
    public long queryLatestMergedVersion(ServerMode serverMode) throws Exception {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            String sql = serverMode.isOracleMode() ? GET_LATEST_MERGED_VERSION_SQL_ORACLE : GET_LATEST_MERGED_VERSION_SQL_MYSQL;
            long l = JdbcExecutor.query(conn, sql, rs -> rs.next() ? rs.getLong(1) : 0L);
            return l;
        }
    }

    @Override
    public long queryLatestMergedTime(ServerMode serverMode) throws Exception {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            String sql = serverMode.isOracleMode() ? GET_LATEST_MERGED_TIME_SQL_ORACLE : GET_LATEST_MERGED_TIME_SQL_MYSQL;
            long l = JdbcExecutor.query(conn, sql, rs -> rs.next() ? rs.getLong(1) : 0L);
            return l;
        }
    }

    @Override
    public String queryDatabaseCreateTime(ServerMode serverMode, String tenantName, String schemaName) throws Exception {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            String sql = serverMode.isOracleMode() ? GET_DATABASE_CREATE_TIME_ORACLE : GET_DATABASE_CREATE_TIME_MYSQL;
            Object[] args = new Object[]{schemaName};
            String string = JdbcExecutor.query(conn, sql, args, rs -> rs.next() ? Constants.DEFAULT_DATETIME_FORMATTER.format(rs.getTimestamp(1).toLocalDateTime()) : null);
            return string;
        }
    }

    @Override
    public List<String> queryPrimaryKeyList(ServerMode serverMode, String schemaName, String tableName) throws Exception {
        if (serverMode.isOracleMode()) {
            Preconditions.checkState((this.metaCache != null ? 1 : 0) != 0, (Object)"The `metaCache` has not been initialized");
            return this.metaCache.getObOracleTablePkCache().map(m -> m.getOrDefault(tableName, new ArrayList())).orElse(new ArrayList());
        }
        log.info("Querying primary key for table \"{}\"...", (Object)tableName);
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            Object[] args = new Object[]{schemaName, tableName};
            List<String> list = JdbcExecutor.queryList(conn, GET_PRIMARY_KEY_OBMYSQL, args, rs -> {
                ArrayList<String> primaryCols = new ArrayList<String>();
                while (rs.next()) {
                    primaryCols.add(rs.getString(1));
                }
                return primaryCols;
            });
            return list;
        }
    }

    public MetadataProviderV4() {
    }
}

