/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.BaseParameter;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.MapObject;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public class AdvancedOption
implements Serializable {
    private static final long serialVersionUID = -8012869974081250550L;
    private boolean dumpOperation;
    private boolean enableHiddenPk;
    private String querySql;
    private boolean includeDdl;
    private boolean onlyDdl;
    private boolean compactSchema;
    private boolean truncatable;
    private boolean replaceData;
    private boolean excludeVirtualColumns;
    private boolean useFlashBackQuery;
    private Set<String> excludeDataTypes;
    private Set<String> excludeColumnNames;
    private Set<String> includeColumnNames;
    private boolean preserveZeroDatetime;
    private String timeValuePattern;
    private String datetimeValuePattern;
    private String timestampTzValuePattern;
    private String timestampLtzValuePattern;
    private String dateValuePattern;
    private String timestampValuePattern;
    private final boolean logicalDatabase;
    private final Map<ObjectType, Set<String>> allowedObjectMap;
    private final Map<ObjectType, Set<String>> disallowedObjectMap;
    private final Map<String, Map<String, MapObject>> columnNameMapping;

    public AdvancedOption(BaseParameter parameter, ServerMode serverMode) {
        if (parameter instanceof LoadParameter) {
            this.truncatable = ((LoadParameter)parameter).isTruncatable();
            this.replaceData = ((LoadParameter)parameter).isReplaceData();
        } else {
            this.dumpOperation = true;
            this.includeDdl = parameter.isIncludeDdl();
            this.onlyDdl = parameter.isIncludeDdl() && parameter.getDataFormat() == DataFormat.DDL;
            this.compactSchema = ((DumpParameter)parameter).isCompactSchema() || serverMode.isPreviousV4() && parameter.getConnectionKey().hasNoSysPrivileges();
            this.querySql = ((DumpParameter)parameter).getQuerySql();
            this.excludeVirtualColumns = ((DumpParameter)parameter).isExcludeVirtualColumns();
            this.useFlashBackQuery = this.isQueryHistoricalVersionData((DumpParameter)parameter);
            this.timeValuePattern = ((DumpParameter)parameter).getTimeValuePattern();
            this.dateValuePattern = ((DumpParameter)parameter).getDateValuePattern();
            this.datetimeValuePattern = ((DumpParameter)parameter).getDatetimeValuePattern();
            this.timestampValuePattern = ((DumpParameter)parameter).getTimestampValuePattern();
            this.timestampTzValuePattern = ((DumpParameter)parameter).getTimestampTzValuePattern();
            this.timestampLtzValuePattern = ((DumpParameter)parameter).getTimestampLtzValuePattern();
            this.preserveZeroDatetime = ((DumpParameter)parameter).isPreserveZeroDatetime();
        }
        this.enableHiddenPk = parameter.isEnableHiddenPk();
        this.logicalDatabase = parameter.isLogicalDatabase();
        this.allowedObjectMap = parameter.getWhiteListMap();
        this.disallowedObjectMap = parameter.getBlackListMap();
        this.columnNameMapping = parameter.getColumnNameMapping();
        if (!this.includeDdl || parameter.getDataFormat() != null) {
            this.excludeColumnNames = parameter.getExcludeColumnNames().stream().map(e -> DBUtils.extractObjectName(e, serverMode)).collect(Collectors.toSet());
            this.excludeDataTypes = parameter.getExcludeDataTypes().stream().map(e -> e.toLowerCase(Locale.getDefault())).collect(Collectors.toSet());
            this.includeColumnNames = parameter.getIncludeColumnNames().stream().map(e -> DBUtils.extractObjectName(e, serverMode)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
    }

    public boolean containObjectType(@NonNull ObjectType objectType) {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        return this.allowedObjectMap.containsKey((Object)objectType);
    }

    public boolean isShouldFilterEmptyTables() {
        return this.truncatable && !this.isDumpOperation() || !this.useFlashBackQuery && this.isDumpOperation();
    }

    public boolean isColumnNameExcluded(String columnName) {
        return CollectionUtils.isNotEmpty(this.excludeColumnNames) && this.excludeColumnNames.contains(columnName);
    }

    public boolean isDataTypeExcluded(String dataType) {
        return CollectionUtils.isNotEmpty(this.excludeDataTypes) && this.excludeDataTypes.contains(dataType);
    }

    public boolean isCustomQuery() {
        return StringUtils.isNotBlank(this.querySql);
    }

    private boolean isQueryHistoricalVersionData(DumpParameter parameter) {
        return parameter.isSnapshot() || StringUtils.isNotBlank(parameter.getFlashbackScn()) || StringUtils.isNotBlank(parameter.getFlashbackTimestamp());
    }

    public boolean isDumpOperation() {
        return this.dumpOperation;
    }

    public boolean isEnableHiddenPk() {
        return this.enableHiddenPk;
    }

    public String getQuerySql() {
        return this.querySql;
    }

    public boolean isIncludeDdl() {
        return this.includeDdl;
    }

    public boolean isOnlyDdl() {
        return this.onlyDdl;
    }

    public boolean isCompactSchema() {
        return this.compactSchema;
    }

    public boolean isReplaceData() {
        return this.replaceData;
    }

    public boolean isExcludeVirtualColumns() {
        return this.excludeVirtualColumns;
    }

    public Set<String> getExcludeDataTypes() {
        return this.excludeDataTypes;
    }

    public Set<String> getExcludeColumnNames() {
        return this.excludeColumnNames;
    }

    public Set<String> getIncludeColumnNames() {
        return this.includeColumnNames;
    }

    public boolean isPreserveZeroDatetime() {
        return this.preserveZeroDatetime;
    }

    public String getTimeValuePattern() {
        return this.timeValuePattern;
    }

    public String getDatetimeValuePattern() {
        return this.datetimeValuePattern;
    }

    public String getTimestampTzValuePattern() {
        return this.timestampTzValuePattern;
    }

    public String getTimestampLtzValuePattern() {
        return this.timestampLtzValuePattern;
    }

    public String getDateValuePattern() {
        return this.dateValuePattern;
    }

    public String getTimestampValuePattern() {
        return this.timestampValuePattern;
    }

    public boolean isLogicalDatabase() {
        return this.logicalDatabase;
    }

    public Map<ObjectType, Set<String>> getAllowedObjectMap() {
        return this.allowedObjectMap;
    }

    public Map<ObjectType, Set<String>> getDisallowedObjectMap() {
        return this.disallowedObjectMap;
    }

    public Map<String, Map<String, MapObject>> getColumnNameMapping() {
        return this.columnNameMapping;
    }
}

