/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.AdvancedOption;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.jdbc.JdbcTemplate;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.SqlUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaMetaCache {
    private static final Logger log = LoggerFactory.getLogger(SchemaMetaCache.class);
    static final String QUERY_INDEX_NAMES_OBORACLE = "SELECT /*+NO_MERGE(@\"SEL$9\")*/ I.TABLE_NAME AS TABLE_NAME, I.INDEX_NAME AS INDEX_NAME FROM ALL_INDEXES I LEFT JOIN ALL_IND_COLUMNS C ON I.TABLE_OWNER=C.TABLE_OWNER AND I.TABLE_NAME=C.TABLE_NAME AND I.OWNER=C.INDEX_OWNER AND I.INDEX_NAME=C.INDEX_NAME LEFT JOIN ALL_IND_EXPRESSIONS E ON I.TABLE_OWNER=E.TABLE_OWNER AND I.TABLE_NAME=E.TABLE_NAME AND I.OWNER=E.INDEX_OWNER AND I.INDEX_NAME=E.INDEX_NAME AND C.COLUMN_POSITION=E.COLUMN_POSITION WHERE I.TABLE_OWNER=? {0} AND I.TABLE_TYPE=''TABLE'' AND I.INDEX_TYPE!=''LOB'' AND (I.STATUS LIKE ? OR I.STATUS=''N/A'') AND C.COLUMN_NAME!=''SYS_SESSION_ID'' AND NOT EXISTS (SELECT 1 FROM ALL_CONSTRAINTS T1 WHERE I.TABLE_NAME=T1.TABLE_NAME AND I.INDEX_NAME=T1.CONSTRAINT_NAME AND (T1.CONSTRAINT_TYPE IN (''P'',''C'') OR (T1.CONSTRAINT_TYPE=''U'' AND I.INDEX_TYPE=''NORMAL'') OR (T1.CONSTRAINT_TYPE!=''U'' AND I.INDEX_TYPE LIKE ''FUNCTION-BASED%''))) ORDER BY I.LAST_ANALYZED, I.INDEX_NAME, C.COLUMN_POSITION, E.COLUMN_POSITION ASC";
    static final String GET_PRIMARY_KEY_OBORACLE_V3 = "SELECT C.TABLE_NAME AS TABLE_NAME, T.QUALIFIED_COL_NAME AS COLUMN_NAME, O.POSITION-1 AS POSITION FROM ALL_CONSTRAINTS C LEFT JOIN ALL_CONS_COLUMNS O ON C.OWNER=O.OWNER AND C.TABLE_NAME=O.TABLE_NAME AND C.CONSTRAINT_NAME=O.CONSTRAINT_NAME  LEFT JOIN ALL_INDEXES I ON C.OWNER=I.OWNER AND C.TABLE_NAME=I.TABLE_NAME AND C.INDEX_NAME=I.INDEX_NAME INNER JOIN ALL_TAB_COLS T  ON O.OWNER=T.OWNER AND O.TABLE_NAME=T.TABLE_NAME AND O.COLUMN_NAME=T.COLUMN_NAME AND T.HIDDEN_COLUMN=''NO''  WHERE C.OWNER=? {0} AND C.CONSTRAINT_TYPE=''P'' ORDER BY C.TABLE_NAME ASC, O.CONSTRAINT_NAME ASC, O.POSITION ASC";
    static final String GET_PRIMARY_KEY_OBORACLE_V4 = "SELECT C.TABLE_NAME AS TABLE_NAME, COLUMN_NAME, POSITION -1 FROM ALL_CONS_COLUMNS D,ALL_CONSTRAINTS C WHERE D.OWNER=? {0} AND C.CONSTRAINT_TYPE=''P'' AND D.CONSTRAINT_NAME=C.CONSTRAINT_NAME AND D.OWNER=C.OWNER AND D.TABLE_NAME=C.TABLE_NAME ORDER BY POSITION";
    static final String GET_NOT_NULL_UNIQUE_KEY_OBORACLE = "SELECT C.TABLE_NAME AS TABLE_NAME, T.QUALIFIED_COL_NAME AS COLUMN_NAME, O.POSITION-1 AS POSITION, C.CONSTRAINT_NAME AS CONSTRAINT_NAME FROM ALL_CONSTRAINTS C LEFT JOIN ALL_CONS_COLUMNS O ON C.OWNER=O.OWNER AND C.TABLE_NAME=O.TABLE_NAME AND C.CONSTRAINT_NAME=O.CONSTRAINT_NAME  LEFT JOIN ALL_INDEXES I ON C.OWNER=I.OWNER AND C.TABLE_NAME=I.TABLE_NAME AND C.INDEX_NAME=I.INDEX_NAME  INNER JOIN ALL_TAB_COLS T ON O.OWNER=T.OWNER AND O.TABLE_NAME=T.TABLE_NAME AND O.COLUMN_NAME=T.COLUMN_NAME AND T.HIDDEN_COLUMN=''NO''  WHERE C.OWNER=? {0} AND C.CONSTRAINT_TYPE=''U'' AND T.NULLABLE=''N'' ORDER BY C.TABLE_NAME ASC, O.CONSTRAINT_NAME ASC, O.POSITION ASC";
    private Map<String, List<String>> oracleTableIdxMap;
    private Map<String, List<String>> oracleTablePkMap;
    private Map<String, Map<String, List<String>>> oracleTableUkMap;

    public static SchemaMetaCache loadFromDatabase(ConnectionKey key, AdvancedOption option) {
        SchemaMetaCache context = new SchemaMetaCache();
        ServerMode serverMode = key.getServerMode();
        if (serverMode.isMysqlMode()) {
            return context;
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(key.getSessionManager());
        Set<String> whitelist = option.getAllowedObjectMap().get((Object)ObjectType.TABLE);
        try {
            String querySql;
            Object[] args;
            String schemaName = key.getDatabase();
            if (option.isIncludeDdl() && option.isCompactSchema()) {
                log.info("Preloading all indexes...");
                args = new Object[]{schemaName, "%VALID"};
                querySql = SchemaMetaCache.assembleQuerySql(QUERY_INDEX_NAMES_OBORACLE, whitelist, serverMode);
                context.oracleTableIdxMap = jdbcTemplate.queryMap(querySql, args, rs -> {
                    HashMap<String, List> m = new HashMap<String, List>();
                    while (rs.next()) {
                        m.computeIfAbsent(rs.getString(1), t -> Lists.newArrayList()).add(rs.getString(2));
                    }
                    log.debug("{} tables have indexes", (Object)m.keySet().size());
                    return m;
                });
            }
            if (option.isOnlyDdl() || option.isCustomQuery()) {
                return context;
            }
            log.info("Preloading all primary keys...");
            args = new Object[]{schemaName};
            querySql = SchemaMetaCache.assembleQuerySql(key.getServerMode().isPreviousV4() ? GET_PRIMARY_KEY_OBORACLE_V3 : GET_PRIMARY_KEY_OBORACLE_V4, whitelist, serverMode);
            context.oracleTablePkMap = jdbcTemplate.queryMap(querySql, args, rs -> {
                HashMap<String, List> m = new HashMap<String, List>();
                while (rs.next()) {
                    m.computeIfAbsent(rs.getString(1), t -> Lists.newArrayList()).add(rs.getString(2));
                }
                log.debug("{} tables have primary key", (Object)m.keySet().size());
                return m;
            });
            if (option.isEnableHiddenPk()) {
                context.oracleTableUkMap = new HashMap<String, Map<String, List<String>>>();
                return context;
            }
            HashSet<String> whitelist4QueryUk = whitelist != null ? new HashSet<String>(whitelist) : new HashSet();
            whitelist4QueryUk.removeIf(t -> context.oracleTablePkMap.containsKey(t));
            if (whitelist4QueryUk.size() == 0) {
                context.oracleTableUkMap = new HashMap<String, Map<String, List<String>>>();
                return context;
            }
            querySql = SchemaMetaCache.assembleQuerySql(GET_NOT_NULL_UNIQUE_KEY_OBORACLE, whitelist4QueryUk, serverMode);
            context.oracleTableUkMap = jdbcTemplate.queryMap(querySql, args, rs -> {
                HashMap<String, Map> res = new HashMap<String, Map>();
                while (rs.next()) {
                    Map curConstraintMap = res.computeIfAbsent(rs.getString(1), t -> Maps.newHashMap());
                    curConstraintMap.computeIfAbsent(rs.getString(4), t -> Lists.newArrayList()).add(rs.getString(2));
                }
                log.debug("{} tables have unique constraints, add up to {} unique constraints.", (Object)res.keySet().size(), (Object)res.values().size());
                return res;
            });
            return context;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static String assembleQuerySql(String pattern, Set<String> whitelist, ServerMode serverMode) {
        String cond = "";
        if (CollectionUtils.isNotEmpty(whitelist)) {
            cond = "AND " + SqlUtils.buildIncludeCondition(whitelist, serverMode, "C.TABLE_NAME");
        }
        return MessageFormat.format(pattern, cond);
    }

    private SchemaMetaCache() {
    }

    public Optional<Map<String, List<String>>> getObOracleTableIdxCache() {
        return Optional.ofNullable(this.oracleTableIdxMap);
    }

    public Optional<Map<String, List<String>>> getObOracleTablePkCache() {
        return Optional.ofNullable(this.oracleTablePkMap);
    }

    public Optional<Map<String, Map<String, List<String>>>> getObOracleTableUkCache() {
        return Optional.ofNullable(this.oracleTableUkMap);
    }
}

