/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.collections.MapUtils;

public class SessionConfig {
    private static final String ORACLE_TAG = "oracle";
    private static final String MYSQL_TAG = "mysql";
    @JsonProperty(value="init_sql")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, List<String>> initSql = new HashMap<String, List<String>>();
    @JsonProperty(value="jdbc_url_options")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> jdbcUrlOptions = new HashMap<String, String>();
    @JsonProperty(value="jdbc_hamode")
    private String jdbcHamode;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SessionConfig fromJson(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (FileInputStream fis = new FileInputStream(file);){
            SessionConfig sessionConfig = (SessionConfig)new ObjectMapper().readValue((InputStream)fis, SessionConfig.class);
            return sessionConfig;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Parse session configuration file failed. Error: ", e);
        }
    }

    public static SessionConfig fromJson(@NonNull String jsonStr) {
        if (jsonStr == null) {
            throw new NullPointerException("jsonStr is marked non-null but is null");
        }
        try {
            return (SessionConfig)new ObjectMapper().readValue(jsonStr, SessionConfig.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Parse session configuration file failed. Error: ", e);
        }
    }

    @NonNull
    public List<String> getInitSql4Oracle() {
        return Lists.newArrayList((Iterable)Optional.ofNullable(this.initSql).map(t -> (List)t.get(ORACLE_TAG)).orElse(new ArrayList()));
    }

    @NonNull
    public List<String> getInitSql4Mysql() {
        return Lists.newArrayList((Iterable)Optional.ofNullable(this.initSql).map(t -> (List)t.get(MYSQL_TAG)).orElse(new ArrayList()));
    }

    @NonNull
    public String getJdbcUrlOptionsString() {
        if (MapUtils.isEmpty(this.jdbcUrlOptions)) {
            return "";
        }
        String optionString = this.jdbcUrlOptions.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        return "?" + optionString;
    }

    @Nullable
    public String getJdbcOptionByKey(String key) {
        return this.jdbcUrlOptions.get(key);
    }

    public synchronized void setJdbcOption(String key, String value) {
        this.jdbcUrlOptions.put(key, value);
    }

    public synchronized void addInitSql4Mysql(String sql) {
        this.initSql.computeIfAbsent(MYSQL_TAG, key -> new ArrayList()).add(sql);
    }

    public synchronized void addInitSql4Oracle(String sql) {
        this.initSql.computeIfAbsent(ORACLE_TAG, key -> new ArrayList()).add(sql);
    }

    public synchronized void addInitSql4Both(String sql) {
        this.initSql.computeIfAbsent(MYSQL_TAG, key -> new ArrayList()).add(sql);
        this.initSql.computeIfAbsent(ORACLE_TAG, key -> new ArrayList()).add(sql);
    }

    public String getJdbcHamode() {
        return this.jdbcHamode;
    }
}

