/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.context;

import com.oceanbase.tools.loaddump.common.model.Insertion;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.directpath.DirectPathConnection;
import com.oceanbase.tools.loaddump.manager.MemoryManager;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.parquet.Preconditions;

public class LoadContext {
    private final int maxErrors;
    private final int maxDiscards;
    private final Map<String, AtomicInteger> discardMap = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, AtomicInteger> errCntMap = new ConcurrentHashMap<String, AtomicInteger>();
    private final boolean strict;
    private final Map<String, AtomicBoolean> tableFailMarkMap = new ConcurrentHashMap<String, AtomicBoolean>();
    private AtomicBoolean logStopEvent;
    private final Map<String, AtomicInteger> tableSubFileCountDown = new HashMap<String, AtomicInteger>();
    private final BatchCoordinator[] coordinators;
    private final boolean directMode;
    private Map<String, DirectPathConnection> directLoadConnMap;
    private MemoryManager memoryManager = new MemoryManager();

    public LoadContext(LoadParameter parameter) {
        Preconditions.checkState((parameter.getSubFiles() != null && parameter.getSubFiles().size() > 0 ? 1 : 0) != 0, (String)"Init global context before generating sub-files.");
        this.maxErrors = parameter.getMaxErrors();
        this.maxDiscards = parameter.getMaxDiscards();
        this.strict = parameter.isStrict();
        this.directMode = parameter.isDirectMode();
        this.coordinators = new BatchCoordinator[parameter.getSubFiles().size()];
        parameter.getSubFiles().forEach(subFile -> {
            String tableName = subFile.getObjectName();
            this.errCntMap.putIfAbsent(tableName, new AtomicInteger(0));
            this.discardMap.putIfAbsent(tableName, new AtomicInteger(0));
            this.tableFailMarkMap.putIfAbsent(tableName, new AtomicBoolean(true));
            this.tableSubFileCountDown.computeIfAbsent(tableName, k -> new AtomicInteger(0)).incrementAndGet();
            this.coordinators[subFile.getUid()] = new BatchCoordinator();
        });
    }

    public AtomicInteger incrementErrorCount(String tableName) {
        AtomicInteger count = this.errCntMap.computeIfAbsent(tableName, v -> new AtomicInteger(0));
        count.incrementAndGet();
        return count;
    }

    public AtomicInteger getErrorCount(String tableName) {
        return this.errCntMap.get(tableName);
    }

    public boolean isExceedMaxErrors(String tableName) {
        AtomicInteger count = this.errCntMap.getOrDefault(tableName, null);
        return count != null && this.maxErrors >= 0 && count.get() > this.maxErrors;
    }

    public boolean incrementAndIsExceedMaxErrors(String tableName) {
        this.incrementErrorCount(tableName);
        return this.isExceedMaxErrors(tableName);
    }

    public boolean isExceedMaxDiscards(String tableName) {
        AtomicInteger count = this.discardMap.getOrDefault(tableName, null);
        return count != null && this.maxDiscards >= 0 && count.get() > this.maxDiscards;
    }

    public AtomicInteger incrementDiscardCount(String tableName) {
        AtomicInteger count = this.discardMap.computeIfAbsent(tableName, v -> new AtomicInteger(0));
        count.incrementAndGet();
        return count;
    }

    public boolean incrementAndIsExceedMaxDiscards(String tableName) {
        this.incrementDiscardCount(tableName);
        return this.isExceedMaxDiscards(tableName);
    }

    public boolean shouldFail(String tableName) {
        return !this.tableFailMarkMap.get(tableName).get() || this.isExceedMaxErrors(tableName) || this.isExceedMaxDiscards(tableName);
    }

    public void markTableFail(String tableName) {
        this.tableFailMarkMap.get(tableName).compareAndSet(true, false);
    }

    public void batchProduced(Insertion insertion) {
        this.memoryManager.checkMemory(insertion.getByteSize());
    }

    public void batchConsumed(Insertion insertion) {
        this.memoryManager.free(insertion.getByteSize());
        SubFile subFile = insertion.getSubFile();
        if (this.coordinators[subFile.getUid()] == null) {
            this.coordinators[subFile.getUid()] = new BatchCoordinator();
        }
        BatchCoordinator coordinator = this.coordinators[subFile.getUid()];
        coordinator.incrementProcessedBatches();
    }

    public void waitForAllBatchesConsumed(SubFile subFile, int total) throws Exception {
        int subFileId = subFile.getUid();
        this.coordinators[subFileId].waitForAllBatches(total);
        this.coordinators[subFileId] = null;
        this.countDownOnTable(subFile.getObjectName());
    }

    private void countDownOnTable(String tableName) throws Exception {
        if (!JvmArgs.isDryRunMode && this.directMode && this.tableSubFileCountDown.get(tableName).decrementAndGet() == 0 && !this.shouldFail(tableName)) {
            this.directLoadConnMap.get(tableName).commit();
        }
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public int getMaxDiscards() {
        return this.maxDiscards;
    }

    public Map<String, AtomicInteger> getDiscardMap() {
        return this.discardMap;
    }

    public Map<String, AtomicInteger> getErrCntMap() {
        return this.errCntMap;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public Map<String, AtomicBoolean> getTableFailMarkMap() {
        return this.tableFailMarkMap;
    }

    public AtomicBoolean getLogStopEvent() {
        return this.logStopEvent;
    }

    public void setLogStopEvent(AtomicBoolean logStopEvent) {
        this.logStopEvent = logStopEvent;
    }

    public Map<String, AtomicInteger> getTableSubFileCountDown() {
        return this.tableSubFileCountDown;
    }

    public BatchCoordinator[] getCoordinators() {
        return this.coordinators;
    }

    public boolean isDirectMode() {
        return this.directMode;
    }

    public Map<String, DirectPathConnection> getDirectLoadConnMap() {
        return this.directLoadConnMap;
    }

    public void setDirectLoadConnMap(Map<String, DirectPathConnection> directLoadConnMap) {
        this.directLoadConnMap = directLoadConnMap;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    static class BatchCoordinator {
        private final AtomicLong processedBatches = new AtomicLong(0L);
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition cond = this.lock.newCondition();
        private volatile boolean needSignal = false;

        BatchCoordinator() {
        }

        public void incrementProcessedBatches() {
            this.processedBatches.incrementAndGet();
            if (this.needSignal) {
                this.lock.lock();
                try {
                    this.cond.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void waitForAllBatches(int totalBatch) {
            this.needSignal = true;
            this.lock.lock();
            try {
                while (this.processedBatches.get() < (long)totalBatch) {
                    try {
                        this.cond.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                        return;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

