/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.context;

import com.oceanbase.tools.loaddump.common.model.Progress;
import com.oceanbase.tools.loaddump.common.model.RuntimeMetrics;
import com.oceanbase.tools.loaddump.common.model.ServerStatus;
import com.oceanbase.tools.loaddump.common.model.Summary;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskContext {
    private static final Logger log = LoggerFactory.getLogger(TaskContext.class);

    public abstract RuntimeMetrics getRuntimeMetrics();

    public abstract Progress getProgress();

    public abstract Summary getSummary();

    public abstract ServerStatus getServerStatus();

    public abstract boolean isThreadPoolAlive();

    public abstract boolean isAllTasksFinished();

    public abstract boolean isAllTasksSuccessed();

    public abstract Collection<TaskDetail> getAllTaskDetails();

    public abstract Collection<TaskDetail> getFailureTaskDetails();

    public abstract void shutdown() throws Exception;

    public abstract void shutdownNow() throws Exception;

    protected boolean isAlive(ExecutorService executor) {
        return executor != null && !executor.isShutdown() && !executor.isTerminated();
    }

    protected void shutdownInternal(boolean immediately, ExecutorService executor) {
        block5: {
            if (this.isAlive(executor)) {
                try {
                    if (immediately) {
                        executor.shutdownNow();
                    } else {
                        executor.shutdown();
                        executor.awaitTermination(0L, TimeUnit.SECONDS);
                    }
                }
                catch (Exception e) {
                    log.warn("Shutdown {} immediately failed", (Object)(immediately ? " " : " not "));
                    if (immediately) break block5;
                    this.shutdownInternal(true, executor);
                }
            }
        }
    }

    public abstract void stopLogReporter();
}

