/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.decrypt;

import com.alibaba.druid.pool.ha.PropertiesUtils;
import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.decrypt.OpenSslDecryptor;
import com.oceanbase.tools.loaddump.decrypt.SecureContent;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import lombok.NonNull;

public class DecryptTools {
    private static final String DEFAULT_PROPERTY_PATH = System.getProperty("decrypt.configurationFile");

    @NonNull
    public static SecureContent decrypt() throws Exception {
        Properties props = PropertiesUtils.loadProperties((String)DEFAULT_PROPERTY_PATH);
        if (props.size() == 0) {
            return new SecureContent();
        }
        String className = props.getProperty("decrypt.className");
        if (StringUtils.isBlank(className)) {
            return DecryptTools.decryptByOpenSsl(props);
        }
        Class<?> decryptClass = Class.forName(className);
        Method decryptMethod = decryptClass.getMethod("decrypt", String.class);
        String securePath = props.getProperty("secure.filePath");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(securePath), (Object)"The property \"secure.filePath\" may not be specified");
        Object obj = decryptClass.newInstance();
        String encryptedStr = new String(FileUtils.readFileToByteArray((File)new File(securePath)), StandardCharsets.UTF_8);
        String decryptedStr = (String)decryptMethod.invoke(obj, encryptedStr);
        Properties secure = new Properties();
        try (StringReader decryptedSr = new StringReader(decryptedStr);){
            secure.load(decryptedSr);
        }
        return SecureContent.newInstance(secure);
    }

    @NonNull
    private static SecureContent decryptByOpenSsl(Properties props) throws Exception {
        try {
            String secureFilePath = props.getProperty("secure.filePath");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank(secureFilePath), (Object)"The property \"secure.filePath\" should be set.");
            String privateKeyPath = props.getProperty("privateKey.filePath");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank(privateKeyPath), (Object)"The property \"privateKey.filePath\" should be set.");
            String secureRaw = OpenSslDecryptor.decrypt(secureFilePath, privateKeyPath);
            Properties secure = new Properties();
            secure.load(new StringReader(secureRaw));
            return SecureContent.newInstance(secure);
        }
        catch (Exception e) {
            LogUtils.error("Decrypt secure file failed. Reason: {}.\n-\tNote: It may caused by incorrect config in \"decrypt.properties\". To resolve this, you may reset the \"decrypt.properties\" as the official document guided.", e.getMessage());
            throw e;
        }
    }
}

