/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.divider;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.resource.Resource;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractFileDivider {
    protected static final int MAX_CHUNK_SIZE = 0x40000000;
    protected static final int BUFFER_SIZE_THRESHOLD = 0x400000;
    protected Resource resource;
    protected char escape;
    protected char quoteChar;
    protected long blockSize;
    protected int chunkNum;
    protected Map<Integer, long[]> lineTermPosMap = new HashMap<Integer, long[]>();
    protected Map<Integer, Long> quoteCharCntMap = new HashMap<Integer, Long>();

    public AbstractFileDivider(Resource resource, long blockSize) {
        this(resource, blockSize, '\\', Constants.CsvConsts.SINGLE_QUOTE_CHAR.charValue());
    }

    public AbstractFileDivider(Resource resource, long blockSize, char escape, char quoteChar) {
        this.resource = resource;
        this.escape = escape;
        this.quoteChar = quoteChar;
        this.blockSize = blockSize;
    }

    public abstract List<SubFile> divideFile() throws Exception;

    protected long[] divideInternal() throws Exception {
        try (RandomAccessFile raf = new RandomAccessFile(new File(this.resource.getResourcePath()), "r");){
            long[] rawPos = this.getRawPositions(raf);
            this.forwardScan(rawPos);
            long[] lArray = this.getRealPositions(raf.length());
            return lArray;
        }
    }

    public boolean isEndOfLine(byte[] buffer, int index) {
        char current = (char)buffer[index];
        if (index < buffer.length - 1) {
            char next = (char)buffer[index + 1];
            if (current == '\r' && next == '\n') {
                current = next;
            }
        }
        return current == '\r' || current == '\n';
    }

    private long[] getRawPositions(RandomAccessFile raf) throws IOException {
        char c;
        long length = raf.length();
        this.chunkNum = this.getChunkNum(length);
        long[] rawPos = new long[this.chunkNum + 1];
        int index = 1;
        long startPos = 0L;
        long nextPos = 0L;
        block0: do {
            nextPos = startPos + this.blockSize;
            if (index == this.chunkNum) {
                rawPos[index] = length;
                break;
            }
            if (nextPos >= length) break;
            raf.seek(nextPos - 1L);
            c = '\uffffffff';
            while ((c = raf.read()) != '\uffffffff') {
                long currPos = raf.getFilePointer();
                if (currPos == rawPos[index - 1]) {
                    rawPos[index++] = currPos;
                    startPos = nextPos;
                    continue block0;
                }
                if (c != this.escape) {
                    rawPos[index++] = currPos;
                    startPos = currPos;
                    continue block0;
                }
                if (currPos <= rawPos[index - 1]) continue;
                raf.seek(currPos - 2L);
            }
        } while (c != -1);
        return rawPos;
    }

    private void forwardScan(long[] rawPos) {
        ExecutorTemplate<SubPartParam> template = new ExecutorTemplate<SubPartParam>("file-forward-scan-", Runtime.getRuntime().availableProcessors());
        int i = 0;
        while (i < rawPos.length - 1) {
            long startPos = rawPos[i];
            long endPos = rawPos[i + 1];
            int index = i++;
            template.submit(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }
        for (SubPartParam sub : template.waitForResult()) {
            this.quoteCharCntMap.put(sub.getIndex(), sub.getQuoteNum());
            this.lineTermPosMap.put(sub.getIndex(), sub.getLineTerms());
        }
    }

    private SubPartParam partScan(MappedByteBuffer mbb, long startPos, int index) throws Exception {
        boolean escapeState = false;
        long quoteNum = 0L;
        long[] lineTerms = new long[2];
        int mbbLimit = mbb.limit();
        char ch = '\u0000';
        int initialSize = Math.min(mbbLimit, 0x400000);
        byte[] buffer = new byte[initialSize];
        int offset = 0;
        while (offset < mbbLimit) {
            mbb.get(buffer);
            for (int i = 0; i < buffer.length; ++i) {
                if (escapeState) {
                    escapeState = false;
                    continue;
                }
                ch = (char)buffer[i];
                if (ch == this.escape) {
                    escapeState = true;
                    continue;
                }
                if (ch == this.quoteChar) {
                    ++quoteNum;
                }
                if (!this.isEndOfLine(buffer, i)) continue;
                long pos = startPos + (long)offset + (long)i;
                if ((quoteNum & 1L) == 0L) {
                    lineTerms[0] = pos;
                    continue;
                }
                lineTerms[1] = pos;
            }
            mbb.position(offset += buffer.length);
            if (mbb.limit() - offset >= buffer.length || mbbLimit - offset <= 0) continue;
            buffer = new byte[mbbLimit - offset];
        }
        return new SubPartParam(index, quoteNum, lineTerms);
    }

    private long[] getRealPositions(long length) {
        long[] posArr = new long[this.chunkNum + 1];
        posArr[0] = 0L;
        int index = 1;
        long totalQuoteChar = 0L;
        for (int i = 0; i < this.chunkNum; ++i) {
            if ((totalQuoteChar & 1L) == 0L && this.lineTermPosMap.get(i)[0] != 0L) {
                posArr[index++] = this.lineTermPosMap.get(i)[0];
            } else if ((totalQuoteChar & 1L) == 1L && this.lineTermPosMap.get(i)[1] != 0L) {
                posArr[index++] = this.lineTermPosMap.get(i)[1];
            }
            totalQuoteChar += this.quoteCharCntMap.get(i).longValue();
        }
        for (int j = index; j <= this.chunkNum; ++j) {
            posArr[index] = length;
        }
        return posArr;
    }

    private int getChunkNum(long length) {
        if (this.blockSize > 0x40000000L) {
            this.blockSize = 0x40000000L;
            return (int)(length / 0x40000000L + 1L);
        }
        return (int)(length / this.blockSize + 1L);
    }

    static class SubPartParam {
        private long[] lineTerms;
        private int index;
        private long quoteNum;

        SubPartParam(int index, long quoteNum, long[] lineTerms) {
            this.index = index;
            this.quoteNum = quoteNum;
            this.lineTerms = lineTerms;
        }

        public long[] getLineTerms() {
            return this.lineTerms;
        }

        public void setLineTerms(long[] lineTerms) {
            this.lineTerms = lineTerms;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public long getQuoteNum() {
            return this.quoteNum;
        }

        public void setQuoteNum(long quoteNum) {
            this.quoteNum = quoteNum;
        }
    }
}

