/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProvider;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.Progress;
import com.oceanbase.tools.loaddump.common.model.RuntimeMetrics;
import com.oceanbase.tools.loaddump.common.model.ServerStatus;
import com.oceanbase.tools.loaddump.common.model.Summary;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.concurrent.NamedThreadFactory;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.dumper.IDumper;
import com.oceanbase.tools.loaddump.dumper.record.RecordFileDumper;
import com.oceanbase.tools.loaddump.dumper.task.AbstractDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.record.RecordDumpTask;
import com.oceanbase.tools.loaddump.generator.IDumpTaskGenerator;
import com.oceanbase.tools.loaddump.manager.SessionManager;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.SerializeUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDumper<T extends AbstractDumpTask>
extends TaskContext
implements IDumper {
    private static final Logger log = LoggerFactory.getLogger(AbstractDumper.class);
    protected State state = State.INITIAL;
    protected Meter meter;
    protected ServerMode serverMode;
    protected AtomicBoolean supervisor;
    protected DumpParameter parameter;
    protected ConnectionKey connectionKey;
    protected SessionManager sessionManager;
    protected MetadataProvider metadataProvider;
    protected RuntimeMetrics runtimeMetrics;
    protected ExecutorService defaultExecutor;
    protected final List<TaskDetail> taskDetailList;
    protected IDumpTaskGenerator<T> taskGenerator;
    protected List<? extends AbstractDumpTask> dumpTasks;
    protected final ScheduledExecutorService logReporterExecutor;

    public AbstractDumper(DumpParameter parameter) {
        this.parameter = parameter;
        this.connectionKey = parameter.getConnectionKey();
        this.sessionManager = parameter.getConnectionKey().getSessionManager();
        this.metadataProvider = parameter.getConnectionKey().getMetadataProvider();
        this.taskDetailList = new ArrayList<TaskDetail>(16);
        this.supervisor = new AtomicBoolean(true);
        this.serverMode = parameter.getDatabase().getServerMode();
        this.logReporterExecutor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("log-reporter-"), new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    @Override
    public IDumper prepare() throws Exception {
        ExecutorTemplate.setPoolSize(this.parameter.getThreads());
        String checkpointPath = this.parameter.getCheckpointPath();
        Map<String, CsvFormat> formatMap = this.parameter.initCsvFormatMap();
        if (this instanceof RecordFileDumper) {
            ((RecordFileDumper)this).initControlManager();
        }
        if (this.parameter.isRetry()) {
            File checkpoint = new File(checkpointPath);
            if (!(this.parameter.isIncludeDdl() || checkpoint.exists() && !checkpoint.isDirectory())) {
                throw new FileNotFoundException("File: \"" + checkpointPath + "\" is missing");
            }
            List<AbstractDumpTask> persistTasks = SerializeUtils.deserializeListByKryo(checkpointPath);
            if (CollectionUtils.isEmpty(persistTasks)) {
                throw new IllegalStateException("No dump tasks are recovered from the checkpoint file: \"" + checkpointPath + "\"");
            }
            ArrayList<? extends AbstractDumpTask> nonSuccessTasks = new ArrayList<AbstractDumpTask>();
            for (AbstractDumpTask dumpTask : persistTasks) {
                if (TaskState.SUCCESS == dumpTask.getTaskState()) continue;
                dumpTask.initialize(this.parameter);
                dumpTask.setDumpTasks(nonSuccessTasks);
                if (dumpTask instanceof RecordDumpTask) {
                    ((RecordDumpTask)dumpTask).setCsvFormat(formatMap.get(dumpTask.getObjectName()));
                }
                nonSuccessTasks.add(dumpTask);
                this.taskDetailList.add(dumpTask.getTaskDetail());
            }
            this.dumpTasks = nonSuccessTasks;
            Preconditions.checkState((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(this.dumpTasks), (Object)"Maybe all the dump tasks have already finished");
            log.info("Recovery {} non success dump tasks finished", (Object)this.dumpTasks.size());
        } else {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.dumpTasks = this.taskGenerator.generateDumpTask();
            this.taskGenerator = null;
            Preconditions.checkState((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(this.dumpTasks), (String)"No dump tasks are generated for schema: \"%s\". Make sure to specify at least one existing object", (Object)this.connectionKey.getDatabase());
            AtomicLong fileSizeAccumulator = new AtomicLong(0L);
            for (AbstractDumpTask abstractDumpTask : this.dumpTasks) {
                abstractDumpTask.setDumpTasks(this.dumpTasks);
                abstractDumpTask.setSupervisor(this.supervisor);
                abstractDumpTask.setIdenticalNoMap(new ConcurrentHashMap<String, AtomicLong>());
                abstractDumpTask.setTaskDetail(new TaskDetail());
                abstractDumpTask.setCheckpointPath(checkpointPath);
                if (abstractDumpTask instanceof RecordDumpTask) {
                    ((RecordDumpTask)abstractDumpTask).setCsvFormat(formatMap.get(abstractDumpTask.getObjectName()));
                    ((RecordDumpTask)abstractDumpTask).setFileSizeAccumulator(fileSizeAccumulator);
                }
                abstractDumpTask.initialize(this.parameter);
                this.taskDetailList.add(abstractDumpTask.getTaskDetail());
            }
            log.info("Generate {} dump tasks finished. Total Elapsed: {}", (Object)this.dumpTasks.size(), (Object)stopwatch);
        }
        this.state = State.PREPARE;
        return this;
    }

    protected void checkState() throws Exception {
        Preconditions.checkState((this.state != State.RUNNING ? 1 : 0) != 0, (Object)"It's already running");
        Preconditions.checkState((this.state != State.TERMINATE ? 1 : 0) != 0, (Object)"It has terminated");
        Preconditions.checkState((this.state == State.PREPARE ? 1 : 0) != 0, (Object)"Not prepared");
    }

    @Override
    public RuntimeMetrics getRuntimeMetrics() {
        if (this.runtimeMetrics == null) {
            this.runtimeMetrics = new RuntimeMetrics();
        }
        this.runtimeMetrics.setThroughput(this.meter != null ? this.meter.getThroughput() : 0L);
        this.runtimeMetrics.setMeanThroughputRate(this.meter != null ? this.meter.getMeanThroughputRate() : 0.0);
        this.runtimeMetrics.setProgress(this.getProgress().getProgress());
        this.runtimeMetrics.setCount(this.taskDetailList.stream().mapToLong(TaskDetail::getCount).sum());
        this.runtimeMetrics.setTotal(this.taskDetailList.stream().mapToLong(TaskDetail::getTotal).sum());
        return this.runtimeMetrics;
    }

    @Override
    public Progress getProgress() {
        int totalTasks = this.dumpTasks.size();
        int finishedTasks = this.dumpTasks.stream().filter(AbstractDumpTask::isFinished).mapToInt(t -> 1).sum();
        int runningTasks = totalTasks - finishedTasks;
        int percentage = finishedTasks * 100 / totalTasks;
        return new Progress(finishedTasks, runningTasks, percentage);
    }

    @Override
    public Summary getSummary() {
        return new Summary("All Dump Tasks Finished", this.getAllTaskDetails());
    }

    @Override
    public ServerStatus getServerStatus() {
        return new ServerStatus(Maps.newHashMap());
    }

    @Override
    public boolean isThreadPoolAlive() {
        return this.isAlive(this.defaultExecutor);
    }

    @Override
    public boolean isAllTasksFinished() {
        if (CollectionUtils.isEmpty(this.taskDetailList)) {
            log.warn("The task details are empty, please check it....");
            return false;
        }
        return this.getAllTaskDetails().stream().allMatch(TaskDetail::isFinished);
    }

    @Override
    public boolean isAllTasksSuccessed() {
        if (CollectionUtils.isEmpty(this.taskDetailList)) {
            log.warn("The task details are empty, please check it....");
            return false;
        }
        return this.getAllTaskDetails().stream().allMatch(TaskDetail::isSuccess);
    }

    @Override
    public Collection<TaskDetail> getAllTaskDetails() {
        return Collections.unmodifiableCollection(this.taskDetailList);
    }

    @Override
    public Collection<TaskDetail> getFailureTaskDetails() {
        return this.taskDetailList.stream().filter(TaskDetail::isFailure).collect(Collectors.toList());
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdownInternal(true, this.logReporterExecutor);
        super.shutdownInternal(false, this.defaultExecutor);
        this.supervisor.compareAndSet(true, false);
        this.state = State.TERMINATE;
    }

    @Override
    public void shutdownNow() throws Exception {
        this.shutdownInternal(true, this.logReporterExecutor);
        this.supervisor.compareAndSet(true, false);
        this.shutdownInternal(true, this.defaultExecutor);
        this.state = State.TERMINATE;
    }

    public abstract IDumpTaskGenerator<T> createDumpTaskGenerator();

    @Override
    public void stopLogReporter() {
        super.shutdownInternal(true, this.logReporterExecutor);
    }

    public List<? extends AbstractDumpTask> getDumpTasks() {
        return this.dumpTasks;
    }
}

