/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.assembler;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.Hint;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.TableRangeInfo;
import com.oceanbase.tools.loaddump.dumper.assembler.IStatementAssembler;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatementAssembler
implements IStatementAssembler {
    private static final Logger log = LoggerFactory.getLogger(AbstractStatementAssembler.class);
    protected transient DumpParameter parameter;
    protected TableRangeInfo tableRangeInfo;
    protected boolean sub2270;
    protected long dataVersion;
    private static final Cache<String, StringBuilder> STMT_CACHE = CacheBuilder.newBuilder().initialCapacity(64).maximumSize(4096L).concurrencyLevel(256).expireAfterAccess(30L, TimeUnit.SECONDS).removalListener(n -> {
        if (log.isDebugEnabled()) {
            log.debug("Remove the cached statement as the key has been marked: {}", (Object)n.getCause());
        }
    }).build();

    protected AbstractStatementAssembler(DumpParameter parameter) {
        this(new TableRangeInfo(), parameter, -1L);
    }

    protected AbstractStatementAssembler(TableRangeInfo tableRangeInfo, DumpParameter parameter, long dataVersion) {
        this.parameter = parameter;
        this.tableRangeInfo = tableRangeInfo;
        this.sub2270 = !parameter.getDatabase().getServerMode().isPreviousV2270();
        this.dataVersion = dataVersion;
    }

    protected StringBuilder buildSelectPrefix() {
        String tableName = this.getTableRangeInfo().getTableName();
        StringBuilder sb = new StringBuilder(256);
        sb.append("SELECT ");
        List<Hint> hints = this.findRequiredHints();
        if (CollectionUtils.isNotEmpty(hints)) {
            sb.append("/*+ ");
            sb.append(hints.stream().map(Hint::getHintStatement).collect(Collectors.joining(" , ")));
            sb.append(" */ ");
        }
        if (this.parameter.isDistinct()) {
            sb.append("distinct ");
        }
        sb.append(this.parameter.getDatabase().getTableInfo(tableName).buildColumnString(true));
        return sb.append(" FROM ").append(this.parameter.getDatabase().getServerMode().wrapName(tableName));
    }

    private List<Hint> findRequiredHints() {
        ArrayList<Hint> hints = new ArrayList<Hint>(2);
        if (this.parameter.isSnapshot() && this.getDataVersion() > -1L) {
            hints.add(new Hint(Hint.HintTypes.FROZEN_VERSION, this.getDataVersion()));
        }
        if (this.parameter.isEnableHiddenPk()) {
            hints.add(new Hint(Hint.HintTypes.OPT_PARAM, "'hidden_column_visible', 'true'"));
        }
        return hints;
    }

    @Override
    public List<String> assembleQuerySql() {
        if (StringUtils.isNotEmpty(this.getParameter().getQuerySql())) {
            return Lists.newArrayList((Object[])new String[]{this.getParameter().getQuerySql()});
        }
        StringBuilder querySqlPrefix = new StringBuilder(256);
        querySqlPrefix.append((CharSequence)this.getSqlPrefix());
        if (this.parameter.isLogicalDatabase()) {
            return Lists.newArrayList((Object[])new String[]{querySqlPrefix.toString()});
        }
        querySqlPrefix.append(this.getPartitionName());
        querySqlPrefix.append(this.getFlashbackClause());
        boolean hasWhereClause = StringUtils.isNotEmpty(this.parameter.getWhereClause());
        String whereClause = hasWhereClause ? this.parameter.getWhereClause().trim() : "";
        boolean hasPrimaryKey = this.tableRangeInfo.hasPrimary();
        if (!hasWhereClause && !hasPrimaryKey) {
            return Lists.newArrayList((Object[])new String[]{querySqlPrefix.toString()});
        }
        querySqlPrefix.append(" WHERE ");
        if (hasWhereClause && !hasPrimaryKey) {
            return Lists.newArrayList((Object[])new String[]{querySqlPrefix.append(whereClause).toString()});
        }
        ArrayList<String> querySqlList = new ArrayList<String>();
        for (StringBuilder placeHolders : this.tableRangeInfo.getPrimaryPlaceHolders()) {
            StringBuilder querySql = new StringBuilder().append((CharSequence)querySqlPrefix);
            if (hasWhereClause) {
                querySql.append((CharSequence)placeHolders).append(" AND ").append(whereClause);
            } else {
                querySql.append((CharSequence)placeHolders);
            }
            querySqlList.add(querySql.toString());
        }
        return querySqlList;
    }

    public void expireCache() {
        STMT_CACHE.invalidateAll();
    }

    private StringBuilder getSqlPrefix() {
        String key = this.tableRangeInfo.getTableName();
        try {
            return (StringBuilder)STMT_CACHE.get((Object)key, this::buildSelectPrefix);
        }
        catch (ExecutionException e) {
            log.error("Get select prefix from sql cache failed. Key: {}. Reason: {}.", (Object)key, (Object)ExceptionUtils.getRootCause((Throwable)e));
            return this.buildSelectPrefix();
        }
    }

    protected abstract CharSequence getFlashbackClause();

    protected abstract CharSequence getPartitionName();

    public AbstractStatementAssembler() {
    }

    public DumpParameter getParameter() {
        return this.parameter;
    }

    public void setParameter(DumpParameter parameter) {
        this.parameter = parameter;
    }

    public TableRangeInfo getTableRangeInfo() {
        return this.tableRangeInfo;
    }

    public void setTableRangeInfo(TableRangeInfo tableRangeInfo) {
        this.tableRangeInfo = tableRangeInfo;
    }

    public boolean isSub2270() {
        return this.sub2270;
    }

    public void setSub2270(boolean sub2270) {
        this.sub2270 = sub2270;
    }

    public long getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(long dataVersion) {
        this.dataVersion = dataVersion;
    }

    public static Cache<String, StringBuilder> getSTMT_CACHE() {
        return STMT_CACHE;
    }
}

