/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.schema;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.ObjectStatus;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.configure.Configure;
import com.oceanbase.tools.loaddump.configure.Global;
import com.oceanbase.tools.loaddump.dumper.task.AbstractDumpTask;
import com.oceanbase.tools.loaddump.factory.FileUploaderFactory;
import com.oceanbase.tools.loaddump.resource.remote.FileUploader;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaDumpTask
extends AbstractDumpTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchemaDumpTask.class);
    protected static final Integer DEFAULT_BATCH_SIZE = 128;
    protected static final String SHOW_CREATE_TABLE = "show create ";
    private static final long serialVersionUID = -1139166400050781462L;
    protected final Map<ObjectType, Set<String>> blackListMap = new HashMap<ObjectType, Set<String>>();
    protected final Map<ObjectType, Set<String>> whiteListMap = new HashMap<ObjectType, Set<String>>();
    protected final List<ObjectStatus> objectStatusList = new CopyOnWriteArrayList<ObjectStatus>();
    protected int innerThread;
    protected boolean droppable;
    protected boolean schemaless;
    protected boolean withExtra;
    protected String plDelimiter = "$$";
    protected String outputPath;
    protected transient FileUploader fileUploader;

    @Override
    public void initialize(DumpParameter parameter) throws Exception {
        super.initialize(parameter);
        this.schemaName = parameter.getDatabaseName();
        this.innerThread = parameter.getThreads();
        this.droppable = parameter.isDroppable();
        this.schemaless = parameter.isSchemaless();
        this.withExtra = parameter.isWithExtra() || JvmArgs.isBackupRestoreMode;
        this.serverMode = parameter.getDatabase().getServerMode();
        this.outputPath = parameter.getDefaultDatabasePath();
        if (parameter.getStorageConfig() != null) {
            this.fileUploader = FileUploaderFactory.createFileUploader(parameter.getStorageConfig(), parameter.getFilePath());
        }
    }

    @Override
    public void run() {
        if (super.isFinished()) {
            return;
        }
        try {
            this.dumpCreateObjects();
            this.updateTaskState(TaskState.SUCCESS);
        }
        catch (Throwable ex) {
            this.updateTaskState(TaskState.FAILURE);
            this.message = ExceptionUtils.getRootCauseMessage(ex);
        }
        finally {
            if (this.fileUploader != null) {
                this.fileUploader.close();
            }
            this.updateTaskDetail();
        }
    }

    private void dumpCreateObjects() throws Exception {
        DbType dbType = DbType.valueOf(this.serverMode.name(), this.serverMode.getVersion());
        Global global = Global.newInstance().setSchemaless(this.schemaless).setWithExtra(this.withExtra);
        for (Map.Entry<ObjectType, Set<String>> entry : this.whiteListMap.entrySet()) {
            ObjectType objectType = entry.getKey();
            Set<String> objectNames = entry.getValue();
            if (CollectionUtils.isEmpty(objectNames)) continue;
            HashSet includeObjectTypes = Sets.newHashSet((Object[])new String[]{objectType.getName()});
            Configure configure = new Configure(global, dbType, this.schemaName, this.sessionManager, includeObjectTypes);
            configure.setIgnoreCheckReference(true);
            configure.setIgnoreCycleReference(true);
            configure.setInnerThread(this.innerThread);
            configure.getBlackListMap().putAll(this.blackListMap);
            List partitionedObjectNames = Lists.partition((List)Lists.newArrayList(objectNames), (int)DEFAULT_BATCH_SIZE);
            for (int i = 0; i < partitionedObjectNames.size(); ++i) {
                configure.getWhiteListMap().put(objectType, Sets.newHashSet((Iterable)((Iterable)partitionedObjectNames.get(i))));
                List<ObjectDefine> objectDefines = this.dumpSchema(configure);
                this.dumpInternal(dbType, objectDefines);
                configure.getWhiteListMap().clear();
            }
        }
    }

    public abstract List<ObjectDefine> dumpSchema(Configure var1) throws Exception;

    private void dumpInternal(DbType dbType, List<ObjectDefine> objectDefines) throws Exception {
        Iterator iter = objectDefines.stream().filter(Objects::nonNull).iterator();
        block0: while (iter.hasNext() && this.supervisor.get()) {
            String filePath;
            boolean isPlSql;
            boolean skipPublicSynonym;
            ObjectDefine objectDefine = (ObjectDefine)iter.next();
            String objectType = objectDefine.getObjectType();
            String objectName = objectDefine.getObjectName();
            boolean skipSynonym = ObjectType.SYNONYM.getName().equals(objectType) && !this.whiteListMap.containsKey((Object)ObjectType.SYNONYM);
            boolean bl = skipPublicSynonym = ObjectType.PUBLIC_SYNONYM.getName().equals(objectType) && !this.whiteListMap.containsKey((Object)ObjectType.PUBLIC_SYNONYM);
            if (skipSynonym || skipPublicSynonym) continue;
            StringBuilder sb = new StringBuilder(256);
            if (this.droppable) {
                sb.append(this.assembleDropStatement(dbType, objectName));
            }
            if (isPlSql = ObjectType.isPlSql(objectType)) {
                sb.append("DELIMITER ").append(this.plDelimiter).append("\n");
            }
            sb.append(objectDefine.getObjectGrammar());
            int objectCount = 1;
            List<ObjectDefine> subObjectDefines = objectDefine.getSubObjectDefines();
            if (CollectionUtils.isNotEmpty(subObjectDefines)) {
                objectCount += subObjectDefines.size();
                for (ObjectDefine subObjectDefine : subObjectDefines) {
                    sb.append("\n").append(subObjectDefine.getObjectGrammar());
                }
            }
            if (isPlSql) {
                sb.append("\n").append(this.plDelimiter);
            }
            objectName = DBUtils.extractObjectName(objectName, null);
            if (!this.schemaless) {
                String schemaPrefix1 = this.schemaName + ".";
                String schemaPrefix2 = this.serverMode.wrapName(this.schemaName) + ".";
                if (objectName.startsWith(schemaPrefix1)) {
                    objectName = objectName.substring(schemaPrefix1.length()).trim();
                } else if (objectName.startsWith(schemaPrefix2)) {
                    objectName = objectName.substring(schemaPrefix2.length()).trim();
                }
            }
            String fileName = StringUtils.isNotEmpty(this.specifiedFileName) ? this.specifiedFileName : objectName + "-schema.sql";
            String string = filePath = this.noNestedDir ? FileUtils.toPath(this.outputPath, fileName) : FileUtils.toPath(this.outputPath, objectType, fileName);
            if (new File(filePath).exists()) {
                String[] extensions = new String[]{DataFormat.DDL.getDefaultExtension()};
                for (File existsFile : FileUtils.listFiles((File)new File(this.outputPath), (String[])extensions, (boolean)true)) {
                    if (!existsFile.getName().equals(fileName)) continue;
                    log.info("File: \"{}\" is already exists, skip to generate a new one...", (Object)filePath);
                    continue block0;
                }
                String existsFileName = fileName.toLowerCase(Locale.getDefault());
                long identicalNo = this.identicalNoMap.computeIfAbsent(existsFileName, v -> new AtomicLong(0L)).incrementAndGet();
                fileName = objectName + "_ob_identical_" + identicalNo + "-schema.sql";
                filePath = this.noNestedDir ? FileUtils.toPath(this.outputPath, fileName) : FileUtils.toPath(this.outputPath, objectType, fileName);
            }
            FileUtils.write((File)new File(filePath), (CharSequence)sb, (String)this.fileEncoding, (boolean)false);
            this.uploadIfNeeded(filePath);
            this.objectStatusList.add(new ObjectStatus(objectType, this.schemaName, objectName, objectCount));
            log.info("Dump [{}] {} to \"{} \" finished", new Object[]{objectType, objectName, filePath});
        }
    }

    protected void uploadIfNeeded(String file) throws Exception {
        if (this.fileUploader != null) {
            this.fileUploader.upload(new File(file));
        }
    }

    @Override
    protected void updateTaskDetail() {
        this.taskDetail.setSchema(this.schemaName);
        this.taskDetail.setObject(this.objectName);
        this.taskDetail.setType(this.objectType);
        this.taskDetail.setState(this.taskState);
        this.taskDetail.setError(this.message);
        this.taskDetail.setCount(this.recordCount);
        this.taskDetail.setTaskType(TaskType.DUMP_SCHEMA);
        this.taskDetail.getObjectStatusList().addAll(this.objectStatusList);
    }

    private String assembleDropStatement(DbType dbType, String objectName) {
        return "drop " + this.objectType + (dbType.isMySqlType() ? " if exists " : " ") + this.serverMode.wrapName(objectName) + ";\n";
    }

    public Map<ObjectType, Set<String>> getBlackListMap() {
        return this.blackListMap;
    }

    public Map<ObjectType, Set<String>> getWhiteListMap() {
        return this.whiteListMap;
    }

    public void setSchemaless(boolean schemaless) {
        this.schemaless = schemaless;
    }

    public void setWithExtra(boolean withExtra) {
        this.withExtra = withExtra;
    }

    public FileUploader getFileUploader() {
        return this.fileUploader;
    }

    public void setFileUploader(FileUploader fileUploader) {
        this.fileUploader = fileUploader;
    }
}

