/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.translator;

import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.dumper.translator.AbstractRecordTranslator;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.parser.record.pos.Offset;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public class PosRecordTranslator
extends AbstractRecordTranslator<StringBuilder> {
    private final List<Offset> offsets;
    private final String lineSep;
    private final Charset charset;

    public PosRecordTranslator(TableInfo tableInfo, ControlManager ctrlManager, String lineSep, String charset) {
        super(tableInfo, ctrlManager);
        this.offsets = this.controlManager.getOffsets(tableInfo.getSchema(), tableInfo.getTable());
        this.lineSep = lineSep;
        this.charset = Charset.forName(charset);
    }

    @Override
    protected StringBuilder buildRecordPattern(int columnCount) {
        return new StringBuilder();
    }

    @Override
    protected StringBuilder formatRecord(StringBuilder recordPattern, String columnValue, int index, boolean hasNext) {
        int len = this.offsets.get(index).getLength();
        return recordPattern.append(this.formatFixedLengthString(columnValue, len));
    }

    @Override
    protected StringBuilder appendLineSeparator(StringBuilder record) {
        return record.append(this.lineSep);
    }

    private String formatFixedLengthString(String input, int length) {
        if (input == null) {
            byte[] bytes = new byte[length];
            Arrays.fill(bytes, (byte)32);
            return new String(bytes, this.charset);
        }
        byte[] inputBytes = input.getBytes(this.charset);
        if (inputBytes.length > length) {
            byte[] truncatedBytes = new byte[length];
            System.arraycopy(inputBytes, 0, truncatedBytes, 0, length);
            return new String(truncatedBytes, this.charset);
        }
        byte[] resultBytes = new byte[length];
        System.arraycopy(inputBytes, 0, resultBytes, 0, inputBytes.length);
        for (int i = inputBytes.length; i < length; ++i) {
            resultBytes[i] = 32;
        }
        return new String(resultBytes, this.charset);
    }
}

