/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.factory;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.OssStorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.S3StorageConfig;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public class ClientFactory {
    public static OSS createOssClient(OssStorageConfig config) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(config.getBucket()), (Object)"Oss bucket name is null");
        return new OSSClientBuilder().build(config.getEndpoint(), config.getAccessKey(), config.getSecretKey());
    }

    public static AmazonS3 createS3Client(S3StorageConfig config) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(config.getBucket()), (Object)"S3 bucket name is null");
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(config.getAccessKey(), config.getSecretKey())));
        if (StringUtils.isNotBlank(config.getEndpoint())) {
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(config.getEndpoint(), config.getRegion()));
        } else {
            builder.withRegion(config.getRegion());
        }
        return (AmazonS3)builder.build();
    }

    public static TransferManager createS3TransferManager(S3StorageConfig config) {
        return TransferManagerBuilder.standard().withS3Client(ClientFactory.createS3Client(config)).build();
    }
}

