/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.factory;

import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.storage.BaseStorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.OssStorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.S3StorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.hdfs.HdfsStorageConfig;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriterV2;
import com.oceanbase.tools.loaddump.writer.file.hdfs.HdfsCsvFileWriter;
import com.oceanbase.tools.loaddump.writer.file.hdfs.HdfsFlatFileWriter;
import com.oceanbase.tools.loaddump.writer.file.hdfs.HdfsSqlFileWriter;
import com.oceanbase.tools.loaddump.writer.file.local.CsvFileWriter;
import com.oceanbase.tools.loaddump.writer.file.local.FlatFileWriterV2;
import com.oceanbase.tools.loaddump.writer.file.local.OrcFileWriterV2;
import com.oceanbase.tools.loaddump.writer.file.local.ParquetFileWriterV2;
import com.oceanbase.tools.loaddump.writer.file.local.SqlFileWriter;
import com.oceanbase.tools.loaddump.writer.file.oss.OssCsvFileWriter;
import com.oceanbase.tools.loaddump.writer.file.oss.OssFlatFileWriter;
import com.oceanbase.tools.loaddump.writer.file.oss.OssRollingUploadWriter;
import com.oceanbase.tools.loaddump.writer.file.oss.OssSqlFileWriter;
import com.oceanbase.tools.loaddump.writer.file.s3.S3RollingUploadWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWriterManager {
    private static final Logger log = LoggerFactory.getLogger(FileWriterManager.class);
    HashMap<String, AbstractRollingFileWriterV2> instances;
    String filePath;
    String fileName;
    String fileSuffix;
    String fileEncoding;
    long blockSize;
    int blockRow;
    DataFormat dataFormat;
    BaseStorageConfig storageConfig;
    int commitSize;
    boolean enableParallelWrite;
    AtomicLong groupNoAdder;

    private FileWriterManager() {
    }

    public AbstractRollingFileWriterV2 getFileWriter(String tableName, Map<String, Object> colMap, int participant) throws Exception {
        String realFileName;
        String string = realFileName = this.fileName == null ? tableName : this.fileName;
        if (this.enableParallelWrite) {
            return this.createNewFileWriter(tableName, realFileName + "." + this.groupNoAdder.incrementAndGet(), colMap, 1);
        }
        return this.instances.computeIfAbsent(tableName, t -> this.createNewFileWriter((String)t, realFileName, colMap, participant));
    }

    private AbstractRollingFileWriterV2 createNewFileWriter(String tableName, String fileName, Map<String, Object> colMap, int participant) {
        boolean nonUpload;
        AbstractRollingFileWriterV2.Builder builder;
        switch (this.dataFormat) {
            case ORC: {
                if (this.storageConfig != null && this.storageConfig.getStorageType() == StorageType.HADOOP_HDFS) {
                    builder = new OrcFileWriterV2.Builder().columnTypeMap(colMap).conf(this.storageConfig.getHadoopConfiguration());
                    break;
                }
                builder = new OrcFileWriterV2.Builder().columnTypeMap(colMap);
                break;
            }
            case PAR: {
                if (this.storageConfig != null && this.storageConfig.getStorageType() == StorageType.HADOOP_HDFS) {
                    builder = new ParquetFileWriterV2.Builder().conf(this.storageConfig.getHadoopConfiguration()).columnTypeMap(tableName, colMap);
                    break;
                }
                builder = new ParquetFileWriterV2.Builder().columnTypeMap(tableName, colMap);
                break;
            }
            case CSV: {
                if (this.storageConfig != null && this.storageConfig.getStorageType() == StorageType.ALIYUN_OSS) {
                    builder = new OssCsvFileWriter.Builder().storageConfig((OssStorageConfig)this.storageConfig).fileEncoding(this.fileEncoding);
                    break;
                }
                if (this.storageConfig != null && this.storageConfig.getStorageType() == StorageType.HADOOP_HDFS) {
                    builder = new HdfsCsvFileWriter.Builder().storageConfig((HdfsStorageConfig)this.storageConfig).fileEncoding(this.fileEncoding);
                    break;
                }
                builder = new CsvFileWriter.Builder().fileEncoding(this.fileEncoding);
                break;
            }
            case SQL: {
                if (this.storageConfig != null && this.storageConfig.getStorageType() == StorageType.ALIYUN_OSS) {
                    builder = new OssSqlFileWriter.Builder().commitSize(this.commitSize).fileEncoding(this.fileEncoding).storageConfig((OssStorageConfig)this.storageConfig);
                    break;
                }
                if (this.storageConfig != null && this.storageConfig.getStorageType() == StorageType.HADOOP_HDFS) {
                    builder = new HdfsSqlFileWriter.Builder().commitSize(this.commitSize).storageConfig((HdfsStorageConfig)this.storageConfig).fileEncoding(this.fileEncoding);
                    break;
                }
                builder = new SqlFileWriter.Builder().commitSize(this.commitSize).fileEncoding(this.fileEncoding);
                break;
            }
            default: {
                builder = this.storageConfig != null && this.storageConfig.getStorageType() == StorageType.ALIYUN_OSS ? new OssFlatFileWriter.Builder().storageConfig((OssStorageConfig)this.storageConfig).fileEncoding(this.fileEncoding) : (this.storageConfig != null && this.storageConfig.getStorageType() == StorageType.HADOOP_HDFS ? new HdfsFlatFileWriter.Builder().storageConfig((HdfsStorageConfig)this.storageConfig).fileEncoding(this.fileEncoding) : new FlatFileWriterV2.Builder().fileEncoding(this.fileEncoding));
            }
        }
        AbstractRollingFileWriterV2 localFileWriter = builder.filePath(this.filePath).fileName(fileName).participant(participant).fileSuffix(this.fileSuffix).blockRow(this.blockRow).blockSize(this.blockSize).build();
        boolean bl = nonUpload = this.storageConfig == null || this.storageConfig.getStorageType() == StorageType.HADOOP_HDFS || this.storageConfig.getStorageType() == StorageType.ALIYUN_OSS && !this.dataFormat.isColumnOrientedFormat();
        if (nonUpload) {
            return localFileWriter;
        }
        if (this.storageConfig.getStorageType() == StorageType.ALIYUN_OSS) {
            return new OssRollingUploadWriter(localFileWriter, (OssStorageConfig)this.storageConfig);
        }
        if (this.storageConfig.getStorageType() == StorageType.AMAZON_S3) {
            return new S3RollingUploadWriter(localFileWriter, (S3StorageConfig)this.storageConfig);
        }
        throw new IllegalStateException("Unknown storage type: " + (Object)((Object)this.storageConfig.getStorageType()));
    }

    public void close() {
        if (this.instances == null) {
            return;
        }
        this.instances.values().forEach(afw -> {
            try {
                afw.close();
            }
            catch (Exception e) {
                log.warn("Close file writer failed. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
            }
        });
        this.instances.clear();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String filePath;
        String fileName;
        String fileSuffix;
        String fileEncoding;
        long blockSize;
        String blockSizeUnit;
        DataFormat dataFormat;
        int commitSize;
        BaseStorageConfig storageConfig;

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder fileSuffix(String fileSuffix) {
            this.fileSuffix = fileSuffix;
            return this;
        }

        public Builder fileEncoding(String fileEncoding) {
            this.fileEncoding = fileEncoding;
            return this;
        }

        public Builder blockSize(long blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Builder blockSizeUnit(String blockSizeUnit) {
            this.blockSizeUnit = blockSizeUnit;
            return this;
        }

        public Builder commitSize(int commitSize) {
            this.commitSize = commitSize;
            return this;
        }

        public Builder storageConfig(BaseStorageConfig storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        public FileWriterManager build() {
            FileWriterManager fwf = new FileWriterManager();
            fwf.filePath = this.filePath;
            fwf.fileName = this.fileName;
            fwf.fileSuffix = this.fileSuffix;
            fwf.fileEncoding = this.fileEncoding;
            fwf.dataFormat = this.dataFormat;
            fwf.commitSize = this.commitSize;
            fwf.storageConfig = this.storageConfig;
            if (JvmArgs.enableParallelWrite != null) {
                fwf.enableParallelWrite = JvmArgs.enableParallelWrite;
            } else {
                boolean bl = fwf.enableParallelWrite = this.dataFormat == DataFormat.PAR || this.dataFormat == DataFormat.ORC;
            }
            if (fwf.enableParallelWrite) {
                fwf.groupNoAdder = new AtomicLong(0L);
            } else {
                fwf.instances = new HashMap();
            }
            if ("ROW".equals(this.blockSizeUnit)) {
                fwf.blockRow = (int)this.blockSize;
            } else if ("MB".equals(this.blockSizeUnit)) {
                fwf.blockSize = this.blockSize;
            } else {
                throw new IllegalStateException("Unexpected block size unit: " + this.blockSizeUnit);
            }
            return fwf;
        }
    }
}

