/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.factory;

import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.StorageUri;
import com.oceanbase.tools.loaddump.common.model.storage.BaseStorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.OssStorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.S3StorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.hdfs.HdfsStorageConfig;
import com.oceanbase.tools.loaddump.decrypt.SecureContent;
import java.util.HashMap;

public class StorageConfigFactory {
    public static BaseStorageConfig createStorageConfig(String uri, SecureContent secureContent) {
        StorageUri storageUri = StorageUri.fromString(uri);
        String scheme = storageUri.getScheme();
        HashMap<String, String> uriParams = storageUri.getParameters();
        StorageType storageType = StorageType.of(scheme);
        BaseStorageConfig config = null;
        if (storageType.isCloudStorageType()) {
            if (StorageType.AMAZON_S3 == storageType) {
                config = S3StorageConfig.builder().region(uriParams.get(StorageUri.UriParams.REGION_KEY.getName())).storageClass(uriParams.get(StorageUri.UriParams.STORAGE_CLASS_KEY.getName())).endpoint(uriParams.get(StorageUri.UriParams.ENDPOINT_KEY.getName())).accessKey(uriParams.getOrDefault(StorageUri.UriParams.ACCESS_KEY.getName(), secureContent.getAccessKey())).secretKey(uriParams.getOrDefault(StorageUri.UriParams.SECRET_KEY.getName(), secureContent.getSecretKey())).bucket(storageUri.getContainer()).path(storageUri.getPath()).build();
            } else if (StorageType.ALIYUN_OSS == storageType) {
                config = OssStorageConfig.builder().endpoint(uriParams.get(StorageUri.UriParams.ENDPOINT_KEY.getName())).accessKey(uriParams.getOrDefault(StorageUri.UriParams.ACCESS_KEY.getName(), secureContent.getAccessKey())).secretKey(uriParams.getOrDefault(StorageUri.UriParams.SECRET_KEY.getName(), secureContent.getSecretKey())).bucket(storageUri.getContainer()).path(storageUri.getPath()).build();
            }
        } else if (StorageType.HADOOP_HDFS == storageType) {
            config = HdfsStorageConfig.builder().authority(storageUri.getContainer()).user(uriParams.get(StorageUri.UriParams.HDFS_PRINCIPAL_KEY.getName())).keytabFile(uriParams.get(StorageUri.UriParams.HDFS_KEYTAB_PATH_KEY.getName())).hdfsUri(storageUri.getUriWithoutParam()).hdfsSiteFile(uriParams.get(StorageUri.UriParams.HDFS_SITE_FILE.getName())).coreSiteFile(uriParams.get(StorageUri.UriParams.CORE_SITE_FILE.getName())).krb5ConfFile(uriParams.get(StorageUri.UriParams.KRB5_CONF_FILE.getName())).path(storageUri.getPath()).build();
        } else {
            throw new IllegalArgumentException("Unsupported storage type: " + (Object)((Object)storageType));
        }
        return config;
    }
}

