/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.crypto;

import com.oceanbase.tools.loaddump.function.AbstractBuiltinFunction;
import java.util.Base64;

public abstract class AbstractCryptoFunction
extends AbstractBuiltinFunction {
    protected final byte[] key;
    protected final TextEncoding encoding;

    public AbstractCryptoFunction(String key, String encoding) {
        this.key = Base64.getDecoder().decode(key);
        this.encoding = TextEncoding.of(encoding);
    }

    public AbstractCryptoFunction(String key) {
        this.key = Base64.getDecoder().decode(key);
        this.encoding = TextEncoding.BASE64;
    }

    public static enum TextEncoding {
        BASE64,
        HEX;


        static TextEncoding of(String encoding) {
            for (TextEncoding e : TextEncoding.values()) {
                if (!e.name().equalsIgnoreCase(encoding)) continue;
                return e;
            }
            throw new IllegalArgumentException(encoding + " is not a supported encoding");
        }
    }
}

