/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.crypto.sm4;

import com.oceanbase.tools.loaddump.function.crypto.AbstractCryptoFunction;
import com.oceanbase.tools.loaddump.function.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.utils.CryptoUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.Base64;
import org.apache.commons.codec.binary.Hex;

public class SM4EncryptFunction
extends AbstractCryptoFunction {
    public SM4EncryptFunction(String key, String encoding) {
        super(key, encoding);
    }

    public SM4EncryptFunction(String key) {
        super(key);
    }

    @Override
    public String getName() {
        return SqlFunctions.SM4_ENCRYPT.name();
    }

    @Override
    public String invoke(String ... varargs) {
        String val = varargs[0];
        if (StringUtils.isEmpty(val)) {
            return val;
        }
        try {
            byte[] res = CryptoUtils.encryptSM4(val.getBytes(), this.key);
            if (this.encoding == AbstractCryptoFunction.TextEncoding.BASE64) {
                return Base64.getEncoder().encodeToString(res);
            }
            return Hex.encodeHexString((byte[])res);
        }
        catch (Exception e) {
            throw new RuntimeException("SM4 encryption failed.", e);
        }
    }
}

