/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.date;

import com.oceanbase.tools.loaddump.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.function.enums.SqlFunctions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToTimestampFunction
extends AbstractBuiltinFunction {
    private static final Logger log = LoggerFactory.getLogger(ToTimestampFunction.class);
    protected final String originPattern;
    protected final String targetPattern;

    public ToTimestampFunction(String originPattern) {
        this(originPattern, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public ToTimestampFunction(String originPattern, String targetPattern) {
        this.originPattern = originPattern;
        this.targetPattern = targetPattern;
    }

    @Override
    public String getName() {
        return SqlFunctions.TO_TIMESTAMP.name();
    }

    @Override
    public String invoke(String ... varargs) {
        return this.toTimestamp(varargs == null ? null : varargs[0]);
    }

    private String toTimestamp(String value) {
        if (value == null) {
            return null;
        }
        try {
            String[] parsePatterns = new String[]{this.originPattern};
            Date date = DateUtils.parseDate((String)value.trim(), (String[])parsePatterns);
            return new SimpleDateFormat(this.targetPattern).format(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getOriginPattern() {
        return this.originPattern;
    }

    public String getTargetPattern() {
        return this.targetPattern;
    }
}

