/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.generator;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.partition.calculator.enums.ObPartLevel;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.metadata.desc.ObTablePart;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.Hint;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProvider;
import com.oceanbase.tools.loaddump.common.model.Database;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.Pair;
import com.oceanbase.tools.loaddump.common.model.RangeKey;
import com.oceanbase.tools.loaddump.common.model.RowKey;
import com.oceanbase.tools.loaddump.common.model.TableEntryInfo;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TableRangeInfo;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.dumper.assembler.ObMySqlStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.assembler.ObOracleStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.task.record.RecordDumpTask;
import com.oceanbase.tools.loaddump.generator.AbstractDumpTaskGenerator;
import com.oceanbase.tools.loaddump.mybatis.type.TypeHandler;
import com.oceanbase.tools.loaddump.utils.ArrayUtils;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordDumpTaskGenerator
extends AbstractDumpTaskGenerator<RecordDumpTask> {
    private static final Logger log = LoggerFactory.getLogger(RecordDumpTaskGenerator.class);
    protected long pageSize;
    protected boolean snapshot;
    protected boolean distinct;
    protected boolean enableHiddenPk;
    protected long dataVersion;
    protected int parallelMacros;
    protected Database database;
    protected Set<String> specifiedParts;
    protected String flashbackScn;
    protected String flashbackTimestamp;
    protected MetadataProvider metadataProvider;
    protected Map<String, TableEntryInfo> tableEntryInfoMap;
    private final Cache<String, String> pstmtCache = CacheBuilder.newBuilder().initialCapacity(64).maximumSize(512L).softValues().concurrencyLevel(256).expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public RecordDumpTaskGenerator(DumpParameter parameter) {
        super(parameter);
        this.distinct = parameter.isDistinct();
        this.snapshot = parameter.isSnapshot();
        this.pageSize = parameter.getPageSize();
        this.enableHiddenPk = parameter.isEnableHiddenPk();
        this.database = parameter.getDatabase();
        this.flashbackScn = parameter.getFlashbackScn();
        this.specifiedParts = parameter.getPartitions();
        this.flashbackTimestamp = parameter.getFlashbackTimestamp();
        this.parallelMacros = Math.min(parameter.getParallelMacros(), 50);
    }

    private List<RecordDumpTask> generateDumpTaskForPublicCloud() {
        log.info("Generating sub-tasks by partitions and primary/unique keys...");
        if (StringUtils.isNotEmpty(this.parameter.getQuerySql()) || this.parameter.isLogicalDatabase()) {
            String tableName = CollectionUtils.isEmpty(this.database.getTableNames()) ? "CUSTOM_SQL" : this.database.getTableNames().get(0);
            return Lists.newArrayList((Object[])new RecordDumpTask[]{new RecordDumpTask(tableName, this.getBasicStatementAssembler())});
        }
        Set<Map.Entry<String, TableEntryInfo>> tableEntryInfoMapCopies = this.tableEntryInfoMap.entrySet();
        ArrayList<RecordDumpTask> dumpTasks = new ArrayList<RecordDumpTask>(tableEntryInfoMapCopies.size());
        Iterator iter = tableEntryInfoMapCopies.iterator();
        while (iter.hasNext()) {
            String tableName = (String)((Map.Entry)iter.next()).getKey();
            if (!this.tableEntryInfoMap.get(tableName).isEmptyTable()) continue;
            dumpTasks.add(new RecordDumpTask(true, tableName, this.getBasicStatementAssembler()));
            iter.remove();
        }
        ExecutorTemplate<List> template = new ExecutorTemplate<List>("generate-dump-tasks-in-public-cloud-");
        for (Map.Entry entry : tableEntryInfoMapCopies) {
            TableEntryInfo tableEntryInfo;
            String tableName = (String)entry.getKey();
            List<String> partNames = this.filterSpecifiedPartitionNames(tableName, (tableEntryInfo = (TableEntryInfo)entry.getValue()).getTableEntry());
            boolean isPartNameNotExists = CollectionUtils.isEmpty(partNames);
            int size = isPartNameNotExists ? 0 : partNames.size() - 1;
            for (int i = 0; i <= size; ++i) {
                String partName = isPartNameNotExists ? null : partNames.get(i);
                template.submit(() -> {
                    List<TableRangeInfo> tableRangeInfoList = this.splitTableRows(tableName, partName);
                    ArrayList<RecordDumpTask> tempTasks = new ArrayList<RecordDumpTask>(tableRangeInfoList.size());
                    for (TableRangeInfo tableRangeInfo : tableRangeInfoList) {
                        if (this.oracleMode) {
                            tempTasks.add(new RecordDumpTask(tableName, new ObOracleStatementAssembler(tableRangeInfo, this.parameter, this.dataVersion)));
                            continue;
                        }
                        tempTasks.add(new RecordDumpTask(tableName, new ObMySqlStatementAssembler(tableRangeInfo, this.parameter, this.dataVersion)));
                    }
                    return tempTasks;
                });
            }
        }
        dumpTasks.addAll(template.waitForResult().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        return dumpTasks;
    }

    private List<RecordDumpTask> generateDumpTaskForPrivateCloud() {
        log.info("Generating sub-tasks by partitions and primary/unique keys...");
        if (StringUtils.isNotEmpty(this.parameter.getQuerySql())) {
            String tableName = CollectionUtils.isEmpty(this.database.getTableNames()) ? "CUSTOM_SQL" : this.database.getTableNames().get(0);
            return Lists.newArrayList((Object[])new RecordDumpTask[]{new RecordDumpTask(tableName, this.getBasicStatementAssembler())});
        }
        Set<Map.Entry<String, TableEntryInfo>> tableEntryInfoMapCopies = this.tableEntryInfoMap.entrySet();
        ArrayList<RecordDumpTask> dumpTasks = new ArrayList<RecordDumpTask>(tableEntryInfoMapCopies.size());
        Iterator iter = tableEntryInfoMapCopies.iterator();
        while (iter.hasNext()) {
            String tableName = (String)((Map.Entry)iter.next()).getKey();
            if (!this.tableEntryInfoMap.get(tableName).isEmptyTable()) continue;
            dumpTasks.add(new RecordDumpTask(true, tableName, this.getBasicStatementAssembler()));
            iter.remove();
        }
        boolean isPreviousV4 = this.serverMode.isPreviousV4();
        ExecutorTemplate<List> template = new ExecutorTemplate<List>("generate-dump-tasks-in-private-cloud-");
        for (Map.Entry entry : tableEntryInfoMapCopies) {
            TableEntryInfo tableEntryInfo;
            String tableName = (String)entry.getKey();
            List<String> partNames = this.filterSpecifiedPartitionNames(tableName, (tableEntryInfo = (TableEntryInfo)entry.getValue()).getTableEntry());
            boolean isPartNameNotExists = CollectionUtils.isEmpty(partNames);
            int size = isPartNameNotExists ? 0 : partNames.size() - 1;
            for (int i = 0; i <= size; ++i) {
                String partName = isPartNameNotExists ? null : partNames.get(i);
                template.submit(() -> {
                    if (isPreviousV4 && this.dataVersion > 0L && tableEntryInfo.getTableEntry() != null) {
                        return this.generateDumpTaskForSnapshot(tableName);
                    }
                    List<TableRangeInfo> taskRangeInfoList = this.splitTableRows(tableName, partName);
                    ArrayList<RecordDumpTask> tempTasks = new ArrayList<RecordDumpTask>(taskRangeInfoList.size());
                    for (TableRangeInfo tableRangeInfo : taskRangeInfoList) {
                        if (this.oracleMode) {
                            tempTasks.add(new RecordDumpTask(tableName, new ObOracleStatementAssembler(tableRangeInfo, this.parameter, this.dataVersion)));
                            continue;
                        }
                        tempTasks.add(new RecordDumpTask(tableName, new ObMySqlStatementAssembler(tableRangeInfo, this.parameter, this.dataVersion)));
                    }
                    return tempTasks;
                });
            }
        }
        dumpTasks.addAll(template.waitForResult().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        return dumpTasks;
    }

    private List<RecordDumpTask> generateDumpTaskForSnapshot(String tableName) throws Exception {
        List<RowKey> validRowKeys;
        TableEntryInfo tableEntryInfo = this.tableEntryInfoMap.get(tableName);
        TableEntry tableEntry = tableEntryInfo.getTableEntry();
        Long tableId = tableEntry.getTableId();
        String tenant = tableEntry.getTenantName();
        List<RowKey> rowKeys = this.metadataProvider.queryRowKeys(this.serverMode, tenant, tableId);
        if (CollectionUtils.isEmpty(rowKeys)) {
            log.warn("Row keys are not exists. Maybe some errors occurred during query row keys. Use select /* +frozen_version({}) */ instead.", (Object)this.dataVersion);
        }
        if (CollectionUtils.isEmpty(validRowKeys = rowKeys.stream().filter(e -> !Constants.HIDDEN_KEYS.contains(e.getColumn())).collect(Collectors.toList()))) {
            log.warn("No valid row keys can be used. Maybe the non-partitioned table: \"{}\" has no primary key. Use select /* +frozen_version({}) */ instead.", (Object)tableName, (Object)this.dataVersion);
            if (this.oracleMode) {
                return Lists.newArrayList((Object[])new RecordDumpTask[]{new RecordDumpTask(tableName, new ObOracleStatementAssembler(new TableRangeInfo(tableName), this.parameter, this.dataVersion))});
            }
            return Lists.newArrayList((Object[])new RecordDumpTask[]{new RecordDumpTask(tableName, new ObMySqlStatementAssembler(new TableRangeInfo(tableName), this.parameter, this.dataVersion))});
        }
        Map<Long, List<String>> macroRangeMap = this.metadataProvider.queryMacroRangeMap(tableEntryInfo.getLeaderMap(), tableId, this.dataVersion);
        boolean nonPartitioned = tableEntry.isNonPartitionTable();
        Map partIdNameMap = tableEntry.getPartIdNameMap();
        HashMap<String, List<String>> macroRangeListMap = new HashMap<String, List<String>>(64);
        for (Long partitionId : macroRangeMap.keySet()) {
            if (nonPartitioned) {
                macroRangeListMap.putIfAbsent(null, macroRangeMap.get(partitionId));
                continue;
            }
            for (String string : (Set)partIdNameMap.get(partitionId)) {
                if (!this.isPartitionInclude(string)) continue;
                macroRangeListMap.putIfAbsent(string, new ArrayList());
                ((List)macroRangeListMap.get(string)).addAll((Collection)macroRangeMap.get(partitionId));
            }
        }
        if (MapUtils.isEmpty(macroRangeListMap)) {
            return Lists.newArrayList((Object[])new RecordDumpTask[]{new RecordDumpTask(true, tableName, this.getBasicStatementAssembler())});
        }
        String rowKeyString = this.getRowKeyString(validRowKeys);
        ArrayList<RecordDumpTask> tasks = new ArrayList<RecordDumpTask>(1024);
        for (Map.Entry entry : macroRangeListMap.entrySet()) {
            List macroGroups = Lists.partition((List)((List)entry.getValue()), (int)this.parallelMacros);
            for (List macroGroup : macroGroups) {
                List<Pair<RangeKey[], RangeKey[]>> macroRangeList = this.parseMacroRange(macroGroup, rowKeys, validRowKeys.size());
                TableRangeInfo tableRangeInfo = new TableRangeInfo(tableName, macroRangeList, rowKeyString, (String)entry.getKey());
                if (this.oracleMode) {
                    tasks.add(new RecordDumpTask(tableName, new ObOracleStatementAssembler(tableRangeInfo, this.parameter, this.dataVersion)));
                    continue;
                }
                tasks.add(new RecordDumpTask(tableName, new ObMySqlStatementAssembler(tableRangeInfo, this.parameter, this.dataVersion)));
            }
        }
        return tasks;
    }

    protected List<TableRangeInfo> splitTableRows(String tableName, String partName) throws Exception {
        String partitionedFlag;
        boolean isPartNameNotExists = StringUtils.isBlank(partName);
        String string = partitionedFlag = isPartNameNotExists ? "non-partitioned table" : "partitioned table";
        if (CollectionUtils.isEmpty(this.tableEntryInfoMap.get(tableName).getSplitKeyColumns())) {
            if (isPartNameNotExists) {
                log.info("Split rows for {}(without primary key): \"{}\" success. Ranges: 1", (Object)partitionedFlag, (Object)tableName);
                return Lists.newArrayList((Object[])new TableRangeInfo[]{new TableRangeInfo(tableName)});
            }
            log.info("Split rows for {}(without primary key): \"{}\" partition: \"{}\" success. Ranges: 1", new Object[]{partitionedFlag, tableName, partName});
            return Lists.newArrayList((Object[])new TableRangeInfo[]{new TableRangeInfo(tableName, partName)});
        }
        try {
            List<TableRangeInfo> bounds = null;
            Stopwatch stopwatch = Stopwatch.createStarted();
            if (isPartNameNotExists) {
                bounds = this.queryBounds(tableName, null);
                log.info("Split rows for {}(with primary key): \"{}\" success. Ranges: {}. Elapsed: {}", new Object[]{partitionedFlag, tableName, bounds.size(), stopwatch});
            } else {
                bounds = this.queryBounds(tableName, partName);
                log.info("Split rows for {}(with primary key): \"{}\" partition: \"{}\" success. Ranges: {}. Elapsed: {}", new Object[]{partitionedFlag, tableName, partName, bounds.size(), stopwatch});
            }
            return bounds;
        }
        catch (Exception e) {
            log.error("Split rows for {}(with primary key): \"{}\" failed. Reason: {}", new Object[]{partitionedFlag, tableName, ExceptionUtils.getRootCauseMessage(e)});
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<TableRangeInfo> queryBounds(String tableName, String partName) throws Exception {
        isNonPartitioned = StringUtils.isEmpty(partName);
        partitionedFlag = isNonPartitioned != false ? "non-partitioned table" : "partitioned table";
        successFlag = isNonPartitioned != false ? "success" : "partition: \"" + partName + "\" success";
        splitKeyCols = this.tableEntryInfoMap.get(tableName).getSplitKeyColumns();
        primaryKeyColumnSize = splitKeyCols.size();
        bounds = Lists.newArrayList();
        conn = this.connectionKey.getSessionManager().getPooledBizConnection();
        var10_10 = null;
        try {
            tableInfo = this.database.getTableInfoMap().get(tableName);
            primaryCols = splitKeyCols.stream().map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$queryBounds$3(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((RecordDumpTaskGenerator)this)).collect(Collectors.joining(","));
            descPriCols = null;
            if (this.oracleMode) {
                descPriCols = splitKeyCols.stream().map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$queryBounds$4(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((RecordDumpTaskGenerator)this)).collect(Collectors.joining(","));
            }
            preBound = null;
            curBound = null;
            typeHandlers = splitKeyCols.stream().map((Function<String, TypeHandler>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getTypeHandler(java.lang.String ), (Ljava/lang/String;)Lcom/oceanbase/tools/loaddump/mybatis/type/TypeHandler;)((TableInfo)tableInfo)).collect(Collectors.toList());
            while (true) {
                block65: {
                    block66: {
                        try {
                            block62: {
                                if (curBound != null) {
                                    preBound = preBound == null ? new RangeKey[primaryKeyColumnSize] : preBound;
                                    System.arraycopy(curBound, 0, preBound, 0, curBound.length);
                                }
                                sql = this.buildSelectBoundSql(tableInfo.getSchemaTable(), partName, primaryCols, descPriCols, preBound);
                                ps = conn.prepareStatement(sql, 1003, 1007);
                                var19_22 = null;
                                try {
                                    block60: {
                                        block61: {
                                            ps.setFetchSize(-2147483648);
                                            if (preBound != null) {
                                                for (i = 0; i < preBound.length; ++i) {
                                                    ps.setObject(i + 1, preBound[i].getValue());
                                                }
                                            }
                                            rs = ps.executeQuery();
                                            var21_27 = null;
                                            try {
                                                if (!rs.next()) {
                                                    rangeList = preBound == null ? null : Lists.newArrayList((Object[])new Pair[]{Pair.of(preBound, new RangeKey[0])});
                                                    bounds.add(new TableRangeInfo(tableName, rangeList, primaryCols, partName));
                                                    if (RecordDumpTaskGenerator.log.isDebugEnabled()) {
                                                        RecordDumpTaskGenerator.log.debug("....Splitting rows for {}: \"{}\" {}. Batch: {}", new Object[]{partitionedFlag, tableName, successFlag, bounds.size()});
                                                    }
                                                    if (rs == null) break block60;
                                                    if (var21_27 == null) break block61;
                                                }
                                                ** GOTO lbl-1000
                                            }
                                            catch (Throwable var22_31) {
                                                try {
                                                    var21_27 = var22_31;
                                                    throw var22_31;
                                                }
                                                catch (Throwable var26_41) {
                                                    if (rs == null) throw var26_41;
                                                    if (var21_27 == null) {
                                                        rs.close();
                                                        throw var26_41;
                                                    }
                                                    try {
                                                        rs.close();
                                                        throw var26_41;
                                                    }
                                                    catch (Throwable var27_42) {
                                                        var21_27.addSuppressed(var27_42);
                                                        throw var26_41;
                                                    }
                                                }
                                            }
                                            try {
                                                rs.close();
                                            }
                                            catch (Throwable var23_34) {
                                                var21_27.addSuppressed(var23_34);
                                            }
                                            break block60;
                                        }
                                        rs.close();
                                    }
                                    if (ps == null) break;
                                    if (var19_22 == null) break block62;
                                }
                                catch (Throwable var20_26) {
                                    try {
                                        var19_22 = var20_26;
                                        throw var20_26;
                                    }
                                    catch (Throwable var28_43) {
                                        if (ps == null) throw var28_43;
                                        if (var19_22 == null) {
                                            ps.close();
                                            throw var28_43;
                                        }
                                        try {
                                            ps.close();
                                            throw var28_43;
                                        }
                                        catch (Throwable var29_44) {
                                            var19_22.addSuppressed(var29_44);
                                            throw var28_43;
                                        }
                                    }
                                }
                                try {
                                    ps.close();
                                }
                                catch (Throwable var23_35) {
                                    var19_22.addSuppressed(var23_35);
                                }
                                break;
                            }
                            ps.close();
                            break;
lbl-1000:
                            // 1 sources

                            {
                                curBound = curBound == null ? new RangeKey[primaryKeyColumnSize] : curBound;
                                i = 0;
lbl101:
                                // 2 sources

                                while (i < primaryKeyColumnSize) {
                                    value = ((TypeHandler)typeHandlers.get(i)).getNullableResult(rs, i + 1);
                                    if (value != null) ** GOTO lbl-1000
                                    RecordDumpTaskGenerator.log.info("Found null in unique constraints columns [{}], abort splitting table \"{}\"", (Object)primaryCols, (Object)tableName);
                                    var24_36 = Lists.newArrayList((Object[])new TableRangeInfo[]{new TableRangeInfo(tableName)});
                                    if (rs == null) break block63;
                                    if (var21_27 == null) break block64;
                                }
                                ** GOTO lbl136
                            }
                            {
                                block63: {
                                    block64: {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable var25_37) {
                                            var21_27.addSuppressed(var25_37);
                                        }
                                        break block63;
                                    }
                                    rs.close();
                                }
                                if (ps == null) return var24_36;
                                if (var19_22 != null) {
                                    try {
                                        ps.close();
                                        return var24_36;
                                    }
                                    catch (Throwable var25_38) {
                                        var19_22.addSuppressed(var25_38);
                                        return var24_36;
                                    }
                                }
                                ps.close();
                                return var24_36;
                                break;
                            }
                        }
                        catch (Exception e) {
                            failedFlag = isNonPartitioned != false ? "failed." : "partition: \"" + partName + "\" failed.";
                            RecordDumpTaskGenerator.log.error("Splitting rows for {}: \"{}\" {}. Reason: {}", new Object[]{partitionedFlag, tableName, failedFlag, ExceptionUtils.getRootCauseMessage(e)});
                            throw new IllegalStateException(e);
                        }
lbl-1000:
                        // 1 sources

                        {
                            curBound[i] = new RangeKey(value.toString());
                            ++i;
                            ** GOTO lbl101
lbl136:
                            // 1 sources

                            startRange = new RangeKey[]{};
                            if (preBound != null) {
                                startRange = new RangeKey[preBound.length];
                                System.arraycopy(preBound, 0, startRange, 0, preBound.length);
                            }
                            endRange = new RangeKey[curBound.length];
                            System.arraycopy(curBound, 0, endRange, 0, curBound.length);
                            bounds.add(new TableRangeInfo(tableName, Lists.newArrayList((Object[])new Pair[]{Pair.of(startRange, endRange)}), primaryCols, partName));
                            if (RecordDumpTaskGenerator.log.isDebugEnabled()) {
                                RecordDumpTaskGenerator.log.debug("....Splitting rows for {}: \"{}\" {}. Batch: {}", new Object[]{partitionedFlag, tableName, successFlag, bounds.size()});
                            }
                            if (rs == null) break block65;
                            if (var21_27 == null) break block66;
                        }
                        try {
                            rs.close();
                        }
                        catch (Throwable var22_30) {
                            var21_27.addSuppressed(var22_30);
                        }
                        break block65;
                    }
                    rs.close();
                }
                if (ps == null) continue;
                if (var19_22 != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable var20_25) {
                        var19_22.addSuppressed(var20_25);
                    }
                    continue;
                }
                ps.close();
            }
            var17_18 = bounds;
            return var17_18;
        }
        catch (Throwable var11_12) {
            var10_10 = var11_12;
            throw var11_12;
        }
        finally {
            if (conn != null) {
                if (var10_10 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable var25_40) {
                        var10_10.addSuppressed(var25_40);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    private String buildSelectBoundSql(String schemaTable, String partName, String primaryCols, String descPriCols, RangeKey[] preVals) throws Exception {
        ArrayList<String> keys = new ArrayList<String>(6);
        keys.add(this.oracleMode ? "o" : "m");
        keys.add(schemaTable);
        keys.add(StringUtils.isNotBlank(partName) ? "p-" + partName : "np");
        keys.add(primaryCols);
        keys.add(StringUtils.isNotBlank(descPriCols) ? "d" : "a");
        keys.add(preVals == null ? "nc" : "c");
        String key = String.join((CharSequence)"-", keys);
        return (String)this.pstmtCache.get((Object)key, () -> {
            if (this.oracleMode) {
                return this.buildOracleSelectBoundPattern(schemaTable, partName, primaryCols, descPriCols, preVals).toString();
            }
            return this.buildMysqlSelectBoundPattern(schemaTable, partName, primaryCols, preVals).toString();
        });
    }

    @NonNull
    private List<String> filterSpecifiedPartitionNames(String tableName, TableEntry tableEntry) {
        if (tableEntry == null || tableEntry.getTablePart() == null) {
            return Lists.newArrayList();
        }
        ArrayList partNames = tableEntry.getPartIdNameMap().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(this.specifiedParts)) {
            return partNames;
        }
        List<String> ciSpecifiedParts = this.specifiedParts.stream().map(String::toLowerCase).collect(Collectors.toList());
        ObTablePart tablePart = tableEntry.getTablePart();
        if (tablePart.getLevel() == ObPartLevel.LEVEL_TWO) {
            Set partNamesSet = tablePart.getPartDesc().getPartNameIdMap().keySet();
            Set subPartNamesSet = tablePart.getSubPartDesc().getPartNameIdMap().keySet();
            Map partToSubpartMap = partNamesSet.stream().collect(Collectors.toMap(Function.identity(), name -> {
                long partId = (Long)tablePart.getPartDesc().getPartNameIdMap().get(name);
                return Sets.newHashSet((Iterable)((Iterable)tablePart.getSubPartDesc().getPartIdSubNamesMap().get(partId)));
            }));
            HashSet specSubPartSet = new HashSet();
            ciSpecifiedParts.forEach(name -> {
                if (partNamesSet.stream().anyMatch(name::equals)) {
                    specSubPartSet.addAll((Collection)partToSubpartMap.get(name));
                } else if (subPartNamesSet.stream().anyMatch(name::equals)) {
                    specSubPartSet.add(name);
                } else {
                    throw new IllegalArgumentException("Partition: " + name + " doesn't exists");
                }
            });
            partNames = Lists.newArrayList(specSubPartSet);
        } else {
            partNames.retainAll(ciSpecifiedParts);
            if (partNames.size() != ciSpecifiedParts.size()) {
                ciSpecifiedParts.removeAll(partNames);
                throw new IllegalArgumentException("Partition: [" + org.apache.commons.lang3.StringUtils.join(ciSpecifiedParts, (String)",") + "] are not exists");
            }
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(partNames), (String)"Partitions: %s are not exists of a non-partitioned table: \"%s\"", ciSpecifiedParts, (Object)tableName);
        return partNames;
    }

    private boolean isPartitionInclude(String partitionName) {
        Set<String> specifiedPartNames = this.specifiedParts;
        if (CollectionUtils.isEmpty(specifiedPartNames)) {
            return true;
        }
        return specifiedPartNames.contains(partitionName);
    }

    private String getRowKeyString(List<RowKey> rowKeys) {
        if (CollectionUtils.isEmpty(rowKeys)) {
            return null;
        }
        return rowKeys.stream().filter(k -> !Constants.HIDDEN_KEYS.contains(k.getColumn())).map(k -> this.serverMode.wrapName(k.getColumn())).collect(Collectors.joining(","));
    }

    private CharSequence buildMysqlSelectBoundPattern(String schemaTable, String partName, String primaryCols, RangeKey[] preVals) {
        StringBuilder sql = new StringBuilder(128);
        sql.append("select ");
        ArrayList<Hint> hints = new ArrayList<Hint>();
        if (this.dataVersion > 0L) {
            hints.add(new Hint(Hint.HintTypes.FROZEN_VERSION, this.dataVersion));
        }
        if (this.enableHiddenPk && !this.serverMode.isPreviousV4()) {
            hints.add(new Hint(Hint.HintTypes.OPT_PARAM, "'hidden_column_visible', 'true'"));
        }
        if (hints.size() > 0) {
            sql.append("/*+").append(hints.stream().map(Hint::getHintStatement).collect(Collectors.joining(" , "))).append("*/ ");
        }
        sql.append(primaryCols).append(" from ").append(schemaTable);
        if (StringUtils.isNotEmpty(partName)) {
            sql.append("partition(").append(this.serverMode.wrapName(partName)).append(") ");
        }
        if (!this.snapshot && !this.serverMode.isPreviousV2270() && StringUtils.isNotBlank(this.getFlashbackScn())) {
            sql.append(" as of snapshot ").append(this.getFlashbackScn());
        }
        if (preVals != null) {
            String prePlaceHolders = Stream.of(preVals).map(RangeKey::getPlaceHolder).collect(Collectors.joining(","));
            sql.append(" where ( ").append(primaryCols).append(") > ( ").append(prePlaceHolders).append(" ) ");
        }
        return sql.append(" order by ").append(primaryCols).append(" limit ").append(this.pageSize - 1L).append(",").append(" 1 ");
    }

    private CharSequence buildOracleSelectBoundPattern(String schemaTable, String partName, String primaryCols, String descPrimaryCols, RangeKey[] preVals) {
        StringBuilder sql = new StringBuilder(128);
        sql.append("SELECT ");
        ArrayList<Hint> hints = new ArrayList<Hint>();
        if (this.dataVersion > 0L) {
            hints.add(new Hint(Hint.HintTypes.FROZEN_VERSION, this.dataVersion));
        }
        if (this.enableHiddenPk && !this.serverMode.isPreviousV4()) {
            hints.add(new Hint(Hint.HintTypes.OPT_PARAM, "'hidden_column_visible', 'true'"));
        }
        if (hints.size() > 0) {
            sql.append("/*+").append(hints.stream().map(Hint::getHintStatement).collect(Collectors.joining(" , "))).append("*/ ");
        }
        sql.append(primaryCols).append(", ROWNUM RN FROM ").append(schemaTable);
        if (StringUtils.isNotEmpty(partName)) {
            sql.append("PARTITION(").append(this.serverMode.wrapName(partName)).append(") ");
        }
        if (!this.snapshot && !this.serverMode.isPreviousV2270()) {
            if (StringUtils.isNotBlank(this.getFlashbackScn())) {
                sql.append(" AS OF SCN ").append(this.getFlashbackScn());
            } else if (StringUtils.isNotBlank(this.flashbackTimestamp)) {
                sql.append(" AS OF TIMESTAMP TO_TIMESTAMP('").append(this.flashbackTimestamp).append("','YYYY-MM-DD HH24:MI:SS')");
            }
        }
        if (this.serverMode.isPrevious("2.2.52")) {
            sql.append(" WHERE ");
            if (preVals != null) {
                String prePlaceHolders = Stream.of(preVals).map(RangeKey::getPlaceHolder).collect(Collectors.joining(","));
                sql.append(" (").append(primaryCols).append(")>( ").append(prePlaceHolders).append(") AND ");
            }
            sql.append(" ROWNUM<=").append(this.pageSize).append(" ORDER BY ").append(descPrimaryCols);
            return "SELECT " + primaryCols + " FROM (" + sql + ") A WHERE ROWNUM<=1 ORDER BY A.RN";
        }
        if (preVals != null) {
            String prePlaceHolders = Stream.of(preVals).map(RangeKey::getPlaceHolder).collect(Collectors.joining(","));
            sql.append(" WHERE ").append(" (").append(primaryCols).append(")>( ").append(prePlaceHolders).append(")");
        }
        sql.append(" ORDER BY ").append(primaryCols).append(" OFFSET ").append(this.pageSize - 1L).append(" ROWS FETCH NEXT 1 ROWS ONLY");
        return sql;
    }

    protected List<Pair<RangeKey[], RangeKey[]>> parseMacroRange(List<String> macroRanges, List<RowKey> rowKeys, int validRowKeySize) {
        if (CollectionUtils.isEmpty(macroRanges)) {
            return null;
        }
        ArrayList<Pair<RangeKey[], RangeKey[]>> conditions = new ArrayList<Pair<RangeKey[], RangeKey[]>>(2);
        for (String range : macroRanges) {
            if (StringUtils.isBlank(range) || range.length() < 2) continue;
            range = range.trim();
            String[] ranges = range.substring(1, range.lastIndexOf(93)).split(" ; ");
            RangeKey[] startValues = new RangeKey[]{};
            String left = ranges[0];
            if (!"MIN".equals(left)) {
                startValues = new RangeKey[validRowKeySize];
                String[] macros = left.split(",");
                for (int i = 0; i < macros.length; ++i) {
                    if (Constants.HIDDEN_KEYS.contains(rowKeys.get(i).getColumn())) continue;
                    startValues[i] = this.oracleMode && rowKeys.get(i).isDateType() ? new RangeKey(macros[i], "TO_TIMESTAMP(?)") : new RangeKey(macros[i]);
                }
            }
            RangeKey[] endValues = new RangeKey[]{};
            String right = ranges[1];
            if (!"MAX".equals(right)) {
                endValues = new RangeKey[validRowKeySize];
                String[] macros = right.split(",");
                for (int i = 0; i < macros.length; ++i) {
                    if (Constants.HIDDEN_KEYS.contains(rowKeys.get(i).getColumn())) continue;
                    endValues[i] = this.oracleMode && rowKeys.get(i).isDateType() ? new RangeKey(macros[i], "TO_TIMESTAMP(?)") : new RangeKey(macros[i]);
                }
            }
            if (!ArrayUtils.isNotEmpty(startValues) && !ArrayUtils.isNotEmpty(endValues)) continue;
            conditions.add(new Pair<RangeKey[], RangeKey[]>(startValues, endValues));
        }
        return conditions;
    }

    @Override
    public List<RecordDumpTask> generateDumpTask() {
        if (this.connectionKey.hasNoSysPrivileges() && this.serverMode.isPreviousV4()) {
            return this.generateDumpTaskForPublicCloud();
        }
        return this.generateDumpTaskForPrivateCloud();
    }

    public void setDataVersion(long dataVersion) {
        this.dataVersion = dataVersion;
    }

    public String getFlashbackScn() {
        return this.flashbackScn;
    }

    public void setMetadataProvider(MetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public void setTableEntryInfoMap(Map<String, TableEntryInfo> tableEntryInfoMap) {
        this.tableEntryInfoMap = tableEntryInfoMap;
    }

    private /* synthetic */ String lambda$queryBounds$4(String e) {
        return this.serverMode.wrapName(e) + " desc ";
    }

    private /* synthetic */ String lambda$queryBounds$3(String e) {
        return this.serverMode.wrapName(e);
    }
}

