/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.dumper.task.schema.AbstractSchemaDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObMysqlCompactSchemaDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObMysqlSchemaDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObOracleCompactSchemaDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObOracleSchemaDumpTask;
import com.oceanbase.tools.loaddump.generator.AbstractDumpTaskGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaDumpTaskGenerator
extends AbstractDumpTaskGenerator<AbstractSchemaDumpTask> {
    private static final Logger log = LoggerFactory.getLogger(SchemaDumpTaskGenerator.class);
    private final boolean compactSchema;

    public SchemaDumpTaskGenerator(DumpParameter parameter) {
        super(parameter);
        this.compactSchema = parameter.isCompactSchema() || this.connectionKey.hasNoSysPrivileges() && this.serverMode.isPreviousV4();
    }

    @Override
    public List<AbstractSchemaDumpTask> generateDumpTask() {
        Map<ObjectType, Set<String>> whiteListMap = this.parameter.getWhiteListMap();
        ArrayList<AbstractSchemaDumpTask> ddlDumpTasks = new ArrayList<AbstractSchemaDumpTask>(whiteListMap.size());
        for (Map.Entry<ObjectType, Set<String>> entry : whiteListMap.entrySet()) {
            ObjectType objectType = entry.getKey();
            List partitionObjectNames = Lists.partition((List)Lists.newArrayList((Iterable)entry.getValue()), (int)128);
            for (List batch : partitionObjectNames) {
                HashMap<ObjectType, HashSet> batchWhiteListMap = new HashMap<ObjectType, HashSet>(1);
                batchWhiteListMap.put(objectType, Sets.newHashSet((Iterable)batch));
                AbstractSchemaDumpTask dumpTask = this.createDumpTask();
                dumpTask.setObjectType(objectType.getName());
                dumpTask.setSchemaless(this.parameter.isSchemaless());
                dumpTask.setWithExtra(this.parameter.isWithExtra());
                dumpTask.getWhiteListMap().putAll(batchWhiteListMap);
                dumpTask.getBlackListMap().putAll(this.parameter.getBlackListMap());
                ddlDumpTasks.add(dumpTask);
            }
        }
        return ddlDumpTasks;
    }

    private AbstractSchemaDumpTask createDumpTask() {
        if (this.compactSchema) {
            return this.oracleMode ? new ObOracleCompactSchemaDumpTask() : new ObMysqlCompactSchemaDumpTask();
        }
        return this.oracleMode ? new ObOracleSchemaDumpTask() : new ObMysqlSchemaDumpTask();
    }
}

