/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.mybatis.type.custom;

import com.oceanbase.tools.loaddump.common.exception.UnexpectedResultException;
import com.oceanbase.tools.loaddump.mybatis.type.BaseTypeHandler;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;

public abstract class AbstractBlobTypeHandler<T>
extends BaseTypeHandler<T> {
    private static final long serialVersionUID = 3566934293876054313L;

    protected byte[] toByteArray(Blob blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)blob.getBinaryStream());
            return byArray;
        }
        catch (IOException ex) {
            throw new UnexpectedResultException("Read binary stream error", ex);
        }
        finally {
            blob.free();
        }
    }
}

