/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.mybatis.type.custom;

import com.oceanbase.jdbc.JDBC4ResultSet;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPTZ;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.mybatis.type.custom.AbstractToStringTypeHandler;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class TimestampWithTimeZoneToStringTypeHandler
extends AbstractToStringTypeHandler {
    private static final long serialVersionUID = -1409710425258750642L;
    private int precision;
    private DateTimeFormatter timestampTzValueFormatter;

    public TimestampWithTimeZoneToStringTypeHandler(String timestampTzValuePattern, int precision) {
        this.precision = precision;
        if (StringUtils.isNotBlank(timestampTzValuePattern)) {
            this.timestampTzValueFormatter = DateTimeFormatter.ofPattern(timestampTzValuePattern);
        }
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        if (rs instanceof JDBC4ResultSet) {
            return this.translateTo(((JDBC4ResultSet)rs).getTIMESTAMPTZ(columnName));
        }
        return rs.getString(columnName);
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        if (rs instanceof JDBC4ResultSet) {
            return this.translateTo(((JDBC4ResultSet)rs).getTIMESTAMPTZ(columnIndex));
        }
        return rs.getString(columnIndex);
    }

    private String translateTo(TIMESTAMPTZ timestampTz) throws SQLException {
        if (timestampTz == null) {
            return null;
        }
        byte[] bytes = timestampTz.getBytes();
        String timeZoneStr = this.toTimezoneStr(bytes[12], bytes[13]);
        LocalDateTime ldt = timestampTz.timestampValue().toLocalDateTime();
        if (this.timestampTzValueFormatter != null) {
            ZoneOffset zoneOffset = ZoneOffset.of(timeZoneStr);
            ZonedDateTime zonedDateTime = ZonedDateTime.of(ldt, ZoneId.ofOffset("UTC", zoneOffset));
            return this.timestampTzValueFormatter.format(zonedDateTime);
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(Constants.DEFAULT_TIMESTAMP_TZ_FORMATTER.format(ldt));
        if (this.precision > 0) {
            String nanoStr = super.formatNanoTime(ldt.getNano());
            sb.append('.').append(nanoStr);
            for (int i = this.precision - nanoStr.length(); i > 0; --i) {
                sb.append('0');
            }
        }
        return sb.append(' ').append(timeZoneStr).toString();
    }

    private String toTimezoneStr(byte hour, byte minute) {
        StringBuilder offsetTimeZone = new StringBuilder(6);
        if (hour > -10 && hour < 0) {
            offsetTimeZone.append("-0").append(-hour);
        } else if (hour >= 0 && hour < 10) {
            offsetTimeZone.append("+0").append(hour);
        } else if (hour >= 10) {
            offsetTimeZone.append("+").append(hour);
        } else {
            offsetTimeZone.append(hour);
        }
        offsetTimeZone.append(":");
        if (minute > -10 && minute < 0) {
            offsetTimeZone.append("0").append(-minute);
        } else if (minute >= 0 && minute < 10) {
            offsetTimeZone.append("0").append(minute);
        } else {
            offsetTimeZone.append(minute);
        }
        return offsetTimeZone.toString();
    }

    public TimestampWithTimeZoneToStringTypeHandler() {
    }
}

