/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.par;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.parser.record.AbstractColumnOrientedParser;
import com.oceanbase.tools.loaddump.parser.record.Record;
import com.oceanbase.tools.loaddump.parser.record.par.BinaryColumnHandler;
import com.oceanbase.tools.loaddump.parser.record.par.BooleanColumnHandler;
import com.oceanbase.tools.loaddump.parser.record.par.ColumnHandler;
import com.oceanbase.tools.loaddump.parser.record.par.DateColumnHandler;
import com.oceanbase.tools.loaddump.parser.record.par.DecimalColumnHandler;
import com.oceanbase.tools.loaddump.parser.record.par.DoubleColumnHandler;
import com.oceanbase.tools.loaddump.parser.record.par.FloatColumnHandler;
import com.oceanbase.tools.loaddump.parser.record.par.Int32ColumnHandler;
import com.oceanbase.tools.loaddump.parser.record.par.Int64ColumnHandler;
import com.oceanbase.tools.loaddump.parser.record.par.Int96ColumnHandler;
import com.oceanbase.tools.loaddump.parser.record.par.StringColumnHandler;
import com.oceanbase.tools.loaddump.parser.record.par.TimeColumnHandler;
import com.oceanbase.tools.loaddump.parser.record.par.TimestampColumnHandler;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRecordParserV2
extends AbstractColumnOrientedParser {
    private static final Logger log = LoggerFactory.getLogger(ParquetRecordParserV2.class);
    private final ParquetReader<Group> reader;
    private ColumnHandler[] columnHandlers;

    private ParquetRecordParserV2(ParquetReader<Group> reader, MessageType messageType) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)"Parquet reader is null");
        this.reader = reader;
        this.initColumnHandlerMap(messageType);
    }

    public static ParquetRecordParserV2 parse(URI uri, Configuration conf) throws Exception {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"Input uri is null");
        return new Builder().withUri(uri).withConf(conf).build();
    }

    public static ParquetRecordParserV2 parse(String path, Configuration conf) throws Exception {
        return ParquetRecordParserV2.parse(new URI(path), conf);
    }

    @Override
    public Record extractRecord() throws IOException {
        Group group = (Group)this.reader.read();
        if (group == null) {
            return null;
        }
        int colNum = this.columnHandlers.length;
        String[] values = new String[colNum];
        for (int i = 0; i < colNum; ++i) {
            values[i] = this.columnHandlers[i].getValue(group, i);
        }
        return new Record(values);
    }

    @Override
    public void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
            this.closed = true;
        }
        super.close();
    }

    private void initColumnHandlerMap(MessageType messageType) {
        int colNum = messageType.getFields().size();
        this.columnHandlers = new ColumnHandler[colNum];
        block8: for (int i = 0; i < colNum; ++i) {
            Type type = (Type)messageType.getFields().get(i);
            LogicalTypeAnnotation logicalType = type.getLogicalTypeAnnotation();
            if (logicalType != null) {
                if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    int scale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType).getScale();
                    this.columnHandlers[i] = new DecimalColumnHandler(scale);
                    continue;
                }
                if (logicalType instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                    this.columnHandlers[i] = new DateColumnHandler();
                    continue;
                }
                if (logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
                    LogicalTypeAnnotation.TimeUnit timeUnit = ((LogicalTypeAnnotation.TimeLogicalTypeAnnotation)logicalType).getUnit();
                    this.columnHandlers[i] = new TimeColumnHandler(timeUnit);
                    continue;
                }
                if (logicalType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                    LogicalTypeAnnotation.TimeUnit timeUnit = ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalType).getUnit();
                    this.columnHandlers[i] = new TimestampColumnHandler(timeUnit);
                    continue;
                }
                if (logicalType instanceof LogicalTypeAnnotation.BsonLogicalTypeAnnotation) {
                    this.columnHandlers[i] = new BinaryColumnHandler();
                    continue;
                }
                this.columnHandlers[i] = new StringColumnHandler();
                continue;
            }
            switch (type.asPrimitiveType().getPrimitiveTypeName()) {
                case INT32: {
                    this.columnHandlers[i] = new Int32ColumnHandler();
                    continue block8;
                }
                case INT64: {
                    this.columnHandlers[i] = new Int64ColumnHandler();
                    continue block8;
                }
                case INT96: {
                    this.columnHandlers[i] = new Int96ColumnHandler();
                    continue block8;
                }
                case BOOLEAN: {
                    this.columnHandlers[i] = new BooleanColumnHandler();
                    continue block8;
                }
                case FLOAT: {
                    this.columnHandlers[i] = new FloatColumnHandler();
                    continue block8;
                }
                case DOUBLE: {
                    this.columnHandlers[i] = new DoubleColumnHandler();
                    continue block8;
                }
                default: {
                    this.columnHandlers[i] = new BinaryColumnHandler();
                }
            }
        }
    }

    public static class Builder {
        private URI uri;
        private Configuration conf = new Configuration();

        public Builder withUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder withConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public ParquetRecordParserV2 build() throws Exception {
            Preconditions.checkArgument((this.uri != null ? 1 : 0) != 0, (Object)"Input uri is null");
            ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(this.uri)).withConf(this.conf).usePageChecksumVerification(false).build();
            try (ParquetFileReader r = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)new Path(this.uri), (Configuration)this.conf));){
                ParquetRecordParserV2 parquetRecordParserV2 = new ParquetRecordParserV2(reader, r.getFooter().getFileMetaData().getSchema());
                return parquetRecordParserV2;
            }
        }
    }
}

