/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.par;

import com.oceanbase.tools.loaddump.parser.record.par.ColumnHandler;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampColumnHandler
implements ColumnHandler {
    private static final Logger log = LoggerFactory.getLogger(TimestampColumnHandler.class);
    private final LogicalTypeAnnotation.TimeUnit timeUnit;

    public TimestampColumnHandler(LogicalTypeAnnotation.TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Override
    public String getValue(Group group, int colIdx) {
        if (group.getFieldRepetitionCount(colIdx) == 0) {
            return null;
        }
        long value = group.getLong(colIdx, 0);
        switch (this.timeUnit) {
            case MILLIS: {
                return LocalDateTime.ofEpochSecond(value / 1000L, (int)(value % 1000L) * 1000000, ZoneOffset.UTC).toString();
            }
            case MICROS: {
                return LocalDateTime.ofEpochSecond(value / 1000000L, (int)(value % 1000000L * 1000L), ZoneOffset.UTC).toString();
            }
            case NANOS: {
                return LocalDateTime.ofEpochSecond(value / 1000000000L, (int)(value % 1000000000L), ZoneOffset.UTC).toString();
            }
        }
        log.warn("Unexpected time unit for TimestampLogicalTypeAnnotation: {}", (Object)this.timeUnit);
        return null;
    }
}

