/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.partition;

import com.alibaba.druid.pool.DruidDataSource;
import com.google.common.collect.Lists;
import com.oceanbase.partition.calculator.helper.TableEntryExtractor;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.calculator.model.TableEntryKey;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.Pair;
import com.oceanbase.tools.loaddump.jdbc.JdbcExecutor;
import com.oceanbase.tools.loaddump.manager.SessionManager;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPartitionHelper {
    private static final Logger log = LoggerFactory.getLogger(AbstractPartitionHelper.class);
    protected ServerMode serverMode;
    protected ConnectionKey connectionKey;
    protected SessionManager sessionManager;
    protected TableEntryExtractor tableEntryExtractor;

    public AbstractPartitionHelper(ConnectionKey connectionKey) {
        this.connectionKey = connectionKey;
        this.serverMode = connectionKey.getServerMode();
        this.sessionManager = connectionKey.getSessionManager();
        this.tableEntryExtractor = new TableEntryExtractor();
    }

    public TableEntry queryTableEntry(String table) throws Exception {
        boolean isPreviousV4 = this.serverMode.isPreviousV4();
        TableEntryKey tableEntryKey = this.connectionKey.createTableEntryKey(table);
        DruidDataSource dataSource = isPreviousV4 ? this.sessionManager.getSystemDataSource() : this.sessionManager.getBusinessDataSource();
        return this.tableEntryExtractor.queryTableEntry(dataSource, tableEntryKey, !isPreviousV4);
    }

    public List<String> queryPartitionNames(String table, boolean hasNoSysPrivileges, boolean isPreviousV4) throws Exception {
        try {
            TableEntryKey tableEntryKey;
            if (hasNoSysPrivileges && isPreviousV4) {
                return this.queryPartitionForPub(table);
            }
            DruidDataSource dataSource = isPreviousV4 ? this.sessionManager.getSystemDataSource() : this.sessionManager.getBusinessDataSource();
            TableEntry tableEntry = this.tableEntryExtractor.queryTableEntry(dataSource, tableEntryKey = this.connectionKey.createTableEntryKey(table), !isPreviousV4);
            if (tableEntry == null) {
                log.warn("Query table entry for table: \"{}\" is null. Consider the table as non-partitioned table.", (Object)table);
                return Lists.newArrayList();
            }
            List<String> partNames = tableEntry.getPartIdNameMap().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            if (partNames.size() == 0) {
                log.debug("Query partition names for table: \"{}\" success. (Non-partitioned)", (Object)table);
            } else {
                log.debug("Query partition names for table: \"{}\" success. Partitions: {}", (Object)table, (Object)partNames.size());
            }
            return partNames;
        }
        catch (Exception e) {
            log.error("Query partition names for table: \"{}\" failed. Reason: {}", (Object)table, (Object)ExceptionUtils.getRootCauseMessage(e));
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Pair<String, Integer> queryPartitionLevel(String tableName) throws Exception {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            Object[] args = new Object[]{tableName, this.connectionKey.getDatabase()};
            Pair pair = JdbcExecutor.query(conn, this.getQueryPartitionLevelSql(), args, rs -> {
                if (rs.next()) {
                    int partLevel = rs.getInt("part_level");
                    log.info("Query partition level for table: \"{}\" success. Partition level: {}", (Object)tableName, (Object)partLevel);
                    return new Pair<String, Integer>(rs.getString("table_id"), partLevel);
                }
                log.warn("Partition level of table: \"{}\" is null. It will be dumped as non-partitioned table", (Object)tableName);
                return null;
            });
            return pair;
        }
        catch (Exception e) {
            log.error("Query partition level for table: \"{}\" failed. Reason: {}", (Object)tableName, (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    protected List<String> queryPartitionForPub(String table) throws Exception {
        int partLevel = 0;
        try {
            ArrayList<String> partNames = new ArrayList<String>();
            if (this.serverMode.isPreviousV2()) {
                return partNames;
            }
            Pair<String, Integer> pair = this.queryPartitionLevel(table);
            if (pair == null || pair.getRight() == 0) {
                return partNames;
            }
            partLevel = pair.getRight();
            String sql = this.getQueryTablePartitionsSql(partLevel);
            partNames.addAll(this.queryPartitionNamesForPub(sql, pair.getLeft()));
            log.info("Query partition names for {} level partitioned table: \"{}\" success. (No sys). Partitions: {}", new Object[]{partLevel, table, partNames.size()});
            return partNames;
        }
        catch (Exception e) {
            log.error("Query partition names for {} level partitioned table:\" {}\" failed. (No sys). Reason: {}", new Object[]{partLevel, table, e.getMessage()});
            throw new IllegalStateException(e);
        }
    }

    protected abstract List<String> queryPartitionNamesForPub(String var1, String var2) throws Exception;

    protected abstract String getQueryPartitionLevelSql();

    protected abstract String getQueryTablePartitionsSql(int var1);

    public AbstractPartitionHelper() {
    }

    public TableEntryExtractor getTableEntryExtractor() {
        return this.tableEntryExtractor;
    }
}

