/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.partition;

import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.jdbc.JdbcExecutor;
import com.oceanbase.tools.loaddump.partition.AbstractPartitionHelper;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlPartitionHelper
extends AbstractPartitionHelper {
    private static final Logger log = LoggerFactory.getLogger(MySqlPartitionHelper.class);
    static final String QUERY_TABLE_PARTITIONS_LEVEL_MYSQL_1 = "select t.table_id,t.part_level from oceanbase.__all_table t,oceanbase.__all_database d where t.table_name=? and d.database_name=? and t.database_id=d.database_id";
    static final String QUERY_TABLE_PARTITIONS_LEVEL_MYSQL_2 = "select t.table_id, t.part_level from oceanbase.__all_table_v2 t,oceanbase.__all_database d where t.table_name=? and d.database_name=? and t.database_id=d.database_id";
    static final String QUERY_TABLE_PARTITIONS_MYSQL = "select part_name from oceanbase.__all_part where table_id=?";
    static final String QUERY_TABLE_SUB_PARTITIONS_MYSQL = "select sub_part_name as part_name from oceanbase.__all_sub_part where table_id=?";

    public MySqlPartitionHelper(ConnectionKey connectionKey) {
        super(connectionKey);
    }

    @Override
    protected List<String> queryPartitionNamesForPub(String sql, String tableId) throws Exception {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            Object[] args = new Object[]{tableId};
            List<String> list = JdbcExecutor.queryList(conn, sql, args, rs -> {
                ArrayList<String> partNames = new ArrayList<String>();
                while (rs.next()) {
                    partNames.add(rs.getString("part_name"));
                }
                return partNames;
            });
            return list;
        }
    }

    @Override
    protected String getQueryPartitionLevelSql() {
        return this.serverMode.isPreviousV2270() ? QUERY_TABLE_PARTITIONS_LEVEL_MYSQL_1 : QUERY_TABLE_PARTITIONS_LEVEL_MYSQL_2;
    }

    @Override
    protected String getQueryTablePartitionsSql(int partLevel) {
        return partLevel == 1 ? QUERY_TABLE_PARTITIONS_MYSQL : QUERY_TABLE_SUB_PARTITIONS_MYSQL;
    }

    public MySqlPartitionHelper() {
    }
}

