/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.reader.schema;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.converter.AntlrDDLConverter;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.tools.loaddump.common.enums.CompatMode;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.ObjectStatus;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.parser.compatilble.SqlText;
import com.oceanbase.tools.loaddump.parser.compatilble.mysqldump.MySqlDumpParser;
import com.oceanbase.tools.loaddump.reader.AbstractFileReader;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.JdbcUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaFileReaderV2
extends AbstractFileReader {
    private static final Logger log = LoggerFactory.getLogger(SchemaFileReaderV2.class);
    protected int threads;
    protected ServerMode serverMode;
    protected DataFormat dataFormat;
    protected boolean ignoreComment;
    protected boolean replaceObjectIfExists;
    protected List<String> objectNames;
    protected Map<ObjectType, List<SubFile>> subFilesMap;
    protected Map<SubFile, List<Integer>> retrySqls = new ConcurrentHashMap<SubFile, List<Integer>>();
    protected CompatMode compatMode;
    private AntlrDDLConverter converter;

    public SchemaFileReaderV2(LoadParameter parameter) {
        super(parameter);
        this.threads = parameter.getThreads();
        this.dataFormat = parameter.getDataFormat();
        this.serverMode = parameter.getDatabase().getServerMode();
        this.replaceObjectIfExists = parameter.isReplaceObjectIfExists();
        List<SubFile> subFileList = parameter.getSubFiles();
        this.objectNames = subFileList.stream().map(SubFile::getObjectName).collect(Collectors.toList());
        this.subFilesMap = this.sortByDependencies(subFileList);
        this.compatMode = parameter.getCompatMode();
        if (this.compatMode != null) {
            Configure srcConfigure = new Configure(Global.newInstance(), this.compatMode.getDbType(), parameter.getDatabaseName());
            Configure dstConfigure = new Configure(Global.newInstance(), DbType.valueOf((String)this.serverMode.name(), (String)this.serverMode.getVersion()), parameter.getDatabaseName());
            this.converter = new AntlrDDLConverter(srcConfigure, dstConfigure);
        }
    }

    private Map<ObjectType, List<SubFile>> sortByDependencies(List<SubFile> subFileList) {
        LinkedHashMap<ObjectType, List> temp = new LinkedHashMap<ObjectType, List>();
        for (SubFile subFile : subFileList) {
            ObjectType objectType = ObjectType.valueOfName(subFile.getObjectType());
            temp.computeIfAbsent(objectType, v -> new ArrayList()).add(subFile);
        }
        LinkedHashMap<ObjectType, List<SubFile>> subFileListMap = new LinkedHashMap<ObjectType, List<SubFile>>();
        for (ObjectType objectType : ObjectType.DEPENDENCIES) {
            List tempSubFileList = (List)temp.remove((Object)objectType);
            if (!CollectionUtils.isNotEmpty((Collection)tempSubFileList)) continue;
            subFileListMap.put(objectType, tempSubFileList);
        }
        return subFileListMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map<ObjectType, List<SubFile>> executableMap = this.subFilesMap;
        String[] errors = new String[1];
        int retryTimes = 0;
        int currentExecCount = 0;
        int prevRetryCount = executableMap.values().stream().mapToInt(List::size).sum();
        try {
            while (MapUtils.isNotEmpty(executableMap) && prevRetryCount > currentExecCount) {
                LinkedHashMap<ObjectType, List<SubFile>> retryFailedMap = new LinkedHashMap<ObjectType, List<SubFile>>();
                for (Map.Entry<ObjectType, List<SubFile>> entry : executableMap.entrySet()) {
                    retryFailedMap.putAll(this.handleSqlFormatFile(entry.getKey(), entry.getValue()));
                }
                prevRetryCount = executableMap.values().stream().mapToInt(List::size).sum();
                executableMap = retryFailedMap;
                currentExecCount = executableMap.values().stream().mapToInt(List::size).sum();
                ++retryTimes;
            }
        }
        catch (Exception ex) {
            try {
                errors[0] = ExceptionUtils.getRootCauseMessage(ex);
            }
            catch (Throwable throwable) {
                if (MapUtils.isNotEmpty(executableMap)) {
                    executableMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()).forEach(e -> {
                        e.setTaskState(TaskState.FAILURE);
                        e.setMessage(StringUtils.isBlank(e.getMessage()) ? errors[0] : e.getMessage());
                        this.updateTaskDetail((SubFile)e);
                    });
                    String error = StringUtils.isBlank(errors[0]) ? "Please check errors in ../logs/ob-loader-dumper.error" : "Error: " + errors[0];
                    log.error("Load schema failed. {}{}", (Object)error, (Object)(retryTimes > 1 ? " Retry {} times. " : ""));
                }
                throw throwable;
            }
            if (MapUtils.isNotEmpty(executableMap)) {
                executableMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()).forEach(e -> {
                    e.setTaskState(TaskState.FAILURE);
                    e.setMessage(StringUtils.isBlank(e.getMessage()) ? errors[0] : e.getMessage());
                    this.updateTaskDetail((SubFile)e);
                });
                String error = StringUtils.isBlank(errors[0]) ? "Please check errors in ../logs/ob-loader-dumper.error" : "Error: " + errors[0];
                log.error("Load schema failed. {}{}", (Object)error, (Object)(retryTimes > 1 ? " Retry {} times. " : ""));
            }
        }
        if (MapUtils.isNotEmpty(executableMap)) {
            executableMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()).forEach(e -> {
                e.setTaskState(TaskState.FAILURE);
                e.setMessage(StringUtils.isBlank(e.getMessage()) ? errors[0] : e.getMessage());
                this.updateTaskDetail((SubFile)e);
            });
            String error = StringUtils.isBlank(errors[0]) ? "Please check errors in ../logs/ob-loader-dumper.error" : "Error: " + errors[0];
            log.error("Load schema failed. {}{}", (Object)error, (Object)(retryTimes > 1 ? " Retry {} times. " : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ObjectType, List<SubFile>> handleSqlFormatFile(ObjectType objectType, List<SubFile> subFileList) {
        boolean isCompatibleWith3rd = this.dataFormat == DataFormat.MIX;
        LinkedHashMap<ObjectType, List<SubFile>> retryFailedMap = new LinkedHashMap<ObjectType, List<SubFile>>();
        for (SubFile subFile : subFileList) {
            subFile.setTaskState(TaskState.RUNNING);
            String subFilePath = subFile.getUniquePath();
            try {
                MySqlDumpParser parser = MySqlDumpParser.createParser(subFile.openBoundedStream(this.fileEncoding), this.fileEncoding, this.ignoreComment);
                Throwable throwable = null;
                try {
                    parser.setCompatibleWith3rd(isCompatibleWith3rd);
                    List<SqlText> sqlTextList = parser.parseStmt();
                    if (CollectionUtils.isEmpty(sqlTextList)) {
                        log.warn("No statements are parsed from: \"{}\"", (Object)subFilePath);
                        subFile.setTaskState(TaskState.FAILURE);
                        subFile.setMessage("No statements are parsed from: \"" + subFilePath + "\"");
                        continue;
                    }
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    subFile.setTotalSize(FileUtils.getSize(subFile.getFilePath()));
                    subFile.getParsedCount().getAndSet(sqlTextList.size());
                    int totalCount = sqlTextList.size();
                    for (int i = 0; i < totalCount; ++i) {
                        SqlText sqlText = sqlTextList.get(i);
                        try {
                            if (sqlText.isSupported()) {
                                sqlText.setObjectType(subFile.getObjectType());
                                sqlText.setSchemaName(subFile.getSchemaName());
                                sqlText.setObjectName(subFile.getObjectName());
                                subFile.addLoadedCount(this.executeSqlStatement(subFilePath, i + 1, totalCount, sqlText));
                                continue;
                            }
                            subFile.addLoadedCount(1);
                            log.debug("SQL-format file: \"{}\" appears an unsupported {}.", (Object)subFilePath, (Object)sqlText);
                            continue;
                        }
                        catch (Throwable th) {
                            String error = ExceptionUtils.getRootCauseMessage(th);
                            String executableSql = sqlText.getExecutableSql();
                            if (isCompatibleWith3rd) {
                                subFile.setTaskState(TaskState.FAILURE);
                                if (StringUtils.isBlank(subFile.getMessage())) {
                                    subFile.setMessage("Loading SQL-format file: \"" + subFilePath + "\" failure. Reason: " + error + ". Please see ../logs/ob-loader-dumper.error");
                                }
                                log.error("....Loading sql of SQL-format file: \"{}\" exec failure. ({}/{}). Reason: {}. SQL: {}", new Object[]{subFilePath, i + 1, totalCount, error, executableSql});
                                continue;
                            }
                            if (JdbcUtils.isCreateWithoutDependenciesError(error)) {
                                subFile.setTaskState(TaskState.INITIAL);
                                subFile.setMessage(error + ". SQL-format file: \"" + subFilePath + "\". SQL: " + executableSql);
                                retryFailedMap.computeIfAbsent(objectType, v -> new ArrayList()).add(subFile);
                                break;
                            }
                            subFile.setTaskState(TaskState.FAILURE);
                            subFile.setMessage("Loading SQL-format file: \"" + subFilePath + "\" failure. Reason: " + error + ". Please see ../logs/ob-loader-dumper.error");
                            log.error("....Loading sql of SQL-format file: \"{}\" exec failure. ({}/{}). Reason: {}. SQL: {}", new Object[]{subFilePath, i + 1, totalCount, error, executableSql});
                            break;
                        }
                    }
                    if (subFile.getTaskState() != TaskState.RUNNING) continue;
                    subFile.setTaskState(TaskState.SUCCESS);
                    log.info("Load SQL-format file: \"{}\" success. Elapsed: {}", (Object)subFilePath, (Object)stopwatch);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (parser == null) continue;
                    if (throwable != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    parser.close();
                }
            }
            catch (Exception e) {
                subFile.setTaskState(TaskState.FAILURE);
                subFile.setMessage(ExceptionUtils.getRootCauseMessage(e));
                log.error("Process SQL-format file failed. Error: {}", (Object)subFile.getMessage(), (Object)e);
            }
            finally {
                this.updateTaskDetail(subFile);
            }
        }
        return retryFailedMap;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int executeSqlStatement(String filePath, int index, int total, SqlText sqlText) throws Exception {
        boolean retried = false;
        while (this.supervisor.get()) {
            String executableSql = sqlText.getExecutableSql();
            if (DataFormat.MIX != this.dataFormat) {
                executableSql = JdbcUtils.removeIncompatibleSnippet(executableSql);
            }
            try (Connection conn = this.connectionKey.getSessionManager().getPooledBizConnection();){
                SupplierResult sr = this.supplyAsync(conn, filePath, index, total, executableSql, retried);
                if (sr.getRootCause() != null) {
                    throw sr.getRootCause();
                }
                int n = 1;
                return n;
            }
            catch (Throwable th) {
                String error = ExceptionUtils.getRootCauseMessage(th);
                if (JdbcUtils.isDropNonExistsObjectError(executableSql, error)) {
                    return 1;
                }
                if (JdbcUtils.isInsertDuplicateKeyError(executableSql, error)) {
                    return 1;
                }
                if (!retried && JdbcUtils.isExecuteTimeoutError(th, error)) {
                    retried = true;
                    continue;
                }
                if (!retried && JdbcUtils.isStatementSyntaxError(error)) {
                    sqlText.setTargetSqlText(this.convertDdlText(sqlText.getObjectType(), executableSql));
                    retried = true;
                    continue;
                }
                if (!retried && JdbcUtils.isCreateExistsObjectError(executableSql, error)) {
                    retried = this.shouldRetryStatement(sqlText);
                    if (retried) continue;
                    throw new SQLException(th);
                }
                throw new SQLException(th);
            }
        }
        return 0;
    }

    private String convertDdlText(String objectType, String executableSql) throws Exception {
        String string = objectType = ObjectType.FILE.name().equals(objectType) ? this.parseObjectTypeAndName(executableSql)[0] : objectType;
        if (objectType == null) {
            return executableSql;
        }
        if (this.serverMode.isMysqlMode() && ObjectType.TABLE.getName().equalsIgnoreCase(objectType)) {
            List defines = this.converter.convert(executableSql, com.oceanbase.obtools.dbdiff.enums.ObjectType.TABLE);
            Preconditions.checkState((CollectionUtils.isNotEmpty((Collection)defines) && defines.size() == 1 ? 1 : 0) != 0, (Object)"Unexpected size of object defines yielded by text converter.");
            return ((ObjectDefine)defines.get(0)).getObjectGrammar();
        }
        return executableSql;
    }

    private boolean shouldRetryStatement(SqlText sqlText) {
        if (!this.replaceObjectIfExists) {
            return false;
        }
        return this.tryDropObject(sqlText);
    }

    /*
     * Exception decompiling
     */
    private boolean tryDropObject(SqlText sqlText) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NonNull
    public String[] parseObjectTypeAndName(@NonNull String sql) {
        if (sql == null) {
            throw new NullPointerException("sql is marked non-null but is null");
        }
        String[] res = new String[2];
        String pattern = "create\\s+(?:or\\s+replace\\s+)?(?:if\\s+not\\s+exists\\s+)?(\\w+)\\s+`?(\\w+)`?";
        Pattern regex = Pattern.compile(pattern, 2);
        Matcher matcher = regex.matcher(sql);
        if (matcher.find()) {
            res[0] = matcher.group(1).toLowerCase();
            res[1] = matcher.group(2);
        }
        return res;
    }

    private SupplierResult supplyAsync(Connection conn, String path, int index, int total, String sql, boolean retried) {
        try {
            return CompletableFuture.supplyAsync(() -> {
                try (Statement stmt = conn.createStatement();){
                    if (!retried) {
                        log.info("Executing sql({}/{}) of SQL-format file: \"{}\"...", new Object[]{index, total, path});
                    } else {
                        log.info("Re-executing sql({}/{}) of SQL-format file: \"{}\"...", new Object[]{index, total, path});
                    }
                    stmt.execute(sql);
                    SupplierResult supplierResult = new SupplierResult();
                    return supplierResult;
                }
                catch (Exception ex) {
                    return new SupplierResult(ex);
                }
            }).get(15L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            return new SupplierResult(e);
        }
    }

    @Override
    protected void updateTaskDetail(@NonNull SubFile subFile) {
        if (subFile == null) {
            throw new NullPointerException("subFile is marked non-null but is null");
        }
        super.updateTaskDetail(subFile);
        subFile.getTaskDetail().setTaskType(TaskType.LOAD_SCHEMA);
        List<ObjectStatus> objectStatusList = subFile.getTaskDetail().getObjectStatusList();
        String objectName = subFile.getObjectName();
        String objectType = subFile.getObjectType();
        if (CollectionUtils.isNotEmpty(objectStatusList)) {
            Iterator<ObjectStatus> iter = objectStatusList.iterator();
            while (iter.hasNext()) {
                ObjectStatus objectStatus = iter.next();
                if (!objectStatus.getType().equals(objectType) || !objectStatus.getName().equals(objectName)) continue;
                iter.remove();
                break;
            }
        }
        objectStatusList.add(new ObjectStatus(objectName, objectType, subFile.getParsedCount(), subFile.getLoadedCount(), subFile.getTaskState()));
    }

    static class SupplierResult {
        private final Throwable throwable;

        public SupplierResult() {
            this.throwable = null;
        }

        public SupplierResult(Throwable throwable) {
            this.throwable = throwable;
        }

        public Throwable getRootCause() {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)this.throwable);
            return rootCause == null ? this.throwable : rootCause;
        }
    }
}

