/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource.remote.hdfs;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.BaseParameter;
import com.oceanbase.tools.loaddump.common.model.storage.remote.hdfs.HdfsStorageConfig;
import com.oceanbase.tools.loaddump.resource.AbstractResourceFinder;
import com.oceanbase.tools.loaddump.resource.Resource;
import com.oceanbase.tools.loaddump.resource.remote.hdfs.HdfsResource;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsResourceFinder
extends AbstractResourceFinder<Resource> {
    private static final Logger log = LoggerFactory.getLogger(HdfsResourceFinder.class);
    private final HdfsStorageConfig config;

    public HdfsResourceFinder(BaseParameter parameter) {
        super(parameter);
        this.config = (HdfsStorageConfig)parameter.getStorageConfig();
    }

    @Override
    public List<Resource> listSchemaResources() throws Exception {
        try (FileSystem fs = this.config.createHdfsSystem();){
            ArrayList resources;
            Stopwatch stopwatch = Stopwatch.createStarted();
            DataFormat dataFormat = this.parameter.getDataFormat();
            String suffix = dataFormat == DataFormat.MIX || dataFormat == DataFormat.DDL ? this.fileSuffix : "-schema.sql";
            List<LocatedFileStatus> locatedFiles = this.listLocatedFiles(fs, suffix);
            if (locatedFiles.size() == 1 && locatedFiles.get(0).getLen() > 0L) {
                LocatedFileStatus locatedFile = locatedFiles.get(0);
                String filePath = locatedFile.getPath().toUri().toString();
                String fileName = new File(filePath).getName();
                resources = Lists.newArrayList((Object[])new Resource[]{new HdfsResource(this.config, ObjectType.FILE.getName(), fileName, filePath, locatedFile.getLen())});
            } else {
                resources = this.filterMatchedSchemaResources(locatedFiles);
            }
            log.info("Find {} resources in hdfs: \"{}\" success. Elapsed: {}", new Object[]{resources.size(), this.config.getHdfsUri(), stopwatch});
            ArrayList arrayList = resources;
            return arrayList;
        }
    }

    private List<Resource> filterMatchedSchemaResources(List<LocatedFileStatus> locatedFiles) {
        ServerMode serverMode = this.parameter.getDatabase().getServerMode();
        Map<ObjectType, Set<String>> whiteListMap = this.parameter.getWhiteListMap();
        Map<ObjectType, Set<String>> blackListMap = this.parameter.getBlackListMap();
        boolean compatibleWith3rd = this.parameter.getDataFormat() == DataFormat.MIX;
        ArrayList<Resource> resources = new ArrayList<Resource>(locatedFiles.size());
        for (LocatedFileStatus locatedFile : locatedFiles) {
            String filePath = locatedFile.getPath().toUri().toString();
            File tempFile = new File(filePath);
            String fileName = tempFile.getName();
            String parentPath = tempFile.getParent();
            String objectTypeName = ObjectType.FILE.getName();
            if (!compatibleWith3rd && this.parameter.isIncludeDdl()) {
                objectTypeName = parentPath.substring(parentPath.lastIndexOf(File.separator) + 1);
            }
            ObjectType objectType = ObjectType.valueOfName(objectTypeName);
            if (compatibleWith3rd && objectType == ObjectType.FILE) {
                resources.add(new HdfsResource(this.config, objectTypeName, fileName, filePath, locatedFile.getLen()));
                continue;
            }
            if (!whiteListMap.containsKey((Object)objectType)) continue;
            int index = fileName.lastIndexOf("-schema.sql");
            String objectName = index > 0 ? fileName.substring(0, index) : fileName;
            List<String> whiteSet = DBUtils.toCaseSensitiveNames(serverMode, (Collection<String>)whiteListMap.get((Object)objectType));
            List<String> blackSet = DBUtils.toCaseSensitiveNames(serverMode, (Collection<String>)blackListMap.get((Object)objectType));
            if (blackSet.contains(objectName) || !CollectionUtils.isEmpty(whiteSet) && !whiteSet.contains(objectName)) continue;
            resources.add(new HdfsResource(this.config, objectTypeName, objectName, filePath, locatedFile.getLen()));
        }
        return resources;
    }

    @Override
    public List<Resource> listRecordResources() throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try (FileSystem fs = this.config.createHdfsSystem();){
            ArrayList resources;
            List<LocatedFileStatus> locatedFiles = this.listLocatedFiles(fs, this.fileSuffix);
            if (locatedFiles.size() == 1 && locatedFiles.get(0).getLen() > 0L) {
                LocatedFileStatus locatedFile = locatedFiles.get(0);
                long fileLength = locatedFile.getLen();
                resources = Lists.newArrayList((Object[])new Resource[]{new HdfsResource(this.config, ObjectType.TABLE.getName(), (String)this.tableNames.get(0), locatedFile.getPath().toUri().toString(), fileLength)});
            } else {
                resources = this.filterMatchedRecordResources(locatedFiles);
            }
            log.info("Find {} resources in hdfs: \"{}\" success. Elapsed: {}", new Object[]{resources.size(), this.config.getHdfsUri(), stopwatch});
            ArrayList arrayList = resources;
            return arrayList;
        }
    }

    private List<Resource> filterMatchedRecordResources(List<LocatedFileStatus> locatedFiles) {
        boolean isNotUseRegularExpr = this.fileNameRegularExprPattern == null;
        ArrayList<Resource> resources = new ArrayList<Resource>(locatedFiles.size());
        for (LocatedFileStatus locatedFile : locatedFiles) {
            String tableName;
            String filePath = locatedFile.getPath().toUri().toString();
            File tempFile = new File(filePath);
            String string = tableName = isNotUseRegularExpr ? this.binding0(this.tableNames, tempFile) : this.binding1(this.tableNames, tempFile);
            if (tableName == null) {
                log.info("Cannot find a binding for \"{}\", ignore it", (Object)filePath);
                continue;
            }
            String objectTypeName = ObjectType.FILE.getName();
            if (this.parameter.isIncludeDdl()) {
                String parentPath = tempFile.getParent();
                objectTypeName = parentPath.substring(parentPath.lastIndexOf(File.separator) + 1);
            }
            resources.add(new HdfsResource(this.config, objectTypeName, tableName, filePath, locatedFile.getLen()));
            log.info("Binding table: \"{}\" to HDFS file: \"{}\" finished", (Object)tableName, (Object)filePath);
        }
        return resources;
    }

    private List<LocatedFileStatus> listLocatedFiles(FileSystem fs, String suffix) throws Exception {
        ArrayList<LocatedFileStatus> locatedFileStatusList = new ArrayList<LocatedFileStatus>();
        boolean isNotUseRegularExpr = this.fileNameRegularExprPattern == null;
        RemoteIterator ri = fs.listFiles(new Path(this.config.getHdfsUri()), true);
        while (ri.hasNext()) {
            LocatedFileStatus lfs = (LocatedFileStatus)ri.next();
            String path = lfs.getPath().toUri().getPath();
            if (!lfs.isFile()) {
                log.info("LocatedFileStatus: \"{}\" is not a file, ignore it", (Object)path);
                continue;
            }
            if (lfs.getLen() == 0L) {
                log.info("LocatedFileStatus: \"{}\" is empty, ignore it", (Object)path);
                continue;
            }
            if (isNotUseRegularExpr && !StringUtils.endsWith((CharSequence)path, (CharSequence)suffix)) {
                log.info("LocatedFileStatus: \"{}\" is unmatched, ignore it", (Object)path);
                continue;
            }
            locatedFileStatusList.add(lfs);
        }
        return locatedFileStatusList;
    }
}

