/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource.remote.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.OssStorageConfig;
import com.oceanbase.tools.loaddump.factory.ClientFactory;
import com.oceanbase.tools.loaddump.resource.AbstractResource;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.io.input.BOMInputStream;

public class OssResource
extends AbstractResource {
    private static final long serialVersionUID = 3076006476443603491L;
    private transient OSS oss;
    private String objectKey;
    private OssStorageConfig config;

    public OssResource(OssStorageConfig config, String objectType, String objectName, String objectKey, long totalSize) {
        super(objectType, objectName, totalSize);
        this.config = config;
        this.objectKey = objectKey;
        this.oss = ClientFactory.createOssClient(config);
    }

    @Override
    public String getResourcePath() {
        return FileUtils.toPath(this.config.getBucket(), this.objectKey);
    }

    @Override
    public InputStream openInputStream(String fileEncoding) throws Exception {
        InputStream is;
        OSSObject object = this.oss.getObject(this.config.getBucket(), this.objectKey);
        InputStream inputStream = is = object == null ? null : object.getObjectContent();
        if (fileEncoding != null && fileEncoding.toLowerCase(Locale.ENGLISH).startsWith("utf")) {
            return is == null ? null : new BOMInputStream(is);
        }
        return is;
    }

    @Override
    public InputStream openBoundedInputStream(String fileEncoding, long start, long end) throws Exception {
        InputStream is;
        GetObjectRequest request = new GetObjectRequest(this.config.getBucket(), this.objectKey);
        request.setRange(start, end);
        OSSObject object = this.oss.getObject(request);
        InputStream inputStream = is = object == null ? null : object.getObjectContent();
        if (fileEncoding != null && fileEncoding.toLowerCase(Locale.ENGLISH).startsWith("utf")) {
            return is == null ? null : new BOMInputStream(is);
        }
        return is;
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.oss != null) {
            this.oss.shutdown();
        }
    }

    public OssResource() {
    }
}

