/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource.remote.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.ListObjectsV2Request;
import com.aliyun.oss.model.ListObjectsV2Result;
import com.aliyun.oss.model.OSSObjectSummary;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.BaseParameter;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.OssStorageConfig;
import com.oceanbase.tools.loaddump.factory.ClientFactory;
import com.oceanbase.tools.loaddump.resource.AbstractResourceFinder;
import com.oceanbase.tools.loaddump.resource.Resource;
import com.oceanbase.tools.loaddump.resource.remote.oss.OssResource;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssResourceFinder
extends AbstractResourceFinder<Resource> {
    private static final Logger log = LoggerFactory.getLogger(OssResourceFinder.class);
    private final OssStorageConfig config;

    public OssResourceFinder(BaseParameter parameter) {
        super(parameter);
        this.config = (OssStorageConfig)parameter.getStorageConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Resource> listSchemaResources() throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(this.parameter.getFileSuffix()), (Object)"Search file suffix is null");
        OSS oss = ClientFactory.createOssClient((OssStorageConfig)this.parameter.getStorageConfig());
        try {
            ArrayList resources;
            Stopwatch stopwatch = Stopwatch.createStarted();
            DataFormat dataFormat = this.parameter.getDataFormat();
            String suffix = dataFormat == DataFormat.MIX || dataFormat == DataFormat.DDL ? this.fileSuffix : "-schema.sql";
            List<OSSObjectSummary> summaries = this.listOSSObject(oss, suffix);
            if (summaries.size() == 1 && summaries.get(0).getSize() > 0L) {
                OSSObjectSummary objectFileSummary = summaries.get(0);
                String fileKey = objectFileSummary.getKey();
                long fileLength = objectFileSummary.getSize();
                String fileName = new File(fileKey).getName();
                resources = Lists.newArrayList((Object[])new Resource[]{new OssResource(this.config, ObjectType.FILE.getName(), fileName, fileKey, fileLength)});
            } else {
                resources = this.filterMatchedSchemaResources(summaries);
            }
            log.info("Find {} resources in oss path: \"{}\" success. Elapsed: {}", new Object[]{resources.size(), this.config.getPath(), stopwatch});
            ArrayList arrayList = resources;
            return arrayList;
        }
        finally {
            if (oss != null) {
                oss.shutdown();
            }
        }
    }

    private List<Resource> filterMatchedSchemaResources(List<OSSObjectSummary> summaries) {
        ServerMode serverMode = this.parameter.getDatabase().getServerMode();
        Map<ObjectType, Set<String>> whiteListMap = this.parameter.getWhiteListMap();
        Map<ObjectType, Set<String>> blackListMap = this.parameter.getBlackListMap();
        boolean compatibleWith3rd = this.parameter.getDataFormat() == DataFormat.MIX;
        ArrayList<Resource> resources = new ArrayList<Resource>(summaries.size());
        for (OSSObjectSummary summary : summaries) {
            File tempFile = new File(summary.getKey());
            String fileName = tempFile.getName();
            String parentPath = tempFile.getParent();
            String objectTypeName = ObjectType.FILE.getName();
            if (!compatibleWith3rd && this.parameter.isIncludeDdl()) {
                objectTypeName = parentPath.substring(parentPath.lastIndexOf(File.separator) + 1);
            }
            ObjectType objectType = ObjectType.valueOfName(objectTypeName);
            if (compatibleWith3rd && objectType == ObjectType.FILE) {
                resources.add(new OssResource(this.config, objectTypeName, fileName, summary.getKey(), summary.getSize()));
                continue;
            }
            if (!whiteListMap.containsKey((Object)objectType)) continue;
            int index = fileName.lastIndexOf("-schema.sql");
            String objectName = index > 0 ? fileName.substring(0, index) : fileName;
            List<String> whiteSet = DBUtils.toCaseSensitiveNames(serverMode, (Collection<String>)whiteListMap.get((Object)objectType));
            List<String> blackSet = DBUtils.toCaseSensitiveNames(serverMode, (Collection<String>)blackListMap.get((Object)objectType));
            if (blackSet.contains(objectName) || !CollectionUtils.isEmpty(whiteSet) && !whiteSet.contains(objectName)) continue;
            resources.add(new OssResource(this.config, objectTypeName, objectName, summary.getKey(), summary.getSize()));
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Resource> listRecordResources() throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(this.parameter.getFileSuffix()), (Object)"Search file suffix is null");
        Stopwatch stopwatch = Stopwatch.createStarted();
        OSS oss = ClientFactory.createOssClient((OssStorageConfig)this.parameter.getStorageConfig());
        try {
            ArrayList resources;
            List<OSSObjectSummary> summaries = this.listOSSObject(oss, this.fileSuffix);
            if (summaries.size() == 1 && summaries.get(0).getSize() > 0L) {
                OSSObjectSummary objectFileSummary = summaries.get(0);
                String fileKey = objectFileSummary.getKey();
                long fileLength = objectFileSummary.getSize();
                resources = Lists.newArrayList((Object[])new Resource[]{new OssResource(this.config, ObjectType.TABLE.getName(), (String)this.tableNames.get(0), fileKey, fileLength)});
            } else {
                resources = this.filterMatchedRecordResources(summaries);
            }
            log.info("Find {} resources in oss path: \"{}\" success. Elapsed: {}", new Object[]{resources.size(), this.config.getPath(), stopwatch});
            ArrayList arrayList = resources;
            return arrayList;
        }
        finally {
            if (oss != null) {
                oss.shutdown();
            }
        }
    }

    private List<Resource> filterMatchedRecordResources(List<OSSObjectSummary> summaries) {
        boolean isNotUseRegularExpr = this.fileNameRegularExprPattern == null;
        ArrayList<Resource> resources = new ArrayList<Resource>(summaries.size());
        for (OSSObjectSummary summary : summaries) {
            String tableName;
            File tempFile = new File(summary.getKey());
            String string = tableName = isNotUseRegularExpr ? this.binding0(this.tableNames, tempFile) : this.binding1(this.tableNames, tempFile);
            if (tableName == null) {
                log.info("Cannot find a binding for \"{}\", ignore it", (Object)summary.getKey());
                continue;
            }
            String objectTypeName = ObjectType.FILE.getName();
            if (this.parameter.isIncludeDdl()) {
                String parentPath = tempFile.getParent();
                objectTypeName = parentPath.substring(parentPath.lastIndexOf(File.separator) + 1);
            }
            resources.add(new OssResource(this.config, objectTypeName, tableName, summary.getKey(), summary.getSize()));
            log.info("Binding table: \"{}\" to OSSObject: \"{}\" finished", (Object)tableName, (Object)summary.getKey());
        }
        return resources;
    }

    private List<OSSObjectSummary> listOSSObject(OSS ossClient, String suffix) {
        ListObjectsV2Result result;
        String nextContinuationToken = null;
        ArrayList<OSSObjectSummary> ossObjectSummaries = new ArrayList<OSSObjectSummary>();
        boolean isNotUseRegularExpr = this.fileNameRegularExprPattern == null;
        do {
            ListObjectsV2Request request = new ListObjectsV2Request(this.config.getBucket());
            request.setPrefix(this.config.getPath());
            request.withMaxKeys(Integer.valueOf(1000));
            request.setContinuationToken(nextContinuationToken);
            result = ossClient.listObjectsV2(request);
            nextContinuationToken = result.getNextContinuationToken();
            List summaries = result.getObjectSummaries();
            for (OSSObjectSummary summary : summaries) {
                String key = summary.getKey();
                if (summary.getSize() < 1L) {
                    log.info("OSSObject: \"{}\" is empty, ignore it", (Object)key);
                    continue;
                }
                if (isNotUseRegularExpr && !StringUtils.endsWith((CharSequence)key, (CharSequence)suffix)) {
                    log.info("OSSObject: \"{}\" is unmatched, ignore it", (Object)key);
                    continue;
                }
                ossObjectSummaries.add(summary);
            }
        } while (result.isTruncated());
        return ossObjectSummaries;
    }
}

