/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource.remote.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.BaseParameter;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.S3StorageConfig;
import com.oceanbase.tools.loaddump.factory.ClientFactory;
import com.oceanbase.tools.loaddump.resource.AbstractResourceFinder;
import com.oceanbase.tools.loaddump.resource.Resource;
import com.oceanbase.tools.loaddump.resource.remote.s3.S3Resource;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ResourceFinder
extends AbstractResourceFinder<Resource> {
    private static final Logger log = LoggerFactory.getLogger(S3ResourceFinder.class);
    private final S3StorageConfig config;

    public S3ResourceFinder(BaseParameter parameter) {
        super(parameter);
        this.config = (S3StorageConfig)parameter.getStorageConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Resource> listSchemaResources() throws Exception {
        ArrayList resources;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(this.parameter.getFileSuffix()), (Object)"Search file suffix is null");
        AmazonS3 client = ClientFactory.createS3Client((S3StorageConfig)this.parameter.getStorageConfig());
        Stopwatch stopwatch = Stopwatch.createStarted();
        DataFormat dataFormat = this.parameter.getDataFormat();
        String suffix = dataFormat == DataFormat.MIX || dataFormat == DataFormat.DDL ? this.fileSuffix : "-schema.sql";
        try {
            boolean isFile;
            List<S3ObjectSummary> objects = this.listS3Objects(client, suffix);
            boolean bl = isFile = objects.size() == 1 && objects.get(0).getSize() > 0L;
            if (isFile) {
                S3ObjectSummary obj = objects.get(0);
                File file = new File(obj.getKey());
                resources = Lists.newArrayList((Object[])new Resource[]{new S3Resource(this.config, ObjectType.FILE.getName(), file.getName(), obj.getKey(), obj.getSize())});
            } else {
                resources = this.filterMatchedSchemaResources(objects);
            }
            log.info("Find {} resources in S3 path: \"{}\" success. Elapsed: {}", new Object[]{resources.size(), this.config.getPath(), stopwatch});
        }
        finally {
            client.shutdown();
        }
        return resources;
    }

    private List<Resource> filterMatchedSchemaResources(List<S3ObjectSummary> objects) {
        ServerMode serverMode = this.parameter.getDatabase().getServerMode();
        Map<ObjectType, Set<String>> whiteListMap = this.parameter.getWhiteListMap();
        Map<ObjectType, Set<String>> blackListMap = this.parameter.getBlackListMap();
        ArrayList<Resource> resources = new ArrayList<Resource>(objects.size());
        for (S3ObjectSummary obj : objects) {
            File tempFile = new File(obj.getKey());
            String fileName = tempFile.getName();
            String parentPath = tempFile.getParent();
            String objectTypeName = ObjectType.FILE.getName();
            if (this.parameter.getDataFormat() != DataFormat.MIX && this.parameter.isIncludeDdl()) {
                objectTypeName = parentPath.substring(parentPath.lastIndexOf(File.separator) + 1);
            }
            ObjectType objectType = ObjectType.valueOfName(objectTypeName);
            if (this.parameter.getDataFormat() == DataFormat.MIX && objectType == ObjectType.FILE) {
                resources.add(new S3Resource(this.config, objectTypeName, fileName, obj.getKey(), obj.getSize()));
                continue;
            }
            if (!whiteListMap.containsKey((Object)objectType)) continue;
            int index = fileName.lastIndexOf("-schema.sql");
            String objectName = index > 0 ? fileName.substring(0, index) : fileName;
            List<String> whiteSet = DBUtils.toCaseSensitiveNames(serverMode, (Collection<String>)whiteListMap.get((Object)objectType));
            List<String> blackSet = DBUtils.toCaseSensitiveNames(serverMode, (Collection<String>)blackListMap.get((Object)objectType));
            if (blackSet.contains(objectName) || !CollectionUtils.isEmpty(whiteSet) && !whiteSet.contains(objectName)) continue;
            resources.add(new S3Resource(this.config, objectTypeName, objectName, obj.getKey(), obj.getSize()));
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Resource> listRecordResources() throws Exception {
        ArrayList resources;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(this.parameter.getFileSuffix()), (Object)"Search file suffix is null");
        AmazonS3 client = ClientFactory.createS3Client((S3StorageConfig)this.parameter.getStorageConfig());
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            List<S3ObjectSummary> objects = this.listS3Objects(client, this.fileSuffix);
            if (objects.size() == 1 && objects.get(0).getSize() > 0L) {
                S3ObjectSummary obj = objects.get(0);
                resources = Lists.newArrayList((Object[])new Resource[]{new S3Resource(this.config, ObjectType.TABLE.getName(), (String)this.tableNames.get(0), obj.getKey(), obj.getSize())});
            } else {
                resources = this.filterMatchedRecordResources(objects);
            }
            log.info("Find {} resources in S3 path: \"{}\" success. Elapsed: {}", new Object[]{resources.size(), this.config.getPath(), stopwatch});
        }
        finally {
            client.shutdown();
        }
        return resources;
    }

    private List<Resource> filterMatchedRecordResources(List<S3ObjectSummary> objects) {
        boolean isNotUseRegularExpr = this.fileNameRegularExprPattern == null;
        ArrayList<Resource> resources = new ArrayList<Resource>(objects.size());
        for (S3ObjectSummary obj : objects) {
            String tableName;
            File tempFile = new File(obj.getKey());
            String string = tableName = isNotUseRegularExpr ? this.binding0(this.tableNames, tempFile) : this.binding1(this.tableNames, tempFile);
            if (tableName == null) {
                log.info("Cannot find a binding for \"{}\", ignore it", (Object)obj.getKey());
                continue;
            }
            String objectTypeName = ObjectType.FILE.getName();
            if (this.parameter.isIncludeDdl()) {
                String parentPath = tempFile.getParent();
                objectTypeName = parentPath.substring(parentPath.lastIndexOf(File.separator) + 1);
            }
            resources.add(new S3Resource(this.config, objectTypeName, tableName, obj.getKey(), obj.getSize()));
            log.info("Binding table: \"{}\" to S3 Object: \"{}\" finished", (Object)tableName, (Object)obj.getKey());
        }
        return resources;
    }

    private List<S3ObjectSummary> listS3Objects(AmazonS3 client, String suffix) {
        ListObjectsV2Result result;
        String nextContinuationToken = null;
        boolean isNotUseRegularExpr = this.fileNameRegularExprPattern == null;
        ArrayList<S3ObjectSummary> objectList = new ArrayList<S3ObjectSummary>();
        do {
            ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(this.config.getBucket()).withPrefix(this.config.getPath()).withMaxKeys(Integer.valueOf(1000)).withContinuationToken(nextContinuationToken);
            result = client.listObjectsV2(request);
            nextContinuationToken = result.getNextContinuationToken();
            List objs = result.getObjectSummaries();
            objectList.addAll(objs.stream().filter(o -> o.getSize() > 1L && (!isNotUseRegularExpr || StringUtils.endsWith((CharSequence)o.getKey(), (CharSequence)suffix))).collect(Collectors.toList()));
        } while (result.isTruncated());
        return objectList;
    }
}

