/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.builder;

import com.oceanbase.tools.loaddump.common.exception.DatabaseAccessException;
import com.oceanbase.tools.loaddump.configure.Configure;
import com.oceanbase.tools.loaddump.schema.AbstractDatabase;
import com.oceanbase.tools.loaddump.schema.accessor.MetadataAccessorFactory;
import com.oceanbase.tools.loaddump.schema.builder.DatabaseBuilder;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDatabaseBuilderImpl
implements DatabaseBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseBuilderImpl.class);

    @Override
    public AbstractDatabase build(Configure configure) {
        if (CollectionUtils.isEmpty(configure.getIncludeObjectTypes())) {
            log.warn("Include types is empty. Ignore schema: {}", (Object)configure.getSchemaName());
            return MetadataAccessorFactory.emptyDatabase(configure);
        }
        try {
            return MetadataAccessorFactory.get(configure).queryMetadata();
        }
        catch (Exception ex) {
            throw new DatabaseAccessException(ex);
        }
    }
}

