/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.model;

import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.schema.model.ChangeInfo;
import com.oceanbase.tools.loaddump.schema.model.ObjectStatus;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ObjectDefine {
    private final String ddlType;
    private final String objectType;
    private final String objectName;
    private final String objectStatus;
    private final String objectGrammar;
    private final List<ObjectDefine> subObjectDefines = new ArrayList<ObjectDefine>();
    private final List<ChangeInfo> changeInfos = new ArrayList<ChangeInfo>();
    private String groupId = UUID.randomUUID().toString();
    private int sequenceId = 0;

    protected ObjectDefine(ObjectType objectType, String objectName, ObjectStatus objectStatus, String objectGrammar) {
        this(objectType, objectName, objectStatus, objectGrammar, new ArrayList<ObjectDefine>());
    }

    protected ObjectDefine(ObjectType objectType, String objectName, ObjectStatus objectStatus, String objectGrammar, List<ObjectDefine> subObjectDefines) {
        this.objectType = objectType.getName();
        this.objectName = objectName;
        this.objectStatus = objectStatus.name();
        this.objectGrammar = objectGrammar;
        this.ddlType = objectStatus.getDdlType().name();
        CollectionUtils.addAllIgnoreNull(this.getSubObjectDefines(), subObjectDefines);
    }

    public String getCoordinate() {
        return "[" + this.getObjectType() + "]" + this.getObjectName();
    }

    public String getDdlType() {
        return this.ddlType;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectStatus() {
        return this.objectStatus;
    }

    public String getObjectGrammar() {
        return this.objectGrammar;
    }

    public List<ObjectDefine> getSubObjectDefines() {
        return this.subObjectDefines;
    }

    public List<ChangeInfo> getChangeInfos() {
        return this.changeInfos;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }
}

