/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.obmysql;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractIndex;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlIndexPartition;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSchema;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.List;

public class ObMySqlIndex
extends AbstractIndex {
    private int nonunique;
    private String collation;
    private long cardinality;
    private ObMySqlIndexPartition indexPartition;
    private String subPart;
    private String packed;
    private String nullable;
    private String comment;
    private String indexComment;
    private String visible;
    private String locality;

    public ObMySqlIndex(ObMySqlSchema schema) {
        super(schema);
    }

    @Override
    public ObMySqlSchema getSchema() {
        return (ObMySqlSchema)super.getSchema();
    }

    public void setSchema(ObMySqlSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        ObMySqlIndexPartition indexPartition;
        StringBuilder sb = new StringBuilder();
        sb.append("create");
        String indexType = this.getIndexType();
        if (ObjectType.UNIQUE.equals(indexType)) {
            sb.append(" ").append((Object)ObjectType.UNIQUE);
        } else if ("GLOBAL".equals(indexType)) {
            this.setLocality("GLOBAL");
        } else if ("LOCAL".equals(indexType)) {
            this.setLocality("LOCAL");
        } else if ("GLOBAL UNIQUE".equals(indexType)) {
            this.setLocality("GLOBAL");
            sb.append(" ").append((Object)ObjectType.UNIQUE);
        } else if ("LOCAL UNIQUE".equals(indexType)) {
            this.setLocality("LOCAL");
            sb.append(" ").append((Object)ObjectType.UNIQUE);
        } else if ("FULLTEXT".equals(indexType)) {
            sb.append(" ").append("FULLTEXT");
        }
        sb.append(" index ").append(this.getWrappedIndexName());
        sb.append(" on ").append(this.getSchemaObjectName()).append((CharSequence)this.joinIndexColumns());
        if (StringUtils.isNotBlank(this.getLocality())) {
            sb.append(" ").append(this.getLocality());
        }
        if (StringUtils.isNotEmpty(this.getIndexComment())) {
            sb.append(" ").append("comment '").append(this.getIndexComment().replace("'", "''")).append("'");
        }
        if ((indexPartition = this.getIndexPartition()) != null) {
            sb.append((CharSequence)indexPartition.buildGrammar());
        }
        if ("NO".equals(this.getVisible())) {
            sb.append(" invisible");
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.INDEX, this.getSimpleIndexName(), this.terminate(sb))});
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    @Override
    public String toString() {
        return "ObMySqlIndex(nonunique=" + this.getNonunique() + ", collation=" + this.getCollation() + ", cardinality=" + this.getCardinality() + ", indexPartition=" + this.getIndexPartition() + ", subPart=" + this.getSubPart() + ", packed=" + this.getPacked() + ", nullable=" + this.getNullable() + ", comment=" + this.getComment() + ", indexComment=" + this.getIndexComment() + ", visible=" + this.getVisible() + ", locality=" + this.getLocality() + ")";
    }

    public ObMySqlIndex() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObMySqlIndex)) {
            return false;
        }
        ObMySqlIndex other = (ObMySqlIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getNonunique() != other.getNonunique()) {
            return false;
        }
        if (this.getCardinality() != other.getCardinality()) {
            return false;
        }
        String this$collation = this.getCollation();
        String other$collation = other.getCollation();
        if (this$collation == null ? other$collation != null : !this$collation.equals(other$collation)) {
            return false;
        }
        ObMySqlIndexPartition this$indexPartition = this.getIndexPartition();
        ObMySqlIndexPartition other$indexPartition = other.getIndexPartition();
        if (this$indexPartition == null ? other$indexPartition != null : !((Object)this$indexPartition).equals(other$indexPartition)) {
            return false;
        }
        String this$subPart = this.getSubPart();
        String other$subPart = other.getSubPart();
        if (this$subPart == null ? other$subPart != null : !this$subPart.equals(other$subPart)) {
            return false;
        }
        String this$packed = this.getPacked();
        String other$packed = other.getPacked();
        if (this$packed == null ? other$packed != null : !this$packed.equals(other$packed)) {
            return false;
        }
        String this$nullable = this.getNullable();
        String other$nullable = other.getNullable();
        if (this$nullable == null ? other$nullable != null : !this$nullable.equals(other$nullable)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$indexComment = this.getIndexComment();
        String other$indexComment = other.getIndexComment();
        if (this$indexComment == null ? other$indexComment != null : !this$indexComment.equals(other$indexComment)) {
            return false;
        }
        String this$visible = this.getVisible();
        String other$visible = other.getVisible();
        if (this$visible == null ? other$visible != null : !this$visible.equals(other$visible)) {
            return false;
        }
        String this$locality = this.getLocality();
        String other$locality = other.getLocality();
        return !(this$locality == null ? other$locality != null : !this$locality.equals(other$locality));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObMySqlIndex;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getNonunique();
        long $cardinality = this.getCardinality();
        result = result * 59 + (int)($cardinality >>> 32 ^ $cardinality);
        String $collation = this.getCollation();
        result = result * 59 + ($collation == null ? 43 : $collation.hashCode());
        ObMySqlIndexPartition $indexPartition = this.getIndexPartition();
        result = result * 59 + ($indexPartition == null ? 43 : ((Object)$indexPartition).hashCode());
        String $subPart = this.getSubPart();
        result = result * 59 + ($subPart == null ? 43 : $subPart.hashCode());
        String $packed = this.getPacked();
        result = result * 59 + ($packed == null ? 43 : $packed.hashCode());
        String $nullable = this.getNullable();
        result = result * 59 + ($nullable == null ? 43 : $nullable.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $indexComment = this.getIndexComment();
        result = result * 59 + ($indexComment == null ? 43 : $indexComment.hashCode());
        String $visible = this.getVisible();
        result = result * 59 + ($visible == null ? 43 : $visible.hashCode());
        String $locality = this.getLocality();
        result = result * 59 + ($locality == null ? 43 : $locality.hashCode());
        return result;
    }

    public int getNonunique() {
        return this.nonunique;
    }

    public void setNonunique(int nonunique) {
        this.nonunique = nonunique;
    }

    public String getCollation() {
        return this.collation;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public long getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(long cardinality) {
        this.cardinality = cardinality;
    }

    public ObMySqlIndexPartition getIndexPartition() {
        return this.indexPartition;
    }

    public void setIndexPartition(ObMySqlIndexPartition indexPartition) {
        this.indexPartition = indexPartition;
    }

    public String getSubPart() {
        return this.subPart;
    }

    public void setSubPart(String subPart) {
        this.subPart = subPart;
    }

    public String getPacked() {
        return this.packed;
    }

    public void setPacked(String packed) {
        this.packed = packed;
    }

    public String getNullable() {
        return this.nullable;
    }

    public void setNullable(String nullable) {
        this.nullable = nullable;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getIndexComment() {
        return this.indexComment;
    }

    public void setIndexComment(String indexComment) {
        this.indexComment = indexComment;
    }

    public String getVisible() {
        return this.visible;
    }

    public void setVisible(String visible) {
        this.visible = visible;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }
}

